      SUBROUTINE PROCHT
C! Produce the graphics SC
      INCLUDE 'params.h'
      INCLUDE 'jobcom.h'
      INCLUDE 'lunits.h'
      INCLUDE 'trecom.h'
      INCLUDE 'tables.h'
      INCLUDE 'hashnm.h'
      INTEGER SEARCH
      EXTERNAL SEARCH
      LOGICAL OK
C
C
      WRITE(LOUT,'(A)') ' '
      WRITE(LOUT,'(A)') ' PROCHT Begins ....'
      WRITE(LOUT,'(A)') ' '
C
C check for first procedure unknown
C
      IF(CTREE.EQ.'$$$$') THEN
        MXCALL = 0
C
C find all top-level procedures. Select one with max calls
C
        DO 700 IP=1,NPROC
          IF(PROCED_NCALLEDBY(IP).GT.0) GOTO 700
          WRITE(LOUT,'(A)') ' Procedure '//PROCED_NAME(IP)//
     &                      ' is a top-level node (no callers)'
          IF(PROCED_NCALLS(IP).LE.MXCALL) GOTO 700   
          MXCALL = PROCED_NCALLS(IP)
          CTREE = PROCED_NAME(IP)
  700   CONTINUE
        WRITE(LOUT,'(/,A,I3,A)') ' Procedure '//CTREE//
     &      'selected with the ',MXCALL,' procedures it calls ...'
      ENDIF
C
      IF(.NOT.LEXT) WRITE(LOUT,551)
  551 FORMAT(' EXTERNAL procedure names will not appear ',/)
C
      CNAM = CTREE
C
C find top node program
C
      IPNAM = SEARCH(CNAM)
      IF(IPNAM.EQ.0) GOTO 900
      IF(PROCED_NCALLS(IPNAM).EQ.0) GOTO 950
C
C initialise all places in the chart
C
      DO 1 I=0,NXPOS
        DO 2 J=1,NYPOS
          CPLACE(I,J)(:MXNAM) = ' '
          CPLACE(-I,J) = CPLACE(I,J)
    2   CONTINUE
    1 CONTINUE
C
      MXLEV = 1
      NLEFT = 1
      INEXT(1) = IPNAM
      NUMBER(ILEV) = 0
      PROCED_LEVEL(IPNAM) = 1
C
C Assign levels to all procedures
C
   10 CONTINUE
      IF(NLEFT.LE.0) GOTO 20
C
C Take the last in the list
C
      IPNAM = INEXT(NLEFT)
      NLEFT = NLEFT - 1
      ILEV = PROCED_LEVEL(IPNAM)     
      DO 11 IC=1,PROCED_NCALLS(IPNAM)
         IPNAM2 = PROCED_CALLS(IPNAM,IC)
         IF(.NOT.LEXT.AND.PROCED_EXTERN(IPNAM2)) GOTO 11
         IF(PROCED_LEVEL(IPNAM2).LE.ILEV) THEN
            PROCED_LEVEL(IPNAM2) = ILEV + 1
            IEXT = 0
            IF(PROCED_EXTERN(IPNAM2)) IEXT=1
            IF(PROCED_LEVEL(IPNAM2).GT.MXLEV) THEN
               IF((IEXT.EQ.1.AND.LEXT).OR.IEXT.EQ.0) THEN
                 MXLEV = PROCED_LEVEL(IPNAM2)
               ENDIF
            ENDIF
C
C before adding to list, check not already there ....
C
            DO 12 IL=1,NLEFT
               IF(INEXT(IL).EQ.IPNAM2) GOTO 11
   12       CONTINUE
            IF(NLEFT.GE.MXLFT) GOTO 960
            NLEFT = NLEFT + 1
            INEXT(NLEFT) = IPNAM2
         ENDIF
   11 CONTINUE
      GOTO 10            
C
C Start to allocate positions in the chart
C The chart has NUMMAX x positions, and MXLEV y positions
C
   20 CONTINUE
      NUMMAX = 0
      DO 4 I=1,NYPOS
        NUMBER(I) = 0
    4 CONTINUE
      DO 23 I=1,NPROC
        IF(PROCED_LEVEL(I).LE.1) GOTO 23
        IF(.NOT.LEXT.AND.PROCED_EXTERN(I)) GOTO 23
        N = NUMBER(PROCED_LEVEL(I))+1
        NUMBER(PROCED_LEVEL(I)) = N
        IF (N.GT.NUMMAX) NUMMAX = N
   23 CONTINUE
      ITREE = SEARCH(CTREE)
      DO 28 I=1,NPROC
        PROCED_DONE(I) = .FALSE.
   28 CONTINUE
      NSTEP = NINT(REAL(NUMMAX+1)*0.5)
      IF(NSTEP.GT.NXPOS) GOTO 930
      DO 25 I=1,NPROC
        IF(PROCED_LEVEL(I).LE.1.AND.I.NE.ITREE) GOTO 25
        IF(PROCED_DONE(I)) GOTO 25
        IF(.NOT.LEXT.AND.PROCED_EXTERN(I)) GOTO 25
        ILEV = PROCED_LEVEL(I)
        DO 26 IXP = 0,NSTEP
          IF(CPLACE(-IXP,ILEV)(:1).EQ.' ') THEN
            CPLACE(-IXP,ILEV) = PROCED_NAME(I)
            IXPOS(I) = -IXP
            PROCED_DONE(I) = .TRUE.
            GOTO 27
          ENDIF
          IF(CPLACE(IXP,ILEV)(:1).EQ.' ') THEN
            CPLACE(IXP,ILEV) = PROCED_NAME(I)
            IXPOS(I) = IXP
            PROCED_DONE(I) = .TRUE.
            GOTO 27
          ENDIF
   26   CONTINUE
   27   CONTINUE
        IF(.NOT.PROCED_DONE(I)) GOTO 940
        IF(PROCED_NCALLS(I).EQ.0) GOTO 25
        IXPOSI = IXPOS(I)
        DO 35 ICALLED = 1,PROCED_NCALLS(I)
          IOTHER = PROCED_CALLS(I,ICALLED)
          IF(PROCED_DONE(IOTHER)) GOTO 35
          IF(.NOT.LEXT.AND.PROCED_EXTERN(IOTHER)) GOTO 35
          ILEVO = PROCED_LEVEL(IOTHER)
          ISTART = MAX(-NSTEP,IXPOSI - ILEVO + ILEV + 1)
          DO 36 IPOS=ISTART,-NSTEP,-1
            IF(CPLACE(IPOS,ILEVO)(:1).EQ.' ') THEN
              PROCED_DONE(IOTHER) = .TRUE.
              CPLACE(IPOS,ILEVO) = PROCED_NAME(IOTHER)
              IXPOS(IOTHER) = IPOS
              GOTO 35
            ENDIF
   36     CONTINUE
          DO 37 IPOS=ISTART,NSTEP
            IF(CPLACE(IPOS,ILEVO)(:1).EQ.' ') THEN
              PROCED_DONE(IOTHER) = .TRUE.
              CPLACE(IPOS,ILEVO) = PROCED_NAME(IOTHER)
              IXPOS(IOTHER) = IPOS
              GOTO 35
            ENDIF
   37     CONTINUE
   35   CONTINUE
   25 CONTINUE
C
C This is the end of the simple cut at chart positioning
C
C
C Write a text representation of the chart as an indication only
C
      WRITE(LOUT,'(A)') ' The chart will look roughly like this ...'
      WRITE(LOUT,501)
      DO 41 IL=1,MXLEV
         WRITE(LOUT,*) (CPLACE(IS,IL)(:8),IS=-NSTEP,NSTEP)
   41 CONTINUE
      WRITE(LOUT,501)
  501 FORMAT(1X,79('-'))
C
C begin calculating the sizes of objects for the plot
C
      WRITE(LOUT,'(A)') ' PROCHT : START CREATING PLOT'
      BOXX = 18.
      BOXY = 7.
      GAPX = 5.
      GAPY = 12.
      SIZEX = (NUMMAX+2)*BOXX + (NUMMAX+3)*GAPX
      SIZEY = MXLEV*BOXY + (MXLEV+1)*GAPY
      SIZEX = MAX(SIZEX,SIZEY)
      SIZEY = SIZEX
      GAPY = MAX(GAPY,(SIZEY-MXLEV*BOXY)/(MXLEV+1))
      GAP = MIN(GAPX,GAPY)
C
C Initialise GRAPHICS
C
      CALL GRINIT(SIZEX,SIZEY,CTREE)
C
C Draw inner box around area
C
      CALL CHTBOX(GAP*0.5,GAP*0.5,SIZEX-GAP*0.5,SIZEY-GAP*0.5)
C
C Start looping over all modules to plot their positions
C
      DO 29 J=1,MXLEV
        DO 31 I=-NSTEP,NSTEP
          IF(CPLACE(I,J)(:1).EQ.' ') GOTO 31
          IP = NSTEP+I
          XLOW = GAPX + IP*(BOXX+GAPX)
          YLOW = SIZEY - J*(GAPY+BOXY)
          INUM = SEARCH(CPLACE(I,J))
          IF(INUM.EQ.0) GOTO 31
          XBOX(INUM) = XLOW+BOXX*0.5
          YBOX(INUM) = YLOW+BOXY*0.5
          LCP = LENOCC(CPLACE(I,J))
          CALL GTX(XLOW+BOXX/25.,YLOW+BOXY*0.5,CPLACE(I,J)(:LCP))
          CALL CHTBOX(XLOW,YLOW,XLOW+BOXX,YLOW+BOXY)
   31   CONTINUE
   29 CONTINUE
C
C Now loop over all modules to plot their connections
C
      DO 32 J=1,MXLEV-1
         DO 33 I=-NSTEP,NSTEP
            IF(CPLACE(I,J)(:1).EQ.' ') GOTO 33
            IPNAM = SEARCH(CPLACE(I,J))
            IF(PROCED_NCALLS(IPNAM).EQ.0) GOTO 33
            X1 = XBOX(IPNAM)
            Y1 = YBOX(IPNAM)
            DO 34 IC=1,PROCED_NCALLS(IPNAM)
               IPNAM2 = PROCED_CALLS(IPNAM,IC)
               IF(.NOT.LEXT.AND.PROCED_EXTERN(IPNAM2)) GOTO 34
               CALL CHTLIN(X1,Y1,XBOX(IPNAM2),YBOX(IPNAM2),
     &                     BOXX,BOXY)
   34       CONTINUE
   33    CONTINUE
   32 CONTINUE
C
C Close the graphics package
C
      CALL GRCLOSE
C
C
C finished all trees. home to beddy-bies
C
      WRITE(LOUT,'(A)') ' PROCHT Finished'
      GOTO 999
C
  900 WRITE(LOUT,901) CNAM
  901 FORMAT(1X,'PROCHT : TOPNODE ',A,' NOT FOUND IN PROCEDURE TABLE')
      GOTO 999
  930 WRITE(LOUT,931) 
  931 FORMAT(1X,'PROCHT : NOT ENOUGH SPACE ON THE GRAPH')
      GOTO 999
  940 WRITE(LOUT,941) PROCED_NAME(I)
  941 FORMAT(1X,'PROCHT : NO SPACE FOR ROUTINE ',A)
      GOTO 999
  950 WRITE(LOUT,951) CNAM
  951 FORMAT(1X,'PROCHT : ROUTINE ',A,' CALLS NO OTHER ROUTINES!')
      GOTO 999
  960 WRITE(LOUT,961) MXLFT
  961 FORMAT(1X,'PROCHT : ',I5,' STACK OVERFLOW; TREE TOO COMPLICATED!')
C      
  999 CONTINUE
      END
