#include <signal.h>
#include <string.h>
#include "global.h"
#include "manager.h"
#include "symbol.h"
#include "concon.h"
#include "manager.fdf"
#include "format.fdf"
#include "states.fdf"
#include "service.fdf"
#include "parser.fdf"
#include "input.fdf"
#ifndef  INTER_ATTENTION
#include <conio.h>
#endif



#ifdef  INTER_ATTENTION
extern void    proMain_requestAttention( int sig );
#endif
extern State   *stateSpaceP;
extern long    stateSpaceSize, statesFree;
State          *freeStatesP; 

/*
	The standard states that come with concon.
*/

void action_main( void )
	{
#ifndef  INTER_ATTENTION
    if (_kbhit())
        requestAttention = TRUE;
#endif
    if (
	(requestAttention  || 
	 stateP->nextProcessStateP == stateSpaceP) &&
	!(programHalted)
	   )
		{
		if (requestAttention )
			{
#ifdef  INTER_ATTENTION
            signal( SIGINT, proMain_requestAttention );
#endif
            requestAttention = FALSE;
			}
		proState_readAndStart();
		}
	}

void action_read( void )
	{
	general( FALSE );
	}

void action_preFix( void )
	{
	general( TRUE );
	}
	
void general( Inherit preFix )
	{
	List *currentP = stateP->readP;
	List buffer;
	actionFuncType = stateP->actionFuncP;

/*  The end of the line. */
	if (currentP == NULL)
		{
		proState_appendToReturn( stateP->prevStateP,
			stateP->returnP->nextP );
		proState_pop();
		return;
		}

/*  Step forward one. */
	stateP->readP = stateP->readP->nextP;
	if (stateP->actionFuncP == action_preFix)
		stateP->actionFuncP =  action_read;
	if (actionFuncP != action_preFix)
		actionFuncP =  action_read;

/*  Just copy the current element if necessary. */
    if (currentP->u.p.quoted           ||
        currentP->u.p.type == INTEGER ||
        currentP->u.p.type == REAL    ||
        currentP->u.p.type == LITERAL )
		{
		if (preFix )
			{
			proFor_print("\nERROR - Not an operator...");
			exit_state();
			return;
			}
		buffer = *currentP;
        buffer.u.p.quoted = buffer.u.p.locked = FALSE;
		proState_copySingleToReturn( stateP, &buffer );
		return;
		}

/* Unpacking of the atoms. */
	if (preFix && 
            (currentP->u.p.type == ALPHA || currentP->u.p.type == KEYWORD))
		stateP->operatorP = currentP;

    if (currentP->u.p.type == ALPHA ||
        currentP->u.p.type == KEYWORD)
		{
		List *dataP;
		dataP = *cc_variable( stateP, currentP );	
		
		if (dataP == NULL)
			{
			if (preFix )
				{
				proFor_print("\nERROR - Not an operator...");
				exit_state();
				return;
				}
			proState_copySingleToReturn( stateP, currentP );
			return;
			}
        if (dataP->u.p.type == ACTIONFUNC)
			{
			if (preFix )
				stateP->actionFuncP = dataP->data.actionFuncP;
			else
				proState_copySingleToReturn( stateP, currentP );
			return;
			}
		proState_request( REQ_NEWSTATE, dataP, actionFuncP );
		return;
		}
    if (currentP->u.p.type == SUBLIST)
		{
		proState_request( REQ_NEWSTATE, currentP->data.dataP,
				action_preFix );
		return;
		}
/*  Error message here!!! Shouldn't be here!!! */	
	proFor_print("\nERROR - Unexecutable Code...");
	exit_state();
	}

void exit_state( void )
	{
	char buf[40];
	
	sprintf( buf, "\nError in line %d.", stateP->lineNo );
	proFor_print( buf );
	proFor_print("\nTerminated..." );
	stateP->request = REQ_HALTED;
	}


/*
	State space manipulation.
*/
void proState_clear( State *stP, Inherit cleanUp )
	{
	if (stP->returnP != NULL)
        if (stP->returnP->u.p.type == DESCRIPTOR)
			cc_freeDescr( &stP->returnP );
    if (cleanUp)
		{
		stP->token = NOTOKEN;
		stP->brackets = 0;
		stP->termStarted = stP->quoted = FALSE;
		stP->newLiner = TRUE;
		stP->inP = NULL;
		stP->readInP = NULL;
		stP->lineNo = 0;
		stP->endOfFile=FALSE;
		stP->outP = NULL;
		stP->process = stP->parentProcess = 0;
		stP->nextProcessStateP = 
		stP->prevProcessStateP = stateSpaceP;
		stP->execP = stP->returnP = stP->readP = stP->writeP = 
		stP->localP = stP->req.newReadP = stP->titleP = 
		stP->operatorP = NULL;
		stP->walkerP = stP->inputMarkP = stP->lookAheadP = NULL;
		stP->actionFuncP = stP->req.actionFuncP = nofunc;
		stP->request    = REQ_NONE;
		}
	stP->validState = FALSE;
	stP->prevStateP = freeStatesP;
	freeStatesP = stP;
	}

/*  Clear the state space. */
void proState_clearStateSpace( void )
	{
	int i, total = (int)(listSize/(sizeof(List)));
	List new;

	freeStatesP = stateSpaceP;	
	statesFree  = stateSpaceSize-1;
    for (i=0;i<stateSpaceSize;i++)
        {
        stateSpaceP[i].returnP = NULL;
        proState_clear( &stateSpaceP[i], TRUE );
        }
    stateP = stateSpaceP;

/* Removing all descriptors. */
    for (i=0;i<total;i++)
        if (listPoolP[i].u.p.type == DESCRIPTOR)
			cc_clearLElm( &listPoolP[i] );

/* IO stuff. */
    cc_clearLElm( &new );
    cc_makeAtom( &new, "\"user-in\"");
    cc_newDescr( &inDescrP, NULL );
    cc_copyAndInsert( inDescrP, &new, FALSE );
    proMem_lookup( "\"user-in\"" )->nextP = stdin;
    cc_clearLElm( &new );
    cc_makeAtom( &new, "\"user-out\"");
    cc_newDescr( &outDescrP, NULL );
    cc_copyAndInsert( outDescrP, &new, FALSE );
    proMem_lookup( "\"user-out\"" )->nextP = stdout;

    cc_makeAtom( &new, "TRUE" );
    cc_newDescr( &trueDescrP, NULL );
    cc_copyAndInsert( trueDescrP, &new, FALSE );
    cc_makeAtom( &new, "FALSE" );
    cc_newDescr( &falseDescrP, NULL );
    cc_copyAndInsert( falseDescrP, &new, FALSE );

/* Set the main state. */
    stateP->validState = TRUE;
    stateP->actionFuncP = action_main;
    stateP->inP  = inDescrP->nextP;
    stateP->outP = outDescrP->nextP;
    stateP->readInP = readInBuf;
    }

void proState_testForJam( void )
	{
	State *trP = stateSpaceP;
    Descr *descrP;

/* Is State space jammed ? */
	if (freeStatesP != stateSpaceP)
		return;
	while (trP->nextProcessStateP != stateSpaceP)
		{
		trP = trP->nextProcessStateP;
		if (trP->request == REQ_NONE)
			return;
		}
		
/* Yes! Now halt every state. */
	proFor_print("\nERROR - Processes jammed, not enough space.\nAll processes terminated ...\n");
    proFor_print("\nGenerating Stack Images ...\n");
    trP = stateSpaceP;

    while (trP->nextProcessStateP != stateSpaceP)
        {
        trP = trP->nextProcessStateP;
        descrP = proState_getStackList( trP );
        proMem_displayList( descrP->nextP );
        cc_freeDescr( &descrP );
        }
    proState_abortAllProcesses();
	}

void proState_abortAllProcesses( void )
	{
	State *trP;
	trP = stateSpaceP;
	trP->request = REQ_NONE;
	while (trP->nextProcessStateP != stateSpaceP)
		{
		trP = trP->nextProcessStateP;
		trP->request = REQ_HALTED;
		}
	}

void proState_dispatch( void )
	{
    stateP = stateSpaceP;
    do
		{
		switch (stateP->request)
			{
			case REQ_NONE:
				stateP->actionFuncP();
				break;
			case REQ_NEWPROCESS:
			case REQ_NEWSTATE:
                proState_testForJam();
				if (freeStatesP == stateSpaceP)
					break;
				proState_publish();
				break;
			case REQ_HALTED:
				proState_pop();
				break;
            default:
                break;
            }
		stateP = stateP->nextProcessStateP;
        } while (programHalted == FALSE);
	}

void proState_readAndStart( void )
    {
    Descr *descrP;
	stateP->lineNo = 0;
    stateP->endOfFile = FALSE;
	descrP = proParse_parse();
	proState_request( REQ_NEWPROCESS, descrP->nextP, action_read );
	cc_freeDescr( &descrP );
    }

void proState_request( int request, List *readP, actionFuncType )
	{
	stateP->request = request;
	stateP->req.newReadP    = readP;
	stateP->req.actionFuncP = actionFuncP;
	}


void proState_publish( void )
	{
	int process = 0, curProcess;
	State *prevStateP = stateSpaceP, *traverserP = stateSpaceP;
	State *newStateP, *stepP;
	actionFuncType = stateP->req.actionFuncP;
	List *newWriteP,
		 *newReadP  = stateP->req.newReadP;
	int request = stateP->request;
	
	if (freeStatesP == stateSpaceP || 
		request == REQ_NONE        || 
		request == REQ_HALTED)
		return;
	statesFree -= 1L;
	cc_newDescr( &newWriteP, NULL );
	newStateP   = freeStatesP;
	freeStatesP = newStateP->prevStateP;
	proState_clearRequest();
    memcpy( newStateP, stateP, sizeof(State) );
	newStateP->operatorP = NULL;
	newStateP->execP = newStateP->readP = newReadP;
	newStateP->returnP = newStateP->writeP = newWriteP;
	newStateP->prevStateP = (request == REQ_NEWPROCESS) ? 
				stateSpaceP : stateP;

	newStateP->localP = proMem_getAvail();
	if (stateP->localP == NULL)
		cc_makeSubList( newStateP->localP, NULL );
	else
		*(newStateP->localP) = *(stateP->localP);

	if (request == REQ_NEWPROCESS)
		{
		newStateP->inP  = inDescrP-> nextP;
		newStateP->outP = outDescrP->nextP;
		newStateP->titleP = NULL;
		}
	newStateP->actionFuncP = actionFuncP;
	newStateP->parentProcess = (request == REQ_NEWPROCESS) ?
				stateP->process : stateP->parentProcess;
	if (request == REQ_NEWPROCESS)
		{
		do
			{
			prevStateP = traverserP;
			process = traverserP->process;
			traverserP = traverserP->nextProcessStateP;
			} while ( !(traverserP == stateSpaceP || 
				    traverserP->process > process+1));
		process += 1;
		newStateP->process = process;
		newStateP->nextProcessStateP  = traverserP;
		newStateP->prevProcessStateP  = prevStateP;
		prevStateP->nextProcessStateP = newStateP;
		traverserP->prevProcessStateP = newStateP;
		}
	else
		{
		stepP = newStateP->nextProcessStateP;
		stepP->prevProcessStateP = newStateP;
		stepP = newStateP->prevProcessStateP;
		stepP->nextProcessStateP = newStateP;
		process = newStateP->process;
		}
	curProcess = stateP->process;
	stateP->process = process;
	if (curProcess == 0 && request == REQ_NEWPROCESS)
		proFor_print("\nStarted...");
	stateP->process = curProcess;
	return;
	}

void proState_pop( void )
	{
	State *newStateP         = stateP->prevStateP;
	State *nextProcessStateP = stateP->nextProcessStateP;
	State *prevProcessStateP = stateP->prevProcessStateP;
	int  request             = stateP->request;

	statesFree += 1L;
	if (request != REQ_HALTED)
		request = REQ_NONE;
	if (newStateP != stateSpaceP)
		newStateP->request = request;
	if (newStateP == stateSpaceP)
		{
		if (stateP->parentProcess == 0 && 
			request == REQ_NONE)
			{
			proFor_print("\nReturned..." );
			proMem_displayList( stateP->returnP->nextP );
			}
		if (stateP->parentProcess == 0 || request == REQ_HALTED)
			{
			nextProcessStateP->prevProcessStateP = prevProcessStateP;
			prevProcessStateP->nextProcessStateP = nextProcessStateP;
			proState_clear( stateP, FALSE );
			stateP = prevProcessStateP;
			}
		return;	
		}
	newStateP->nextProcessStateP = nextProcessStateP;
	newStateP->prevProcessStateP = prevProcessStateP;
	nextProcessStateP->prevProcessStateP = newStateP;
	prevProcessStateP->nextProcessStateP = newStateP;
	if (stateP->inP != newStateP->inP)
		proInput_closeFile( stateP );
	if (stateP->outP != newStateP->outP)
		proFor_closeFile( stateP );
	proState_clear( stateP, FALSE );
	stateP = newStateP;
	}

Descr *proState_unfork( int process )
	{
	State *trP = stateSpaceP;
	Descr *descrP = NULL;
	
	if (process < 1)
		return NULL;
	while (trP->process != process && 
		   trP->nextProcessStateP != stateSpaceP)
		trP = trP->nextProcessStateP;
	if (trP->process != process)
		return NULL;
	if (proState_processBusy( trP ))
		return NULL;
	cc_newDescr( &descrP,trP->returnP->nextP );
	trP->parentProcess = 0;
	trP->request = REQ_HALTED;
	return descrP;
	}

Inherit proState_processBusy( State *stP )
	{
	if (stP->prevStateP != stateSpaceP || stP->readP != NULL || 
		stP->request   != REQ_NONE)
		return TRUE;
	else
		return FALSE;
	}

void proState_clearRequest( void )
	{
	stateP->request = REQ_NONE;
	stateP->req.newReadP = NULL;
	stateP->req.actionFuncP = nofunc;
	}


/*
	Return value logic. 
*/
void proState_copySingleToReturn( State *stP, List *lP )
	{
	if (lP == NULL || stP->writeP == NULL)
		return;
    stP->writeP->nextP = proMem_getAvailAndCopy( lP );
	stP->writeP = stP->writeP->nextP;
	stP->writeP->nextP = NULL;
	}

void proState_appendToReturn( State *stP, List *lP )
	{
	if (lP == NULL || stP->writeP == NULL)
		return;
	stP->writeP->nextP = lP;
	while (stP->writeP->nextP != NULL)
		stP->writeP = stP->writeP->nextP;
	}

void proState_replaceReturn( State *stP, List *lP )
	{
	if (lP == NULL || stP->writeP == NULL || stP->returnP == NULL)
		return;
	stP->returnP->nextP = lP;
	stP->writeP = stP->returnP;
	while (stP->writeP->nextP != NULL)
		stP->writeP = stP->writeP->nextP;
	}

void proState_clearReturn( State *stP )
	{
	cc_clearDescr( stP->returnP );
	stP->writeP = stP->returnP;
	}

void proState_stringToReturn( State *stP, char *s )
	{
	List new;
	
	cc_clearLElm( &new );
	cc_makeAtom( &new, s );
	proState_clearReturn( stP );
	proState_copySingleToReturn( stP, &new );
	}

void proState_unaccept( State *stP )
	{
	List new;
	
	stP->actionFuncP = action_read;
	stP->readP = NULL;
	cc_clearLElm( &new );
	cc_makeSubList( &new, stP->execP );
	proState_clearReturn( stP );
	proState_copySingleToReturn( stP, &new );
	}

void proState_appendLocals( State *stP, List *aListP )
	{
	List  *traverserP, *subTrP;

	if (aListP == NULL)
		return;
    if (aListP->u.p.type != SUBLIST || aListP->data.dataP == NULL)
		return;
	
	traverserP = aListP->data.dataP;
	do  {
        if (traverserP->u.p.type == SUBLIST)
			{
			subTrP = traverserP->data.dataP;
			while (subTrP != NULL)
				{
                subTrP->u.p.quoted = TRUE;
				subTrP = subTrP->nextP;
				}
			}
		subTrP = traverserP;
		traverserP = traverserP->nextP;
		} while (traverserP != NULL);
	traverserP = subTrP;

	if (stP->localP == NULL)
		{
		stP->localP = aListP;
		return;
		}
	if (stP->localP->data.dataP == NULL)
		{
		stP->localP = aListP;
		return;
		}

	traverserP->nextP = stP->localP->data.dataP;
	stP->localP->data.dataP = aListP->data.dataP;
	}


void proState_assignTitle( List *lP )
	{
	stateP->titleP = lP;
	}

Descr *proState_getJobList( void )
	{
	Descr *descrP, *jobDescrP;
	List  new;
	State *stP = stateSpaceP;
		
	cc_newDescr( &descrP, NULL );
	cc_newDescr( &jobDescrP, NULL );

	while (stP->nextProcessStateP != stateSpaceP)
		{
		stP = stP->nextProcessStateP;
		if (stP->request != REQ_HALTED)
			{
			cc_clearDescr( jobDescrP );
			cc_insert( jobDescrP, stP->titleP );

			new = *(stP->localP);
			cc_copyAndInsert( descrP, &new, TRUE );						

			cc_clearLElm( &new );
			cc_makeInteger( &new, stP->process );
			cc_copyAndInsert( jobDescrP, &new, FALSE );
	
			cc_makeSubList( &new, jobDescrP->nextP );
			cc_copyAndInsert( descrP, &new, FALSE );						
			}
		}
	cc_freeDescr( &jobDescrP );
	cc_clearLElm( &new );
	cc_makeSubList( &new, descrP->nextP );
	cc_newDescr( &jobDescrP, NULL );	
	cc_copyAndInsert( jobDescrP, &new, FALSE );
	cc_freeDescr( &descrP );
	return jobDescrP;
	}

void proState_substitute( List *subP )
	{
	Descr *descrP = cc_copy( stateP->execP, TRUE );
	
	substitute( descrP, subP );
	stateP->execP = stateP->readP = descrP->nextP;
	cc_freeDescr( &descrP );
	proState_clearReturn( stateP );
	}

void substitute( List *lP, List *subP )
	{
	Descr *mustBeP;

	while (lP->nextP != NULL)
		{
        if (((List *)lP->nextP)->u.p.type == SUBLIST)
			{
			Descr *sListDescrP;
			cc_newDescr( &sListDescrP, ((List *)lP->nextP)->
				data.dataP );
			substitute( sListDescrP, subP );
			((List *)lP->nextP)->data.dataP = 
				sListDescrP->nextP;
			cc_freeDescr( &sListDescrP );
			lP = lP->nextP;
			}
		else
			{
			mustBeP = cc_assoc( lP->nextP, subP );
			if ( mustBeP->nextP != NULL)
				{
				List *keepP = ((List *)lP->nextP)->nextP;
				Descr *copyDescrP =
					cc_copy( ((List *)
						((List *)mustBeP->nextP)->
							data.dataP)->nextP, 
					TRUE );

				lP->nextP = copyDescrP->nextP;
				cc_freeDescr( &copyDescrP );
				while (lP->nextP != NULL)
					lP = lP->nextP;
				lP->nextP = keepP;
				}
			else
				lP = lP->nextP;
			cc_freeDescr( &mustBeP );
			}
		}
	}

Descr *proState_getStackList(State *stP )
    {
    Descr *descrP;
    Descr *retDescrP;
    List  new;

    cc_newDescr( &descrP, NULL );
    do
        {
        if (stP->operatorP != NULL)
            {
            new = *stP->operatorP;
            new.nextP = NULL;
            cc_copyAndInsert( descrP, &new, FALSE );
            }
        stP = stP->prevStateP;
        } while (stP != stateSpaceP);
    cc_clearLElm( &new );
    cc_makeSubList( &new, descrP->nextP );
    cc_newDescr( &retDescrP, NULL );
    cc_copyAndInsert( retDescrP, &new, FALSE );
    cc_freeDescr( &descrP );
    return retDescrP;
    }


