/*
    The Lexical analyser.
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include "dfa.fdf"
#include "input.fdf"
#include "concon.h"
#include "global.h"
#include "symbol.h"
    
Inherit proLex_real( void )
    {
    stateP->token = REAL;
    proInput_copy( lexTailP, LEX_MEM_LEFT );
    return TRUE;
    }  
      
Inherit proLex_integer( void )
    {
    stateP->token = INTEGER;
    proInput_copy( lexTailP, LEX_MEM_LEFT );
    return TRUE;
    }    

Inherit proLex_space( void )
    {
	char c;

	proInput_release();
    while (	(c=proInput_getChar()) == ' ' || c == '\t')
   		proInput_forget();
    return FALSE;
    }    

Inherit proLex_bra( void )
    {
    stateP->token = BRA;
    proInput_copy( lexTailP, LEX_MEM_LEFT );
    return TRUE;
    }  
      
Inherit proLex_ket( void )
    {
    stateP->token = KET;
    proInput_copy( lexTailP, LEX_MEM_LEFT );
    return TRUE;
    }    

Inherit proLex_alpha( void )
    {
    stateP->token = ALPHA;
    proInput_copy( lexTailP, LEX_MEM_LEFT );
    return TRUE;
    }

Inherit proLex_remark( void )
    {
    stateP->token = REMARK;
    proInput_copy( lexTailP, LEX_MEM_LEFT );
    return TRUE;
    }

Inherit proLex_unremark( void )
    {
    stateP->token = UNREMARK;
    proInput_copy( lexTailP, LEX_MEM_LEFT );
    return TRUE;
    }

Inherit proLex_newline( void )
    {
	stateP->lineNo++;
	return FALSE;
    }

Inherit proLex_literal( void )
    {
    char delimiter;
    int  size = 1;
  
    stateP->token = LITERAL;

    proInput_copy( lexTailP, LEX_MEM_LEFT );
    delimiter = lexTailP[0];

    proInput_release();
    while (size < LEX_MEM_LEFT && !(stateP->endOfFile) &&
    	(lexTailP[size++]=proInput_getChar()) != delimiter)
    		{
    		proInput_forget();
    		if (lexTailP[size-1] == '\n') stateP->lineNo++;
    		}
    if (stateP->endOfFile )
    	return FALSE;
    if ((size+1) < LEX_MEM_LEFT)
    	lexTailP[size]   = '\0';
    else
    	{
    	char c;
    	lexTailP[0] = '\0';
    	while ((c=proInput_getChar()) != delimiter && 
    			!(stateP->endOfFile))
    		{
    		proInput_forget();
    		if (c == '\n') stateP->lineNo++;
    		}
    	}
    proInput_getChar();
    proInput_forget();
    if (stateP->endOfFile)
    	return FALSE;
    else	
    	return TRUE;
    }
    
Inherit proLex_quote( void )
    {
    stateP->quoted = TRUE;
    return FALSE;
    }
    

