(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jan  8 08:41:17 PST 1992 by kalsow     *)
(*      modified on Tue Dec 11 00:02:37 1990 by muller         *)


INTERFACE FPrint;

IMPORT Text;

TYPE
  T = ARRAY [0 .. 1] OF INTEGER;

PROCEDURE FromText (t: Text.T): T;
(* returns the fingerprint of 't' *)

PROCEDURE Extend (t: T;  addr: ADDRESS;  cnt: INTEGER): T;
(* returns the fingerprint of 't' concatenated with the 'cnt'
   bytes beginning at address 'addr'. *)

END FPrint.
