
Wheel2::usage = "Wheel2[l, r, n] gives a Circle3D of radius r, centre at the 
midpoint of the line l, plane normal to l, and n points on the circle. Wheel[l, r, n] gives a list of 
Circle3D's if l or r are lists."

( Wheel2[Line @ {p_, q_}, r_?NumberQ, n_Integer] := 
	Translate[(p + q) / 2] @ Circle3D[o, r $i, r $j, n] 
	/; Cross[$k, q - p] == $o 
)

( Wheel2[Line @ {p_, q_}, r_?NumberQ, n_Integer] := Translate[(p + q) / 2] @
	Rotate[
		Angle[$k, q - p], 
		Line @ {$o, Cross[$k, q - p]}
	] @	Circle3D[$o, r $i, r $j, n]
)

Wheel2[l_List, r_?NumberQ, n_Integer] := Wheel[#, r, n]& /@ l

Wheel2[l_, r_List, n_Integer] := Flatten[Wheel[l, #, n]& /@ r]

