
PolarLattice::usage = "PolarLattice[l, n] gives a list of n Length[l] points 
arranged on n radial lines starting at the origin. The angle between 
consecutive lines is 2 pi / n, and each line contains the points whose 
distances from the origin are given by the elements of l."

( PolarLattice[l_List, n_Integer?Positive] := Block[
	{r, t},
	Re[#] $i + Im[#] $j & /@ Flatten[Table[l[[r]] Exp[2 N[Pi] I t / n],
		{r, 1, Length @ l}, {t, 0, n}]] ] )

PolarLattice[u_?NumberQ, n_Integer?Positive] := PolarLattice[{u}, n] 

