/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _line.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#include <LEDA/line.h>
#include <math.h>

static const double eps = 1e-10;

//------------------------------------------------------------------------------
// lines 
//------------------------------------------------------------------------------



line::line()                    { PTR = new line_rep; }
line::line(segment s)           { PTR = new line_rep(s); }
line::line(point x, point y)    { PTR = new line_rep(segment(x,y)); }
line::line(point p, double alpha) { PTR = new line_rep(segment(p,alpha,1)); }
  

/*
double line::y_proj(double x)         
{ return slope() * x + y_abs(); }

double line::x_proj(double y)         
{ return (vertical()) ? ptr()->seg.xcoord1() : (y-y_abs())/slope(); }
*/

bool line::contains(point p)   
{ if (vertical())
      return p.xcoord() == ptr()->seg.xcoord1(); 
  else
      return p.ycoord() == y_proj(p.xcoord());
 }

bool line::contains(segment s) 
{ point p = s.start(); 
  point q = s.end();
  if (contains(p))
    if (contains(q)) return true; 
  return false;
 }


ostream& operator<<(ostream& out, const line& l) 
{ return out << l.seg(); }

istream& operator>>(istream& in, line& l)  
{ segment s; 
  in >> s; 
  l = line(s); 
  return in; 
 }


bool line::intersection(line L, point& inter)
{
  point p = L.ptr()->seg.ptr()->start;
  segment s = perpendicular(p);

  double l = s.length();

  if (l==0)
  { inter = p;
    return true;
   }

  double fi = L.angle(s);
  double cosfi = cos(fi);

  if (cosfi==0) return false;

  inter = p.translate(L.angle(),l/cosfi);
  return true;

 }

bool line::intersection(segment s, point& inter)
{ if (intersection(line(s),inter))
  { double d1  = inter.distance(s.ptr()->start);
    double d2  = inter.distance(s.ptr()->end);
    double l   = s.length();
    if ( d1<=l && d2 <=l) return true;
   }
   return false;
}


segment line::perpendicular(point q)
{ segment s = ptr()->seg;
  point r = q.translate(s.angle()+M_PI_2,-distance(q));
  return segment(q,r);
 }


