/*******************************************************************************
+
+  LEDA  3.0
+
+
+  point.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_POINT_H
#define LEDA_POINT_H

#include <LEDA/list.h>
#include <LEDA/vector.h>

class point;
class segment;

//------------------------------------------------------------------------------
// points
//------------------------------------------------------------------------------

class point_rep  : public handle_rep {

friend class point;
friend class segment;
friend class line;
friend class circle;
   
   double x;
   double y;
    
   point_rep();     
   point_rep(double a, double b);

  ~point_rep() {}
   
   
   LEDA_MEMORY(point_rep)
   
};


class point  : public handle_base 
{

friend class segment;
friend class line;
friend class circle;


point_rep* ptr() const { return (point_rep*)PTR; }

public:

 point();
 point(double, double);
 point(vector);
 point(const point& p) : handle_base(p) {}
~point()                  { clear(); }

point& operator=(const point& p) { handle_base::operator=(p); return *this; }


operator vector()         { return vector(ptr()->x,ptr()->y); }

double  xcoord()  const   { return ptr()->x; }
double  ycoord()  const   { return ptr()->y; }

double  angle(point,point);

double  distance(point);
double  distance();

point   translate(double,double);
point   translate(const vector&);

point   rotate(point,double);
point   rotate(double);


point operator+(vector& v) { return translate(v); }

int operator==(const point&);

int operator!=(const point& p) { return !operator==(p);}

friend ostream& operator<<(ostream& out, const point& p) ;
friend istream& operator>>(istream& in, point& p) ;

friend void Print(const point&, ostream& = cout);
friend void Read(point&,  istream& = cin);
friend int  compare(const point&, const point&);

};

inline void Print(const point& p, ostream& out) { out << p; } 
inline void Read(point& p,  istream& in)        { in >> p; }

LEDA_HANDLE_TYPE(point)



//------------------------------------------------------------------------------
// POINT(cmp): points with user defined linear order cmp
//------------------------------------------------------------------------------

typedef int (*CMP_POINT_TYPE)(point,point);


template <CMP_POINT_TYPE cmp>

struct _CLASSTYPE POINT : public point 
{  POINT(point  p ) : point(p)   {}
   POINT(POINT& p)  : point(p)   {}
   POINT() {}
 ~ POINT() {}
friend int compare(const POINT<cmp>& x, const POINT<cmp>& y) {return cmp(x,y);}
};


#endif

