/*******************************************************************************
+
+  LEDA  3.0
+
+
+  line.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_LINE_H
#define LEDA_LINE_H

#include <LEDA/point.h>
#include <LEDA/segment.h>

//------------------------------------------------------------------------------
// straight lines
//------------------------------------------------------------------------------

class line_rep : public handle_rep {

friend line;

  segment  seg; 
   
  line_rep() {}
  line_rep(segment s)  { seg = s; }

 ~line_rep() {}

  LEDA_MEMORY(line_rep)
   
};
   

class line   : public handle_base 
{

line_rep* ptr() const { return (line_rep*)PTR; }

public:

 line();
 line(segment);
 line(point, point);
 line(point, double);
 line(const line& l) : handle_base(l) {};

~line() { clear(); }

line& operator=(const line& l) { handle_base::operator=(l); return *this; }


bool intersection(line l, point& inter);
bool intersection(segment s, point& inter);

bool vertical()        { return ptr()->seg.vertical();  }
bool horizontal()      { return ptr()->seg.horizontal();}

double distance()        { return ptr()->seg.distance();  }
double distance(point p) { return ptr()->seg.distance(p); }
double angle(line l)     { return ptr()->seg.angle(l.ptr()->seg); }
double angle()           { return ptr()->seg.angle();     }
double direction()       { return angle(); }
double slope()           { return ptr()->seg.slope();     }

segment seg()  const     { return ptr()->seg; }

segment perpendicular(point q);

line    translate(double alpha, double d) { return ptr()->seg.translate(alpha,d); }
line    translate(const vector& v)        { return ptr()->seg.translate(v); }

line    rotate(point o, double alpha){ return ptr()->seg.rotate(o,alpha); }
line    rotate(double alpha)         { return rotate(point(0,0),alpha);}

double y_proj(double x)  { return ptr()->seg.y_proj(x); };
double x_proj(double y)  { return ptr()->seg.x_proj(y); };
double y_abs()           { return ptr()->seg.y_proj(0); }

bool contains(point);
bool contains(segment);

line operator+(const vector& v) { return translate(v); }

int operator==(const line& l) { return contains(l.ptr()->seg); }
int operator!=(const line& l) { return !contains(l.ptr()->seg); };

friend ostream& operator<<(ostream& out, const line& l);
friend istream& operator>>(istream& in, line& l);  


friend void Print(const line&, ostream& = cout);
friend void Read(line&, istream& = cin);

};

inline void Print(const line& l, ostream& out) { out << l; } 
inline void Read(line& l, istream& in)         { in >> l; }

LEDA_HANDLE_TYPE(line)



//------------------------------------------------------------------------------
// LINE(cmp): lines with user defined linear order cmp
//------------------------------------------------------------------------------

typedef int (*CMP_LINE_TYPE)(line,line);


template <CMP_LINE_TYPE cmp>

struct _CLASSTYPE LINE : public line 
{  LINE(line  p )   : line(p)   {}
   LINE(LINE& p)    : line(p)   {}
   LINE() {}
 ~ LINE() {}
friend int compare(LINE<cmp>& x, LINE<cmp>& y) { return cmp(x,y); }
};


#endif
