 /*
  * Khoros: $Id: lwarpimage.c,v 1.2 1992/03/20 22:51:02 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lwarpimage.c,v 1.2 1992/03/20 22:51:02 dkhoros Exp $";
#endif

 /*
  * $Log: lwarpimage.c,v $
 * Revision 1.2  1992/03/20  22:51:02  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lwarpimage.c
 >>>>
 >>>>      Program Name: warpimage
 >>>>
 >>>> Date Last Updated: Wed Apr 24 09:10:51 1991 
 >>>>
 >>>>          Routines: lwarpimage - the library call for warpimage
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "warpimage.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lwarpimage - library call for warpimage
*
* Purpose:
*    
*    An interactive image warping application
*    
*    
* Input:
*    
*    src -a struct xvimage pointer to the source image
*    
*    target -
*         a struct xvimage pointer to the target image
*    
*    warpimage->tp_mode -
*         Specified the mode, 1 = source and target, 2 = source only
*    
*    argc -the argc from main
*    
*    argv -the argv array from main
*    
*    program -
*         the name of the program.
*    
*    
* Output:
*    
*    None
*    
*    
*
* Written By: Tom Sauer, Danielle Argiro
*    
*    
****************************************************************/


/* -library_def */
int lwarpimage(src, dest, tp_mode, argc, argv, program)
struct xvimage *src, *dest;
int tp_mode;
int     argc;
char    *argv[];
char    *program;
/* -library_def_end */

/* -library_code */
{

        char *form_filestring;
        char temp[MaxLength];
	int screen;

        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

       /* 
	* see if the display is monochrome, if so the exit
	*/

	screen = XDefaultScreen(display);
        if ( XDisplayPlanes(display, screen) <= 1)
	{
	   xvf_error_wait("Error: warpimage can not be executed on a \
Monochrome display\nUse a color display",
	    "warpimage", NULL);
	   exit(1);
	}

        /*
         * User Interface Description file to be used
         */
        form_filestring = xvf_strcpy("$KHOROS_HOME/repos/warpimage/warpimage.form");
        form_filestring = vfullpath(form_filestring, NULL, NULL);

        /*
         * Create the forms 
         */
        if (!(form = xvf_create_form(form_filestring, av, ac, 
                                     SIMPLE, NULL, -1, -1)))
           exit(0);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_Master(form,  &Master_info);

        /*
         * Map the forms
         */
        xvf_change_active(form, true);

        workspace = Master_info.WarpImage->workspace;

        xvw_init(src, dest, tp_mode);

        XtInsertEventHandler(src_image->raster, ButtonPressMask, FALSE,
                          add_src_tiepoint, NULL, XtListHead);
        XtInsertEventHandler(src_zoom->raster, ButtonPressMask, FALSE,
                          add_src_tiepoint, NULL, XtListHead);

        if (tp_mode == SourceAndDest)
        {
            XtInsertEventHandler(dest_image->raster, ButtonPressMask, FALSE,
                             add_dest_tiepoint, NULL, XtListHead);
            XtInsertEventHandler(dest_zoom->raster, ButtonPressMask, FALSE,
                             add_dest_tiepoint, NULL, XtListHead);
        }
        else
        {
            
          sprintf(temp, "%d", 0);
          xvf_change_input(form, 
              Master_info.WarpImage->Options->dest_zoom_factor_index,
                              xvf_activation_chng, temp, 0);
          xvf_change_input(form, Master_info.WarpImage->Output->out_coeff_index,
                           xvf_activation_chng, temp, 0);
          xvf_change_input(form,Master_info.WarpImage->Input->in_dest_img_index,
                           xvf_activation_chng, temp, 0);


        }
        
        do
        {
             /*
              * run the forms
              */
             form = xvf_run_form();
             if (form == NULL) break;

             /*
              * get information from the master
              */
             _xvf_get_Master(form, &Master_info);

             /*
              * action came from the 'WarpImage' subform
              */
             if (Master_info.WarpImage_selected)
             {
                  run_WarpImage(form, Master_info.WarpImage);
             }


        xvf_clear_selections(form->db, form->line_num);

        } while (!Master_info.WarpImage->quit);    /* end user interface loop */

   if (tmpxcoeffs != NULL)
   {
      (void) unlink(tmpxcoeffs);
   }
   if (tmpycoeffs != NULL)
   {
      (void) unlink(tmpycoeffs);
   }
   return(TRUE);
}

/* -library_code_end */
