 /*
  * Khoros: $Id: lviewimage.c,v 1.1 1991/05/10 15:59:03 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lviewimage.c,v 1.1 1991/05/10 15:59:03 khoros Exp $";
#endif

 /*
  * $Log: lviewimage.c,v $
 * Revision 1.1  1991/05/10  15:59:03  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lviewimage.c
 >>>>
 >>>>      Program Name: viewimage
 >>>>
 >>>> Date Last Updated: Fri Apr 26 11:06:27 1991 
 >>>>
 >>>>          Routines: lviewimage - the library call for viewimage
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "viewimage.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lviewimage - library call for viewimage
*
* Purpose:
*
* Input:
* Output:
*
* Written By: Mark Young
****************************************************************/


/* -library_def */
int lviewimage(img_infile, elev_infile, cmap_infile,
               use_cmap, update, display_name, xpos, ypos, proportional)

char *img_infile,
     *elev_infile,
     *cmap_infile,
     *display_name;
int   use_cmap, xpos, ypos, proportional;
float update;

/* -library_def_end */

/* -library_code */
{
        char *form_filestring;
        char *form_pathname;
        Widget workspace;
        float  subsample;
        char   temp[MaxLength];
        xvf_sub_form *pseudo_subform, *lut_subform, *thres_subform,
                     *persp_subform;


        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

        /*
         *  perform global initializations for this application
         */
        xvd_initialize(display);

        /*
         *  initialize the image
         */
        if (!init_image(img_infile, NULL, NULL, elev_infile,
                        cmap_infile, use_cmap))
        {
           return(False);
        }
	xvf_set_colormap(xvdisplay->colormap);
	xvf_set_visual(xvdisplay->visual);

        /*
         * Substitute below the correct filename and directory path
         * of the User Interface Description file to be used
         */
        global_indir    = 
        global_outdir   = NULL;
        form_filestring = xvf_strcpy("viewimage.form");
        form_pathname   = xvf_strcpy("$KHOROS_HOME/repos/viewimage");
        form_filestring = vfullpath(form_filestring, form_pathname, NULL);

        /*
         * Create the forms 
         */
        if (!(form = xvf_create_form(form_filestring, av, ac, SIMPLE, NULL,
                                     xpos, ypos)))
           exit(0);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_view(form,  &view_info);


        /*
         *  Add detect code to update when the image updates.
         */
        update_time = update;
        if (update != 0.0)
           update_id = xvf_detect_file(img_infile, update, update_file, NULL);
        else
           update_id = 0;

        /*
         *  build the xvdisplay images
         */
        if (xvd_build_xvdisplay(xvdisplay) == False)
        {
           return(False);
        }

        /*
         *  create & initialize the perspective display widget
         */
        workspace = view_info.persp_subform->persp->persp_workspace;
        create_persp_display(workspace);

        /*
         * create & initialize the plot display widget
         * in which the viff image file input will appear
         */
        workspace = view_info.plot_workspace;
        create_plot_display(form, workspace, images, elevation, proportional,
                &subsample);

        sprintf(temp, "%g", subsample);
        xvf_change_input(form, view_info.plot_subform->plot->subsample_index, 
                         xvf_floatval_chng, temp);


        /*
         *  create & initialize the lut display widget
         */
        workspace = view_info.lut_subform->lut->lut_workspace;
        create_lut_display(workspace);

        /*
         *  create & initialize the pseudo display widget
         */
        workspace = view_info.pseudo_subform->pseudo->pseudo_workspace;
        create_pseudo_display(workspace);

        /*
         *  create & initialize the threshold display widget
         */
        workspace = view_info.thres_subform->thres->thres_workspace;
        create_thres_display(workspace);

        /*
         *  Set the new colormap for each of the display structures.
         *  Then call the update threshold routine "update_thres" to
         *  set the current threshold.
         */
        set_colormap();
        update_thres();

        /*
         * Map the forms
         */
        xvf_change_active(form, true);

        do
        {
             /*
              * run the forms
              */
             form = xvf_run_form();
             if (form == NULL) break;

             /*
              * get information from the master
              */
             _xvf_get_view(form, &view_info);

             /*
              * user clicked on master  action button 'change_bands'
              */
             if (view_info.change_bands)
             {
                /* PUT YOUR CODE HERE ! */
             }

             /*
              * action came from the 'lut_subform' subform
              */
             if (view_info.lut_subform_selected)
             {
                  if (view_info.lut_subform->lut_selected);
                     run_lut(form, view_info.lut_subform->lut);
             }

             /*
              * action came from the 'pseudo' subform
              */
             if (view_info.pseudo_subform_selected)
             {
                  if (view_info.pseudo_subform->pseudo_selected)
                      run_pseudo(form, view_info.pseudo_subform->pseudo);
             }

             /*
              * action came from the 'thres' subform
              */
             if (view_info.thres_subform_selected)
             {
                  if (view_info.thres_subform->thres_selected)
                      run_thres(form, view_info.thres_subform->thres);
             }

             /*
              * action came from the 'files_subform' subform
              */
             if (view_info.files_subform_selected)
             {
                  run_files_subform(form, view_info.files_subform);
             }

             /*
              * action came from the 'persp_subform' subform
              */
             if (view_info.persp_subform_selected)
             {
                  run_persp_subform(form, view_info.persp_subform);
             }

             /*
              * action came from the 'colormap_subform' subform
              */
             if (view_info.colormap_subform_selected)
             {
                  run_colormap_subform(form, view_info.colormap_subform);
             }

             /*
              * action came from the 'plot_subform' subform
              */
             if (view_info.plot_subform_selected)
             {
                  run_plot_subform(form, view_info.plot_subform);
             }
             xvf_clear_selections(form->db, form->line_num);

        } while (!view_info.quit);    /* end user interface loop */
        return(TRUE);
}

int update_file(id, filename, data)

int  id;
char *filename;
char *data;
{
        struct xvimage *image, *readimage();
        DisplayStructure *xvdisplay = (DisplayStructure *) data;


        if (!(image = readimage(filename)))
           return(False);

        update_image(image);
        return(True);
}

/* -library_code_end */
