 /*
  * Khoros: $Id: structs.h,v 1.1 1991/05/10 15:58:30 khoros Exp $
  */

 /*
  * $Log: structs.h,v $
 * Revision 1.1  1991/05/10  15:58:30  khoros
 * Initial revision
 *
  */ 


#ifndef _structs_h_
#define _structs_h_

/*
 *  structure holding information about the zoom window
 */
typedef struct
{
        int     mode;
        XImage *ximage;
        Widget  image;
        float   zoomfactor;
	int	cursor;

} ZoomStructure;

/*
 *  structure holding information about the pixels window
 */
typedef struct
{
	GC            gc;
        int           width, height, mode, model;
        XFontStruct  *font;
        Widget 	      pixels;

	Widget	      rgb_back, rgb[3], cmy_back, cmy[3],
		      hsv_back, hsv[3], hls_back, hls[3],
		      yiq_back, yiq[3], xyz_back, xyz[3],
		      uvw_back, uvw[3], grey_back, grey[1];
}  PixelStructure;

/*
 * structure holding information about scroll bars 
 */
typedef struct
{
	int	 num;
        char     *string;
        unsigned long pixel;

        Widget   value;
        Widget   scrollbar;
}  ScrollStruct;

/*
 *  structure holding information about the pseudocolor window
 */
typedef struct
{
	Widget	      pseudo, color1, color2, palette, undo;

	int   	      model;
	Widget	      rgb_back, cmy_back, hsv_back, hls_back, 
	              yiq_back, xyz_back, uvw_back, grey_back;

	ScrollStruct  rgb[3], cmy[3], hsv[3], hls[3], yiq[3],
		      xyz[3], uvw[3], grey[1];
} PseudoStructure;


/*
 *  structure holding information about the individual lut canvas
 */
typedef struct
{
	int	  num;
        unsigned  long pixel;

	Widget    canvas;
	Widget    xpos;
	Widget    ypos;
	Widget    xbeg, xend;

} LutCanvasStruct;

/*
 *  structure holding information about the lut window
 */
typedef struct
{
	int   	  model, histogram, hist_type;

	Widget	  rgb_back, cmy_back, hsv_back, hls_back, 
	          yiq_back, xyz_back, uvw_back, grey_back;

	LutCanvasStruct *current_lut, *active_canvas;
	LutCanvasStruct rgb[3], cmy[3], hsv[3], hls[3], yiq[3],
		        xyz[3], uvw[3], grey[1];
        Widget toplevel;
        Widget back;
        Widget palette;
	Widget undo;

} LutStructure;


typedef struct
{
	unsigned long fill_pixel, nonzero_pixel;
	int	      mode, accept, invert;

	Widget        toplevel;
	Widget        palette;
	Widget        reset;
	ScrollStruct  *lower;
	ScrollStruct  *upper;
	ScrollStruct  *range;

} ThresStructure;

/*
 * structure holding information the X color elements.  Before
 * any of the display utilites change the color aray they push
 * the color structures onto the "color" stack, so that the user
 * has the option to pop or "undo" the coloring operations.
 */
typedef struct _color_stack
{
        int     index1, index2;

        XColor  *xcolors;
        struct  _color_stack *prev;
} ColorStack;

/*
 * structure holding information the ROI area.  Before any region
 * of interest operation is performed the previous image is stored
 * onto the "roi" stack, so that the user has the option to pop or
 * "undo" the roi operations.
 */
typedef struct _roi_stack
{
        struct  xvimage *region, *mask;
        struct  _roi_stack *prev;
} RoiStack;

#endif
