 /*
  * Khoros: $Id: files.c,v 1.2 1991/12/18 09:01:13 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: files.c,v 1.2 1991/12/18 09:01:13 dkhoros Exp $";
#endif

 /*
  * $Log: files.c,v $
 * Revision 1.2  1991/12/18  09:01:13  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name:  files.c					<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>>      routines:  xvl_save_file()				<<<<
   >>>>      		xvl_save_temp_files()			<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvl_save_file
*
*      Purpose:  This routine interactievly allows the user
*		 to save a single file.  This is done via a
*		 prompt widget which user is requested to
*		 type in the new filename for the desired
*		 connection.
*
*        Input:  filename - the name of file in which we will
*			    be reading the data from.
*
*
*   Written By: Mark Young
*
*************************************************************/


int xvl_save_file(filename)

char	*filename;
{
	char temp1[MaxLength], temp2[MaxLength], *prompt,
	     *newfile, savefile[MaxLength];


	/*
	 *  Return if there are no file to be saved.
	 */
	if (filename == NULL)
	   return(False);

	prompt  = temp1;
	newfile = temp2;

	temp2[0] = '\0';
	(void) sprintf(temp1, "Save %s as:", filename);
	if (xvf_query_wait("Choose a new name for the file to be saved.",
		&prompt, "SAVE", &newfile, 1, 40) != NULL)
	{
	   /* Copy the file to be saved */
	   if (newfile[0] != '\0')
	   {
	      if (vfullpath(newfile, NULL, savefile))
	         xvl_copy(filename, savefile);
	   }
	}
	return(True);
}
/************************************************************
*
* Routine Name:  xvl_save_temp_files
*
*      Purpose:  This routine interactievly allows the user
*		 to save the temporary files.  This is done
*		 by displaying a list of the temporary files
*		 to be saved, which the user selects the desired
*		 temporary files.  Then a list of prompt widgets
*		 are displayed and the user is requested to
*		 type in the new filename for each selected
*		 temporary file.  The files are then 
*
*        Input:  None
*
*
*   Written By: Stephanie Hallet, Carla Williams, Mark Young
*
*************************************************************/


int xvl_save_temp_files(workspace)

Workspace	*workspace;
{
	XawListReturnStruct **file_save;
	char *prompt1 = "Click on the files you wish to save";
	char *label1  = "Saving Temporary Files";

	char buff[512];
	int  i, num_files;
	int  chosen_num;
	char *file_array[512], *temp_files[512], *savefile;
	char *ans[512];

	Node      *node;
	NodeList  *output_list;
	Glyph     *glyph;
	GlyphList *glyphlist;


	/*
	 * Find temporary files to be saved.
	 */
	num_files = 0;
	glyphlist = workspace->glyphs;
	while (glyphlist != NULL)
	{
	   glyph = glyphlist->glyph;
	   output_list = glyph->output_list;
	   while (output_list != NULL)
	   {
	      node = output_list->node;
	      if (node->temp_file == True)
	         temp_files[num_files++] = node->filename;

	      output_list = output_list->next;
	   }
	   glyphlist = glyphlist->next;
	}

	/*
	 *  Return if there are no temporary files to be saved.
	 */
	if (num_files == 0)
	{
	   xvf_error_wait("Sorry!  No temporary files found for this workspace.\
This routine should  be used for interactively renaming the temporary files \
that 'cantata' creates with a visual program.\n", "xvl_save_temp_files", NULL);
	   return(1);
	}

	file_save = xvf_run_list_multsel_wait(temp_files, num_files, 1, prompt1,
				label1, false, false, &chosen_num);
	if (file_save != NULL)
	{	
	   /* copy chosen files into file_array */
	   for (i = 0; i < chosen_num; i++)
	   {
	      sprintf(buff,"save %s as:",file_save[i]->string);
	      file_array[i] = xvf_strcpy(buff);
              ans[i] = (char *)calloc(1, 512*sizeof(char));
           }

	   /* query for new filenames */
	   if (xvf_query_wait("Choose a new name for each file to be saved.",
				file_array, "SAVE",ans,chosen_num,40) == NULL)
	   {
	      /* CANCEL */
	      for (i = 0; i < chosen_num; i++)
	      {
		 if (ans[i] != NULL)	 free(ans[i]);
		 if (file_array[i] != NULL) free(file_array[i]);
		 if (file_save[i] != NULL)  free(file_save[i]);
	      }
	      return(-1);
	   } 

	   /* save files */
	   for (i = 0; i < chosen_num; i++)
	   {
	      /* Copy all the chosen files */
	      if ((ans[i] != NULL) && (strcmp(ans[i],"") != 0) &&
		  (strcmp(ans[i],file_save[i]->string)!=0))
	      {
		 savefile = vfullpath(ans[i], NULL, NULL);
		 xvl_copy(file_save[i]->string, savefile);
		 free(savefile);
	      }
	      else
	      {
		 sprintf(buff,"Unable to save %s, because a new filename was  \
	not given.", file_save[i]->string);
		 xvf_error_wait(buff,"xvl_save_temp_files", NULL);
	      }
	   }
	}

	/* free the ans array */
	for (i = 0; i < chosen_num; i++)
	{
	   if (ans[i] != NULL)	 free(ans[i]);
	   if (file_array[i] != NULL) free(file_array[i]);
	   if (file_save[i] != NULL)  free(file_save[i]);
	}

	/*  No files were chosen  */
	if (chosen_num == -1)
	   return(-1);
	else if (chosen_num == 0)
	   return(0);

	return(1);
}
