 /*
  * Khoros: $Id: vhsee.h,v 1.1 1991/05/10 15:49:31 khoros Exp $
  */

 /*
  * $Log: vhsee.h,v $
 * Revision 1.1  1991/05/10  15:49:31  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhsee.h
 >>>>            Author: Mark Young, Marcelo Teran, Ramiro Jordan
 >>>> Date Last Updated: Tue Mar  5 22:33:12 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vhsee_h_
#define _vhsee_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vhsee Argument Structure
*
****************************************************************/

typedef struct _vhsee  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (Required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

/*
 *  Chose between photonegative [False] and photopositive [True] (Optional logical)
 */
int	 p_logic;	/* Chose between photonegative [False] and photopositive [True] LOGIC */
int	 p_flag;  	/* Chose between photonegative [False] and photopositive [True] FLAG */

/*
 *  Choose displayable format [False] or plotable format [True] (Optional logical)
 */
int	 t_logic;	/* Choose displayable format [False] or plotable format [True] LOGIC */
int	 t_flag;  	/* Choose displayable format [False] or plotable format [True] FLAG */

}  vhsee_struct;

vhsee_struct *vhsee;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/*
The following define checks for proper values of:
num_of_images = 1
num_data_bands = 1
data_storage_type = VFF_TYP_1_BYTE
map_enable = VFF_MAP_OPTIONAL
*/

#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        \
        (void) proper_num_bands(program,img1,1,TRUE); \
        \
        (void) propertype(program,img1,VFF_TYP_1_BYTE,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
