 /*
  * Khoros: $Id: vwiener.h,v 1.2 1992/03/20 23:10:02 dkhoros Exp $
  */

 /*
  * $Log: vwiener.h,v $
 * Revision 1.2  1992/03/20  23:10:02  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vwiener.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Mar  9 18:44:41 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vwiener_h_
#define _vwiener_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vwiener Argument Structure
*
****************************************************************/

typedef struct _vwiener  {

/*
 *  FFT of image to be restored (Required infile)
 */
char	*i1_file;	/* FFT of image to be restored FILENAME */
int	 i1_flag;	/* FFT of image to be restored FLAG */

/*
 *  FFT of PSF function (Required infile)
 */
char	*i2_file;	/* FFT of PSF function FILENAME */
int	 i2_flag;	/* FFT of PSF function FLAG */

/*
 *  FFT of restored image (Required outfile)
 */
char	*o1_file;	/* FFT of restored image FILENAME */
int	 o1_flag;	/* FFT of restored image FLAG */

/*
 *  minimum PSF threshold (Required float)
 */
float	 t_float;	/* minimum PSF threshold FLOAT */
int	 t_flag;   	/* minimum PSF threshold FLAG */

/*
 *  Weiner parameter (Required float)
 */
float	 w_float;	/* Weiner parameter FLOAT */
int	 w_flag;   	/* Weiner parameter FLAG */

/*
 *  FFT of reference image (Optional infile)
 */
char	*i3_file;	/* FFT of reference image FILENAME */
int	 i3_flag;	/* FFT of reference image FLAG */

/*
 *  FFT of restoration filter (Optional outfile)
 */
char	*o2_file;	/* FFT of restoration filter FILENAME */
int	 o2_flag;	/* FFT of restoration filter FLAG */

}  vwiener_struct;

vwiener_struct *vwiener;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/*
The following define checks for proper values of:
num_of_images = 1
num_data_bands = 1
data_storage_type = VFF_TYP_COMPLEX
map_enable = VFF_MAP_OPTIONAL

and verifies that img1 and img2 match for
the above fields and also
data_storage_type
col_size
row_size.
*/

#define CHECKINPUT(program, img1, img2) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) proper_num_bands(program,img1,1,TRUE); \
        (void) match_num_bands(program,img1,img2,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE);   \
        (void) match_map_enable(program,img1,img2,TRUE); \
        \
        (void) matchsize(program,img1,img2,TRUE); \
        (void) propertype(program,img1,VFF_TYP_COMPLEX,TRUE); \
        (void) matchtype(program,img1,img2,TRUE)

#define MATCHINPUT(program, img1, img2) \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) match_num_bands(program,img1,img2,TRUE); \
        \
        (void) match_map_enable(program,img1,img2,TRUE); \
        \
        (void) matchsize(program,img1,img2,TRUE); \
        (void) matchtype(program,img1,img2,TRUE)
/* -include_macros_end */

#endif
