 /*
  * Khoros: $Id: vstereo.c,v 1.2 1991/12/18 09:30:47 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vstereo.c,v 1.2 1991/12/18 09:30:47 dkhoros Exp $";
#endif

 /*
  * $Log: vstereo.c,v $
 * Revision 1.2  1991/12/18  09:30:47  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vstereo.c
 >>>>
 >>>>      Program Name: vstereo
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Computes the depth in a matched pair of stereo image
 >>>>	
 >>>>	

 >>>>            Author: Pascal Adam
 >>>>
 >>>> Date Last Updated: Sat Dec 14 18:14:43 1991
 >>>>
 >>>>          Routines: main- the main program for vstereo
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vstereo.h"


/****************************************************************
 *
 * Routine Name:  main program for vstereo
 *
 *       Input:  
 *         -i  Input Matched Image 
 *         -o  Output Depth Image 
 *
 *
 *         [-f] Focal Length of the Camera  (0.000 < value < 100.000)
 *         [-l] Image Length (CCD Sensor)  (0.000 < value < 30.000)
 *         [-h] Image Height (CCD Sensor)  (0.000 < value < 30.000)
 *         [-d] Camera Displacement on X Axis  (0.000 < value < 100000.000)
 *         [-z] Maximum Distance from camera  (0.000 < value < 10000.000)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
   struct xvimage *image,
                  *output,
                  *createimage(),
                  *readimage();
   char *dummy = '\0';
   int nc, nr;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
   if (check_args()) exit(1);

   READINPUT(image) ;
   CHECKINPUT(program,image) ;
   if (lvconvert(image,VFF_TYP_4_BYTE,0,1,0.0,1.0) == 0) 
   {
      (void) fprintf(stderr,"vstereo: lvconvert failure\n\n");
      exit(1);
   }

   nc = image->row_size;
   nr = image->col_size;

   output = createimage(nr,
                        nc/2,
                        VFF_TYP_4_BYTE,
                        1,
                        1,
                        dummy,
                        0,
                        0,
                        VFF_MS_NONE,
                        VFF_MAPTYP_NONE,
                        VFF_LOC_IMPLICIT,
                        0);

   if (output == NULL)
   {
      (void) fprintf(stderr,
             "vstereo: Unable to allocate memory for output image!\n\n");
      exit(1);
   }


/* -main_before_lib_call_end */

/* -main_library_call */
   lvstereo(image,
            output,
            vstereo->f_float,
            vstereo->l_float,
            vstereo->h_float,
            vstereo->d_float,
            vstereo->z_float);
/* -main_library_call_end */

/* -main_after_lib_call */
   writeimage(vstereo->o_file,output);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vstereo 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vstereo :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tComputes the depth in a matched pair of stereo image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  Input Matched Image  (infile)\n");
	fprintf(stderr,"\t-o  Output Depth Image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-f]  Focal Length of the Camera (float,  0.000 to 100.000) [30]\n");
	fprintf(stderr,"\t[-l]  Image Length (CCD Sensor) (float,  0.000 to 30.000) [10]\n");
	fprintf(stderr,"\t[-h]  Image Height (CCD Sensor) (float,  0.000 to 30.000) [10]\n");
	fprintf(stderr,"\t[-d]  Camera Displacement on X Axis (float,  0.000 to 100000.000) [100]\n");
	fprintf(stderr,"\t[-z]  Maximum Distance from camera (float,  0.000 to 10000.000) [6000]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vstereo\n");
	fprintf(stderr, "\t[-U] Gives the usage for vstereo\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vstereo.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vstereo.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vstereo
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) Input Matched Image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) Output Depth Image \n        {outfile}: "; 
char	*f_pstr = 
	"\nEnter: (f) Focal Length of the Camera \n        {float,  0.000 to 100.000 [30.000000] }: "; 
char	*l_pstr = 
	"\nEnter: (l) Image Length (CCD Sensor) \n        {float,  0.000 to 30.000 [10.000000] }: "; 
char	*h_pstr = 
	"\nEnter: (h) Image Height (CCD Sensor) \n        {float,  0.000 to 30.000 [10.000000] }: "; 
char	*d_pstr = 
	"\nEnter: (d) Camera Displacement on X Axis \n        {float,  0.000 to 100000.000 [100.000000] }: "; 
char	*z_pstr = 
	"\nEnter: (z) Maximum Distance from camera \n        {float,  0.000 to 10000.000 [6000.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vstereo", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vstereo.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vstereo: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vstereo.ans");
		}

	     }

	}

	/*
	 * allocate the vstereo structure
	 */
	vstereo = (vstereo_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vstereo_struct));

	/*
	 * get required arguments for vstereo
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vstereo->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vstereo->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vstereo->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vstereo->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vstereo->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vstereo->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vstereo->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vstereo->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vstereo->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vstereo->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vstereo
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vstereo->f_flag = vget_float(fid, prompt_flag,
	"-f", f_pstr, &(vstereo->f_float),
	30.000000, 0.000000, 100.000000);

	vstereo->l_flag = vget_float(fid, prompt_flag,
	"-l", l_pstr, &(vstereo->l_float),
	10.000000, 0.000000, 30.000000);

	vstereo->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(vstereo->h_float),
	10.000000, 0.000000, 30.000000);

	vstereo->d_flag = vget_float(fid, prompt_flag,
	"-d", d_pstr, &(vstereo->d_float),
	100.000000, 0.000000, 100000.000000);

	vstereo->z_flag = vget_float(fid, prompt_flag,
	"-z", z_pstr, &(vstereo->z_float),
	6000.000000, 0.000000, 10000.000000);


}



