 /*
  * Khoros: $Id: lrftrain.h,v 1.1 1991/05/10 15:46:03 khoros Exp $
  */

 /*
  * $Log: lrftrain.h,v $
 * Revision 1.1  1991/05/10  15:46:03  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lrftrain.h
 >>>>            Author: Tom Sauer and Charlie Gage
 >>>> Date Last Updated: Tue Apr  9 08:34:31 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _lrftrain_h_
#define _lrftrain_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    lrftrain Argument Structure
*
****************************************************************/

typedef struct _lrftrain  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  cluster center image (Required infile)
 */
char	*i2_file;	/* cluster center image FILENAME */
int	 i2_flag;	/* cluster center image FLAG */

/*
 *  cluster variance image (Required infile)
 */
char	*i3_file;	/* cluster variance image FILENAME */
int	 i3_flag;	/* cluster variance image FLAG */

/*
 *  cluster number image (Required infile)
 */
char	*i4_file;	/* cluster number image FILENAME */
int	 i4_flag;	/* cluster number image FLAG */

/*
 *  weight image (Required outfile)
 */
char	*o_file;	/* weight image FILENAME */
int	 o_flag;	/* weight image FLAG */

/*
 *  output file for training statistics (Required outfile)
 */
char	*f_file;	/* output file for training statistics FILENAME */
int	 f_flag;	/* output file for training statistics FLAG */

/*
 *  MSE display interval (Optional integer)
 */
int	 d_int; 	/* MSE display interval INT */
int	 d_flag;	/* MSE display interval FLAG */

/*
 *  convergence value (Optional float)
 */
float	 cv_float;	/* convergence value FLOAT */
int	 cv_flag;   	/* convergence value FLAG */

/*
 *  weight update value (Optional float)
 */
float	 meu_float;	/* weight update value FLOAT */
int	 meu_flag;   	/* weight update value FLAG */

/*
 *  Maximum number of iterations (Optional integer)
 */
int	 n_int; 	/* Maximum number of iterations INT */
int	 n_flag;	/* Maximum number of iterations FLAG */

/*
 *  Min delta MSE value (Optional float)
 */
float	 delta_float;	/* Min delta MSE value FLOAT */
int	 delta_flag;   	/* Min delta MSE value FLAG */

/*
 *  Border Width (Optional integer)
 */
int	 b_int; 	/* Border Width INT */
int	 b_flag;	/* Border Width FLAG */

}  lrftrain_struct;

lrftrain_struct *lrftrain;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE1(image) \
        image = readimage(lrftrain->i1_file);  \
        if (image == NULL) {  \
        (void) fprintf(stderr, "lrftrain: Can not read input image \n");  \
        exit(1);  /* Quit if bad image */ \
        }

#define READIMAGE2(cc_img) \
        cc_img = readimage(lrftrain->i2_file);  \
        if (cc_img == NULL) {  \
        (void) fprintf(stderr,"lrftrain: Can not read cluster center image\n"); \
        exit(1);  /* Quit if bad image */ \
        }

#define READIMAGE3(var_img) \
        var_img = readimage(lrftrain->i3_file);  \
        if (var_img == NULL) {  \
        (void) fprintf(stderr,"lrftrain: Can not read variance image\n"); \
        exit(1);  /* Quit if bad image */ \
        }

#define READIMAGE4(cn_img) \
        cn_img = readimage(lrftrain->i4_file);  \
        if (cn_img == NULL) {  \
        (void) fprintf(stderr,"lrftrain: Can not read cluster number image\n"); \
        exit(1);  /* Quit if bad image */ \
        }

#define CHECKTYPE(program, image) \
   if( !(propertype(program, image, VFF_TYP_FLOAT, TRUE)) ) { \
      fprintf(stderr,"%s: data storage type must be FLOAT.",program); \
      exit(1); \
    }

#define CHECKTYPEINT(program, image) \
   if( !(propertype(program, image, VFF_TYP_4_BYTE, TRUE)) ) { \
      fprintf(stderr,"%s: data storage type must be INTEGER.",program); \
      exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
