 /*
  * Khoros: $Id: lvmcdilate.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmcdilate.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvmcdilate.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmcdilate.c
 >>>>
 >>>>      Program Name: vmcdilate
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:30:25 1991 
 >>>>
 >>>>          Routines: lvmcdilate - the library call for vmcdilate
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmcdilate - library call for vmcdilate
*
* Purpose:
*    
*    Conditionalloy  dilate  a  binary  image  by  a  structuring
*    element.
*    
*    
* Input:
*    
*         img1 -- xvimage structure
*         ker  -- xvimage structure (morphological kernel)
*         f   -- int (foreground value to dilate)
*    
*    
* Output:
*    
*         img1 -- holds the result of the dilation by the kernel
*    
*    
*
* Written By: Pascal Adam
Greg Donohoe
*    
*    Ghost Conversion by Pascal Adam (Thu  May  24  14:14:55  MDT
*    1990)
*    
*    
****************************************************************/


/* -library_def */
int
lvmcdilate(image,kernel,foreground,wave)
struct xvimage *image, *kernel;
int foreground,wave;
/* -library_def_end */

/* -library_code */
{
    int belong,    /* inter[translate(kernel;i,j),image] empty ? */ 
        nc,        /* number of columns of image */ 
        nr,        /*   "    "  rows    "  "    */
        starti,    /* x upper left corner position of kernel */
        startj,    /* y   "    "    "        "     "   "     */
        kernc,     /* number of columns of kernel */
        kernr;     /* number of rows of kernel */

    unsigned char *result; /* storage of final result */

    char   *program = "lvmcdilate";

    int i,j,k,ki,kj;
    unsigned char *imgptr, *kernptr, *resptr;

    /* Check type,... of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "lvmcdilate: image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    nc = image->row_size; /* number of columns */
    nr = image->col_size; /* number of rows    */


    /* Check type,... of image */
    if (!(propertype(program, kernel, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"lvmcdilate: image must be of type byte/n");
        return (0);
    }
    if (!(proper_num_images (program, kernel, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, kernel, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    kernc = kernel->row_size;/* number of columns of the kernel */
    kernr = kernel->col_size;/* number of rows of the kernel    */

    starti = (int)kernel->ispare1; /* position of upper left hand */ 
    startj = (int)kernel->ispare2; /* corner of the kernel (x,y)  */

    kernptr = (unsigned char *)(kernel->imagedata); /* pointer on kernel values */

    /* Checks if the relative position of the kernel relative to the 
    ** dimension of the image will give a significant result image  */
    if (starti>nr/2 || startj>nc/2) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Warning : the size of the kernel\n");
        (void) fprintf (stderr, "is too big compared to the image\n");
        (void) fprintf (stderr, "size. The visible result may out\n");
        (void) fprintf (stderr, "of the result image dimension...\n");
        }
   
    /* checks the kernel value to be sure it is a compatible 
    **  morphological kernel ...................................*/
    for (i=0;i<kernc*kernr;i++) {
        if (*(kernptr+i) !=0 && *(kernptr+i)!=255) {
                (void) fprintf (stderr, "\n%s:   ", program);
                (void) fprintf (stderr, "Kernel contains values different\n");
                (void) fprintf (stderr, "from 0 or 255. Not acceptable ..\n");
                return(0);
                }
        }
    
    /* dynamic memory allocation for temporary result stockage */
    result = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (result == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }
    
    for (i=0;i<kernc*kernr;i++) {
        if (*(kernptr+i) !=0 && *(kernptr+i)!=255) {
                (void) fprintf (stderr, "\n%s:   ", program);
                (void) fprintf (stderr, "Kernel contains values different\n");
                (void) fprintf (stderr, "from 0 or 255. Not acceptable ..\n");
                return(0);
                }
        }
    /* dynamic memory allocation for temporary result stockage */
    result = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (result == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }

    /* Make a copy of the input image */
    imgptr = (unsigned char *) image->imagedata;
    resptr = result;

    k = nc * nr;                          /* Normal operation count */
    for (j=0;j<k;j++)
        *resptr++ = *imgptr++;

    imgptr = (unsigned char *) image->imagedata;
    resptr = result;

    for (i = -starti; i < nr-(kernr+starti); i++) 
        for (j = -startj; j < nc-(kernc+startj); j++) 
            if (*(imgptr+i*nc+j) == foreground) 
                for (ki=starti; ki < kernr+starti; ki++)
                   for (kj=startj; kj<kernc+startj; kj++) 
                      if (*(kernptr+(ki-starti)*kernc+kj-startj) != 0) 
                            if (*(imgptr+(i+ki)*nc + j+kj) != foreground)
                               *(resptr+(i+ki)*nc + j+kj) = wave;

    imgptr = (unsigned char *) image->imagedata;
    resptr = result;
    for (i=0;i<k;i++) *imgptr++ = *resptr++;


    free(result);

    return(1);
}
/* -library_code_end */
