 /*
  * Khoros: $Id: dzresp.h,v 1.2 1992/03/20 23:23:10 dkhoros Exp $
  */

 /*
  * $Log: dzresp.h,v $
 * Revision 1.2  1992/03/20  23:23:10  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dzresp.h
 >>>>            Author: Jeremy Worley
 >>>> Date Last Updated: Mon Mar  9 20:20:34 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dzresp_h_
#define _dzresp_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dzresp Argument Structure
*
****************************************************************/

typedef struct _dzresp  {

/*
 *  input data file (polynomial file) (Required infile)
 */
char	*i_file;	/* input data file (polynomial file) FILENAME */
int	 i_flag;	/* input data file (polynomial file) FLAG */

/*
 *  resulting output file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting output file (xviff file) FILENAME */
int	 o_flag;	/* resulting output file (xviff file) FLAG */

/*
 *  number of points (Optional integer)
 */
int	 n_int; 	/* number of points INT */
int	 n_flag;	/* number of points FLAG */

/*
 *  generate one-sided (0) or two-sided (1) response (Optional logical)
 */
int	 r_logic;	/* generate one-sided (0) or two-sided (1) response LOGIC */
int	 r_flag;  	/* generate one-sided (0) or two-sided (1) response FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*
 * type of response(0 = magnitude; 1 = power; 2 = phase) (Optional integer toggle - )
 */
int	 p_toggle;		/* type of response(0 = magnitude; 1 = power; 2 = phase) INT TOGGLE */
int	 p_flag;		/* type of response(0 = magnitude; 1 = power; 2 = phase) FLAG */

}  dzresp_struct;

dzresp_struct *dzresp;

/* -include_additions */
#include "vpoly.h"
/* -include_additions_end */

/* -include_macros */
#define MAXPOLYS 100
#define MAXTERMS 600
#define MAXSTAGES 200
#define STRMAX 100
/* -include_macros_end */

#endif
