 /*
  * Khoros: $Id: vget_type.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vget_type.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: vget_type.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: vgettype.c                             <<<<
   >>>>                                                       <<<<
   >>>>   description: commandline utility                    <<<<
   >>>>                                                       <<<<
   >>>>      routines: vgettype() 			      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* 
** vgettype() is a utility that takes as input a string that should be one of:
**       bit, byte, short, int, float, complex, or double.
**
** given this, it will return a !0 indicating that no error has occured, and
** the integer argument will be returned with the corresponding VFF data type.
**
**
** Author:  Jeremy Worley
**          Jan 1990
**
*/

int vget_type(type,stype)
  int *type;
  char *stype;
{
  int i;
 
/* 
**  We wanna have the flexibility to enter in upper or lower case type name
*/

  for(i=0;i<VStrlen(stype);i++)
      if(isupper(stype[i]))stype[i]=tolower((int)stype[i]);

/*
** Check first (and if necessary, the second) letter and identify data type
*/

  switch(stype[0]){
       case '0' : *type=VFF_TYP_BIT;
                  return(!0);
       case '1' : *type=VFF_TYP_1_BYTE;
                  return(!0);
       case 'b' : if(stype[1]=='i'){
                     *type=VFF_TYP_BIT;
                     return(!0);
                  }else if(stype[1]=='y'){
                     *type=VFF_TYP_1_BYTE;
                     return(!0);
                  }
                  return(0);
       case '2' :
       case 's' : *type=VFF_TYP_2_BYTE;
                  return(!0);
       case '3' :
       case 'l' :				/* added 'long' 6/2/90 jw */
       case 'i' : *type=VFF_TYP_4_BYTE;
                  return(!0);
       case '4' :
       case 'f' : *type=VFF_TYP_FLOAT;
                  return(!0);  
       case '6' :
       case 'c' : *type=VFF_TYP_COMPLEX;
                  return(!0);
       case '5' :
       case 'd' : if(stype[1]=='o'){
                     *type=VFF_TYP_DOUBLE;
                     return(!0);
                  }else if(stype[1]=='c'){
                     *type=VFF_TYP_DCOMPLEX;
                     return(!0);
                  }
       default  : return(0);
   }
}

