 /*
  * Khoros: $Id: put_line.c,v 1.2 1991/10/02 00:33:21 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: put_line.c,v 1.2 1991/10/02 00:33:21 khoros Exp $";
#endif

 /*
  * $Log: put_line.c,v $
 * Revision 1.2  1991/10/02  00:33:21  khoros
 * HellPatch2
 *
  */ 

/******************************************************************

	Put a Line to the Answer File

	fortran source filename:		put_line.c

	revision	date			programmer
	--------	----			----------
	   0.0		March-26-85		don hush
	   0.1          Sept 7, 1987            John M Salas

******************************************************************

	calling sequence

	  err = put_line(key,arg,type)

	  int err;
	  char *key,type;
	  char *arg;

	purpose

	  To put a line into the answer file in the correct format.

        0.1 - Modified so that the - symbol can be used as the
	      designation for input/output to be stdin/stdout.
	      In conjunction with uio routines and to keep the
	      UNIX standard.  But, kept the ability to have
	      no input/output file specified.

	routines called by this routine

	argument(s) required from the calling routine

	arqument(s) supplied to the calling routine

******************************************************************/

#include "vgparm.h"
#define mode 00644

extern char make_name[];

put_line(key,arg,type)

char *key,type;
char *arg;

{
    int  fd;
    char line[MAX_LINE_LEN];

    switch (type) {

	case 's' :
	    sprintf(line,"%s %s\n",key,arg);
	    break;

	case 'l' :
	    if (*(int *) arg) 
	        sprintf(line,"%s t\n",key);
	    else
	        sprintf(line,"%s f\n",key);
	    break;

	case 'i' :
	    sprintf(line,"%s  %d\n",key,*(int *)arg);
	    break;

	case 'f' :
	    sprintf(line,"%s %f\n",key, *(float *)arg);
	    break;

	default :
	    return(-1);
    }

    if (strcmp(make_name,"-")==0) {
    	fd = open("/dev/tty",O_RDWR,0666);
	if (fd<1) {
	    fprintf(stderr,"ERROR-put_line cannot open channel to terminal\n");
	    exit(1);
        }
    	write(fd,line,VStrlen(line));
	close(fd);
    }
    else {
    	fd = open(make_name,O_WRONLY|O_APPEND,mode);
    	if (fd < 0)
    	    if ((fd = open(make_name,O_WRONLY|O_APPEND|O_CREAT,mode)) < 0)
	    	fprintf(stderr,"gparm: WARNING , put_line cannot open make file !\n");
    	write(fd,line,VStrlen(line));
    	close(fd);
    }

    return(0);
}
