 /*
  * Khoros: $Id: lviso2.h,v 1.1 1991/05/10 04:15:50 khoros Exp $
  */

 /*
  * $Log: lviso2.h,v $
 * Revision 1.1  1991/05/10  04:15:50  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                        <<<<
   >>>>	    file name: lviso.h                                 <<<<
   >>>>                                                        <<<<
   >>>>      contains: contains data structure used by lviso.c <<<<
   >>>>                version of the current release.         <<<<
   >>>>                                                        <<<<
   >>>>      written by: Tom Sauer 			       <<<<
   >>>>                                                        <<<<
   >>>>      date: 2/1/90                                      <<<<
   >>>>                                                        <<<<
   >>>>      modifications:				       <<<<
   >>>>                                                        <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _lviso2_
#define _lviso2_

#define OUT -1 

struct c_struct {
    int dimension;		/* dimension of vectors 	      */
    int n_clusters;		/* K - # of cluster centers           */
    int max_n_iters_kmeans;	/* max # iterations                   */
    int n_vects;		/* # of vectors in input file         */
    int *kmean_iter;		/* # of kmeans iterations/iso iter    */
    int *class;			/* class[i] assoc. with ith vector    */
    float *n_pts;		/* n_pts[i] # points in cluster i     */
    float **input_vectors;	/* x[i] pointer to ith input vector   */
    float **c_center;		/* c_center[i] ith cluster center     */
    double **avg;		/* avg[i] ith new cluster center value*/
    double **var;		/* var[i] ith new cluster center value*/
};

struct iso_params {
    int change;
    int max_cl_allowed;		/* max # of clusters allowed          */
    int discarded_vects;	/* # vectors discarded (cumulative)   */
    int max_n_iters_iso;	/* max # iterations through isodata   */
    int min_pts_allowed;	/* min points per cluster domain      */
    int iter_iso;		/* isodata iterations		      */
    float split_factor;		/* split_factor*sd_avg =max_sd_allowed*/
    float merge_factor;		/* mrge_factor*avg_dist=min_dist_allow*/
    float merge_converge;	/* merging convergence parameter      */
    float split_converge;	/* splitting convergence parameter    */
    float placement;		/* splitting parameter                */
    float d_overall_avg;	/* overall avg distance from cluster  */
				/* points to their cluster centers.   */
    float *d_avg;		/* avg distance of cluster pts from   */
				/* their cluster center               */
    float *merge_stat;		/* keeps track of clusters that have  */
				/* already been merged.		      */
    float *sd;			/* std dev array of (dim = dimension) */
    float *max_sd;		/* max std dev array (dim = n_clusters*/
    int   *max_sd_dim;		/* dim in which std dev is max        */
    float **dist_bet_c;		/* pairwise distance between c_centers*/
    int   *merge_map;		/* Map used for merging clusters      */
    int   *shift_map;		/* Map used for shifting clusters      */
};

#endif
