 /*
  * Khoros: $Id: vsignal.h,v 1.2 1991/07/15 05:48:50 khoros Exp $
  */

 /*
  * $Log: vsignal.h,v $
 * Revision 1.2  1991/07/15  05:48:50  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#ifndef _vsignal_h_
#define _vsignal_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file:  vsignal.h					 <<<<
   >>>>                                                          <<<<
   >>>>      contains: #includes needed for routines that use    <<<<
   >>>>		       system dependant signal().		 <<<<
   >>>>                                                          <<<<
   >>>>	     written by:  Mark & Tom				 <<<<
   >>>>                                                          <<<<
   >>>>      date:  4/2/91					 <<<<    
   >>>>                                                          <<<<
   >>>>      modifications: 					 <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

/*
 *  UNICOS doesn't have <sys/wait.h>
 */
#ifndef UNICOS
#include <sys/wait.h>
#endif

/*
 *  Make sure WNOHANG & WUNTRACED are defined
 */
#ifndef WNOHANG
#define WNOHANG		1	/* Don't hang in wait */
#endif

#ifndef WUNTRACED
#define WUNTRACED	2	/* Tell about stopped, untraced children */
#endif

#ifndef WSTOPPED
#define WSTOPPED	0177	/* Tell if a process is stopped */
#endif

/*
 *  Define vsignal to be either a int or void depending is SIGNALRETURNSINT
 *  is defined
 */
#if defined(SIGNALRETURNSINT)
#define vsignal int
#else
#define vsignal void
#endif

/*
 *  Define vstatus to be either a int or union wait
 */

#if defined(SYSV) && !defined(_IBMR2)

typedef int vstatus;

#ifndef WIFEXITED
#define WIFEXITED(x)	((x & 0xff) == 0)
#endif

#ifndef WEXITSTATUS
#define WEXITSTATUS(x)  ((x >> 8) & 0xff)
#endif

#ifndef WIFSIGNALED
#define WIFSIGNALED(x)	((((x >> 8) & 0xff) == 0) && ((x & 0x7f) != 0))
#endif

#ifndef WTERMSIG
#define WTERMSIG(x)	(x & 0x7f)
#endif

#ifndef WIFSTOPPED
#define WIFSTOPPED(x)	((((x >> 8) & 0xff) != 0) && ((x & 0xff) == 0x7f))
#endif

#ifndef WSTOPSIG
#define WSTOPSIG(x)	((x >> 8) & 0xff)
#endif

#else

typedef union wait vstatus;

#ifndef WIFEXITED
#define WIFEXITED(x)	(((union wait *)&(x))->w_stopval != WSTOPPED && \
			 ((union wait *)&(x))->w_termsig == 0)
#endif

#ifndef WEXITSTATUS
#define WEXITSTATUS(x)	(((union wait *)&(x))->w_retcode)
#endif

#ifndef WIFSIGNALED
#define WIFSIGNALED(x)	(((union wait *)&(x))->w_stopval != WSTOPPED && \
			 ((union wait *)&(x))->w_termsig != 0)
#endif

#ifndef WTERMSIG
#define WTERMSIG(x)	(((union wait *)&(x))->w_termsig)
#endif

#ifndef WIFSTOPPED
#define WIFSTOPPED(x)	(((union wait *)&(x))->w_stopsig == WSTOPPED)
#endif

#ifndef WSTOPSIG
#define WSTOPSIG(x)	(((union wait *)&(x))->w_stopsig)
#endif

#endif


#endif /* _vsignal_h_ */
/* Don't add after the endif */
