/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.util;

import java.util.AbstractList;
import java.util.LinkedList;

public final class Sequence
extends AbstractList {
    private final Integer[] sequence;

    public final Object get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + this.size());
        }
        return this.sequence[index];
    }

    public final int size() {
        return this.sequence.length;
    }

    public final Object[] toArray() {
        return (Object[])this.sequence.clone();
    }

    public Sequence(int end) {
        this(0, end, 1);
    }

    public Sequence(int start, int end) {
        this(start, end, 1);
    }

    public Sequence(int start, int end, int span) {
        if (span == 0) {
            this.sequence = start != end ? new Integer[]{new Integer(start), new Integer(end)} : new Integer[]{new Integer(start)};
        } else {
            LinkedList<Integer> l = new LinkedList<Integer>();
            int i = start;
            while (i != end) {
                l.add(new Integer(i));
                i += span;
            }
            l.add(new Integer(end));
            this.sequence = l.toArray(new Integer[l.size()]);
        }
    }
}

