(* special values -Definition v3 page 45 *)

(*
$File: Interpreter/SpecialValue.sml $
$Date: 1991/11/08 13:25:49 $
$Revision: 1.5 $
$Locker:  $
*)

(*$SpecialValue: SCON SPECIAL_VALUE CRASH*)
functor SpecialValue(structure SCon: SCON
		     structure Crash: CRASH
		    ): SPECIAL_VALUE =
  struct
    datatype SVal = INT of int | STR of string | REAL of real
    type scon = SCon.scon

   (* constructors and destructors *)

    val mkSValInt = INT

    fun unSValInt(INT i) = i
      | unSValInt _ = Crash.impossible "unSValInt"

    val mkSValString = STR

    fun unSValString(STR s) = s
      | unSValString _ = Crash.impossible "unSValString"

    val mkSValReal = REAL

    fun unSValReal(REAL r) = r
      | unSValReal _ = Crash.impossible "unSValReal"

    fun mkSValSCon scon =
      case scon
	of SCon.INTEGER x => INT x
	 | SCon.STRING x  => STR x
	 | SCon.REAL x    => REAL x

    (* printing *)
    fun pr_SVal(INT i) = Int.string i
      | pr_SVal(STR s) = String.string s
      | pr_SVal(REAL r) = Real.string r
  end;
