(*
$File: Compiler/Evaluation.sml $
$Date: 1992/09/18 18:04:15 $
$Revision: 1.2 $
$Locker:  $
*)

(* Build-file for the lambda compiler. It returns a dynamic basis
   package and an EvalTopdec, but the internals use the lambda code
   generator and interpreter. This version believes in the core language
   only. *)

(*$Evaluation:
	LAB CON SCON EXCON VAR RESIDENT DEC_GRAMMAR PPDECGRAMMAR
	TOPDEC_GRAMMAR PPTOPDECGRAMMAR GRAMMAR_INFO
	TYPE_INFO FINMAP BASIC_IO REPORT FLAGS PRETTYPRINT
	CRASH DYNAMIC_BASIS EVALTOPDEC VAL_PRINT Lvars CompilerEnv LambdaExp
	CompilerDynamicBasis CompileAndRun CompileDec OptLambda MatchCompiler
	Runtime RunLambda Apply
 *)

functor Evaluation(structure Lab: LAB
		   structure Con: CON
		   structure SCon: SCON
		   structure Excon: EXCON
		   structure Var: VAR

		   structure ResIdent: RESIDENT
		     sharing type ResIdent.longvar = Var.longvar
			 and type ResIdent.longcon = Con.longcon
			 and type ResIdent.longexcon = Excon.longexcon

		   structure DecGrammar: DEC_GRAMMAR
		     sharing type DecGrammar.id = Var.var
		         and type DecGrammar.con = Con.con
			 and type DecGrammar.lab = Lab.lab
			 and type DecGrammar.scon = SCon.scon
			 and type DecGrammar.excon = Excon.excon
			 and type DecGrammar.longid = ResIdent.longid

		   structure PPDecGrammar: PPDECGRAMMAR
		     sharing PPDecGrammar.G = DecGrammar

		   structure TopdecGrammar: TOPDEC_GRAMMAR
		     sharing type TopdecGrammar.dec = DecGrammar.dec

		   structure PPTopdecGrammar: PPTOPDECGRAMMAR
		     sharing PPTopdecGrammar.G = TopdecGrammar

		   structure OverloadingInfo: OVERLOADING_INFO
		   structure GrammarInfo: GRAMMAR_INFO
		     sharing type TopdecGrammar.info
				  = DecGrammar.info
				  = GrammarInfo.PostElabGrammarInfo
			 and type OverloadingInfo.info = GrammarInfo.OverloadingInfo
		   structure TypeInfo: TYPE_INFO
		     sharing type TypeInfo.info = GrammarInfo.TypeInfo
			 and type TypeInfo.lab = Lab.lab
			 and type TypeInfo.longcon = Con.longcon

		   structure StatObject:
		     sig
		       type TypeScheme
		     end

		   structure FinMap: FINMAP
		   structure BasicIO: BASIC_IO
		   structure Report: REPORT
		   structure Flags: FLAGS

		   structure PP: PRETTYPRINT
		     sharing type FinMap.StringTree
				  = PPDecGrammar.StringTree
				  = PPTopdecGrammar.StringTree
				  = GrammarInfo.StringTree
				  = PP.StringTree

			 and type PP.Report = Report.Report

		   structure Crash: CRASH
		  ): sig
		       structure DynamicBasis: DYNAMIC_BASIS
		       structure EvalTopdec: EVALTOPDEC
		       structure ValPrint: VAL_PRINT
		     end =
  struct
    structure Lvars = Lvars()

    structure LambdaExp =
      LambdaExp(structure Lvars = Lvars
		structure FinMap = FinMap
		structure PP = PP
		structure Crash = Crash
	       )

    structure CompilerEnv =
      CompilerEnv(structure Var = Var
		  structure Excon = Excon
		  structure Lvars = Lvars
		  structure FinMap = FinMap
		  structure PP = PP
		  structure Crash = Crash
		 )

    structure Runtime =
      Runtime(structure Lvars = Lvars
	      structure LambdaExp = LambdaExp
	      structure FinMap = FinMap
	      structure PP = PP
	      structure Crash = Crash
	     )

    structure DynamicBasis =
      CompilerDynamicBasis(structure CompilerEnv = CompilerEnv
			   structure DynamicEnv = Runtime.DynamicEnv
			   structure Report = Report
			   structure PP = PP
			  )

    structure EvalTopdec =
      CompileAndRun(structure DecGrammar = DecGrammar
		    structure TopdecGrammar = TopdecGrammar
		    structure GrammarInfo = GrammarInfo
		    structure R = ResIdent
		    structure FinMap = FinMap
		    structure LambdaExp = LambdaExp
		    structure CompilerEnv = CompilerEnv

		    structure CompileDec =
		      CompileDec(
                        structure Lab = Lab
			structure Var = Var
			structure Con = Con
			structure SCon = SCon
			structure Excon = Excon
			structure Grammar = DecGrammar
			structure ResIdent = ResIdent
			structure Lvars = Lvars
			structure LambdaExp = LambdaExp
			structure CompilerEnv = CompilerEnv

			structure MatchCompiler =
			  MatchCompiler(
			    structure Var = Var
			    structure Con = Con
			    structure SCon = SCon
			    structure Lab = Lab
			    structure Excon = Excon
			    structure ResIdent = ResIdent
			    structure Grammar = DecGrammar
			    structure PPDecGrammar = PPDecGrammar
			    structure CompilerEnv = CompilerEnv
			    structure GrammarInfo = GrammarInfo
			    structure Lvars = Lvars
			    structure TypeInfo = TypeInfo
			    structure FinMap = FinMap
			    structure BasicIO = BasicIO
			    structure Report = Report
			    structure Flags = Flags
			    structure PP = PP
			    structure Crash = Crash
			  )

			structure GrammarInfo = GrammarInfo
			structure OverloadingInfo = OverloadingInfo
			structure TypeInfo = TypeInfo
		      (*val nj_sml_bug = (fn x => x)*)
			structure FinMap = FinMap
			structure Crash = Crash
		      )

		    structure OptLambda =
		      OptLambda(structure Lvars = Lvars
				structure LambdaExp = LambdaExp
				structure BasicIO = BasicIO
				structure Flags = Flags
				structure FinMap = FinMap
			       )

		    structure Runtime = Runtime
		    structure DynamicBasis = DynamicBasis

		    structure RunLambda =
		      RunLambda(structure Lvars = Lvars
				structure LambdaExp = LambdaExp
				structure Runtime = Runtime

				structure Apply =
				  Apply(structure Objects = Runtime.Objects
					structure Crash = Crash
				       )

				structure FinMap = FinMap
				structure Crash = Crash
			       )

		    structure Report = Report
		    structure Flags = Flags
		    structure PP = PP
		    structure Crash = Crash
		   )

    structure ValPrint =
      struct
	type id = Var.id
	type strid = TopdecGrammar.strid
	type DynamicBasis = DynamicBasis.Basis
	type TypeScheme = StatObject.TypeScheme
	type Val = Runtime.Objects.object

	fun lookup basis id: Val =
	  let
	    val (ce, de) = DynamicBasis.deBasis basis
	    val lv = CompilerEnv.lookupId ce id
	  in
	    Runtime.DynamicEnv.lookup de lv
	  end

	fun locate(dynamicBasis, strids, id): Val =
	  case strids
	    of nil =>
	         lookup dynamicBasis id

	     | _ =>
		 Crash.unimplemented("Evaluation.ValPrint.locate("
				     ^ Var.pr_var(Var.mkVar id) ^ ")"
				    )

	fun print(v, typeScheme) =
	  PP.flatten1(Runtime.Objects.layoutObject v)
      end
  end;
