(*
$File: Common/SourceInfo.sml $
$Date: 1992/02/13 11:32:39 $
$Revision: 1.3 $
$Locker: birkedal $
*)

(*$SourceInfo: LEX_BASICS PRETTYPRINT CRASH SOURCE_INFO*)

functor SourceInfo(structure LexBasics: LEX_BASICS

		   structure PP: PRETTYPRINT
		     sharing type LexBasics.StringTree = PP.StringTree

		   structure Crash: CRASH
		  ): SOURCE_INFO =
  struct
    open LexBasics

    datatype info = POSinfo of {left: pos, right: pos}

    fun putPositions(left, right) = POSinfo{left=left, right=right}
    fun getPositions(POSinfo{left, right}) = (left, right)

    type Report = LexBasics.Report

    fun report(POSinfo{left, right}) =
      LexBasics.reportPosition{left=left, right=right}

    type StringTree = PP.StringTree
    fun layoutInfo(POSinfo{left, right}) =
      PP.NODE{start="SourceInfo(", finish=")", indent=0,
	      childsep=PP.RIGHT ", ",
	      children=[layoutPos left, layoutPos right]
	     }
  end;
