/* PVM testing routines version 1.0 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pvm3.h>
#include <ctype.h>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include "inc.h"
#define malloc(n)  pvm_alloc((n),"xxx") 
#define free(p)    pvm_free(p) 
#define MAXLINE 200
#define MAXLINELEN 1000
#define MAXHOSTS 100
#define MAXHOSTNAMELEN 100
#define NUMTESTS 79
#define EXIT_TAG 20
#define SNOOZ 1

float *dtime, mtime, mtimtot1 = 0, mtimtot2 = 0, mtimtot3 = 0;
float *timtot1, *timtot2, *timtot3;
int mytid,msgtid,k,prnflg=0, nprn;
int narch,nhost,tstmod, none = 1;
int ncpu,mflg=0,datflg=0, bombrd=0, bombard = 0, head = 0, triangle = 0;
int *infos;
int TEST_FLAG=0;
struct hostinfo *hostp;
int tid;
int i,j,ii;
int nproc, nproc_err=0;
int nmess, nmess_err=0;
int nsize, nsize_err=0;
FILE *infile;
FILE *outfile;
char *line,*def;
char **hostpool, **ver;
int hostcnt=0;
char *machine;
char *testset;
char  *out;
char *cmsg = "config:";
char *msgfile;
char *proc;
char *mess;
char *smess;
time_t now;
struct tinfo {
    char *tfnct;
    int tflag;

/* section A (test identifier) */

} t[80] = {
    "      ", 0,
    "test01 : pvm_addhosts()", 0,
    "test02 : PVM response when pvm_addhosts() fails", 0,
    "test03 : pvm_delhosts()", 0,
    "test04 : PVM response when pvm_delhosts() fails", 0,
    "test05 : pvm_addhosts() followed by pvm_delhosts()", 0,
    "test06 : proper pvm_config() response to a pvm_addhosts() call", 0,
    "test07 : proper pvm_config() response to a pvm_delhosts() call", 0,
    "test08 : multiple group servers are not started", 0,
    "test09 : PVM response when pvm_joingroup() fails", 0,
    "test10 : PVM response when pvm_lvgroup() fails", 0,
    "test11 : pvm_joingroup()", 0,
    "test12 : pvm_lvgroup()", 0,
    "test13 : termination of group on completion of tasks", 0,
    "test14 : PVM response to an illegal NULL group name", 0,
    "test15 : pvm_bcast()", 0,
    "test16 : pvm_barrier()", 0,
    "test17 : pvm_getinst() and pvm_gettid()", 0,
    "test18 : PVM response to pvm_getinst call for a task not in group", 0,
    "test19 : PVM response to pvm_getinst call for instance not in group", 0,
    "test20 : pvm_getsbuf()", 0,
    "test21 : PVM response to pvm_getsbuf() call with no buffer", 0,
    "test22 : pvm_getrbuf()", 0,
    "test23 : PVM response to pvm_getrbuf() call with no receive buffer", 0,
    "test24 : pvm_setsbuf()", 0,
    "test25 : pvm_setrbuf()", 0,
    "test26 : pvm_setsbuf()", 0,
    "test27 : pvm_tidtohost()", 0,
    "test28 : pvm_sendsig()", 0,
    "test29 : simultaneous spawning of multiple tasks", 0,
    "test30 : sequential spawning of multiple tasks", 0,
    "test31 : pvm_kill()", 0,
    "test32 : bombard,   no coding,  daemon routing, send,  data", 0,
    "test33 : bombard,   no coding,  daemon routing, mcast, data", 0,
    "test34 : bombard,   no coding,  direct routing, send,  data", 0,
    "test35 : bombard,   no coding,  direct routing, mcast, data", 0,
    "test36 : bombard,   XDR coding, daemon routing, send,  data", 0,
    "test37 : bombard,   XDR coding, daemon routing, mcast, data", 0,
    "test38 : bombard,   XDR coding, direct routing, send,  data", 0,
    "test39 : bombard,   XDR coding, direct routing, mcast, data", 0,
    "test40 : head-head, no coding,  daemon routing, send,  data", 0,
    "test41 : head-head, no coding,  daemon routing, mcast, data", 0,
    "test42 : head-head, no coding,  direct routing, send , data", 0,
    "test43 : head-head, no coding,  direct routing, mcast, data", 0,
    "test44 : head-head, XDR coding, daemon routing, send,  data", 0,
    "test45 : head-head, XDR coding, daemon routing, mcast, data", 0,
    "test46 : head-head, XDR coding, direct routing, send,  data", 0,
    "test47 : head-head, XDR coding, direct routing, mcast, data", 0,
    "test48 : triangle,  no coding,  daemon routing, send,  data", 0,
    "test49 : triangle,  no coding,  daemon routing, mcast, data", 0,
    "test50 : triangle,  no coding,  direct routing, send,  data", 0,
    "test51 : triangle,  no coding,  direct routing, mcast, data", 0,
    "test52 : triangle,  XDR coding, daemon routing, send,  data", 0,
    "test53 : triangle,  XDR coding, daemon routing, mcast, data", 0,
    "test54 : triangle,  XDR coding, direct routing, send,  data", 0,
    "test55 : triangle,  XDR coding, direct routing, mcast, data", 0,
    "test56 : bombard,   no coding,  daemon routing, send,  no data", 0,
    "test57 : bombard,   no coding,  daemon routing, mcast, no data", 0,
    "test58 : bombard,   no coding,  direct routing, send,  no data", 0,
    "test59 : bombard,   no coding,  direct routing, mcast, no data", 0,
    "test60 : bombard,   XDR coding, daemon routing, send,  no data", 0,
    "test61 : bombard,   XDR coding, daemon routing, mcast, no data", 0,
    "test62 : bombard,   XDR coding, direct routing, send,  no data", 0,
    "test63 : bombard,   XDR coding, direct routing, mcast, no data", 0,
    "test64 : head-head, no coding,  daemon routing, send,  no data", 0,
    "test65 : head-head, no coding,  daemon routing, mcast, no data", 0,
    "test66 : head-head, no coding,  direct routing, send,  no data", 0,
    "test67 : head-head, no coding,  direct routing, mcast, no data", 0,
    "test68 : head-head, XDR coding, direct routing, send,  no data", 0,
    "test69 : head-head, XDR coding, daemon routing, mcast, no data", 0,
    "test70 : head-head, XDR coding, direct routing, send,  no data", 0,
    "test71 : head-head, XDR coding, direct routing, mcast, no data", 0,
    "test72 : triangle,  no coding,  daemon routing, send,  no data", 0,
    "test73 : triangle,  no coding,  daemon routing, mcast, no data", 0,
    "test74 : triangle,  no coding,  direct routing, send,  no data", 0,
    "test75 : triangle,  no coding,  direct routing, mcast, no data", 0,
    "test76 : triangle,  XDR coding, daemon routing, send,  no data", 0,
    "test77 : triangle,  XDR coding, daemon routing, mcast, no data", 0,
    "test78 : triangle,  XDR coding, direct routing, send,  no data", 0,
    "test79 : triangle,  XDR coding, direct routing, mcast, no data", 0
};




/* section A end */

task_check(nproc)
int nproc;
{
  int i;
  struct taskinfo *taskp;

  while (i > 0)
  {
    sleep(SNOOZ);
    pvm_tasks( 0, &i, &taskp);
  }
}

repair()
{
	int nhost, narch;
	struct hostinfo *hostp;
	int n = 0;

	pvm_config(&nhost, &narch, &hostp);
	while (nhost != 1) {
	    sleep(SNOOZ);
	    pvm_config(&nhost, &narch, &hostp);
	}
}


main(argc,argv)
int argc;
char **argv;
{

	char *endline, mhost[MAXHOSTNAMELEN];
	char *tmpline, **tmpbuf, **marg, *tmpstr;
	int s, tmpcnt = 0, info, ncnt, mcnt = 0, dflag = 0, stat; 
        int hcnt = 0;
	char *tptr, **starg, *parch, loc[256];
        FILE *hfile;

	if (argv[1] == NULL) {
	    printf("pvm_test: must supply input file\n");
	    exit(0);
	}
	else {
	    if ((infile = fopen(argv[1], "r")) == NULL){
		fprintf(stdout,"Unable to open %s\n",argv[1]);
		exit(0);
	    }
	    else {

                marg  = (char **)malloc(MAXLINE*sizeof(char *));
                starg = (char **)malloc(2*sizeof(char *));
                tmpstr= (char *)malloc(MAXLINELEN*sizeof(char));

                /* allocate space for 'line' to read in the line for the 
                   input file and allocate space for 'hostpool' to hold names
                   of machines in pvm configuration */

		line = (char *)malloc(MAXLINE*sizeof(char));  
		def  = (char *)malloc(MAXLINE*sizeof(char));  
		hostpool = (char **)malloc(MAXHOSTS*sizeof(char *));
		while (fgets(line, MAXLINE, infile) != NULL) {
		    if ((endline = strchr(line, '\n')) != NULL) {
		        *endline = '\0';
		    }

                    /* continue to read in machine names if the first
                       seven characters are 'config:' */

		    if (strncmp(line, cmsg, 7) == 0) {
		   	i = 0; 
                        marg[mcnt] = (char *)malloc(MAXLINELEN*sizeof(char));

                        /* do not put & on the first machine since it is
                           assumed to be the current host */

                        if (mcnt != 0)
                          marg[mcnt][0] = '&';

                        /* allocate space for 'machine' to hold one character
                           at a time of name of machine */

			machine = (char *)malloc(MAXHOSTNAMELEN*sizeof(char));
			if ((tptr = strchr(line, ':')) != NULL) {
			    tptr++; 
			    while (isspace(*tptr))
				tptr++;
			    while (isgraph(*tptr)) {
			        machine[i] = *tptr;
				tptr++;
				i++;
			    }
                            machine[i] = 0;

                            if (hostpool[hostcnt] == NULL)
                              hostpool[hostcnt] = (char *)malloc(MAXHOSTNAMELEN*sizeof(char));

                            /* test for duplicate machine entries */

                            for(j = 0; j <= mcnt; j++)
			    {
                              if (strtst(marg[j], machine) != NULL)
                                dflag = 1;
                            }

                            /* if not duplicate then add entry to options
                               list */

                            if (dflag == 0)
			    {
                              strcat(marg[mcnt],tptr-strlen(machine));
                              mcnt++;

                              /* add all machine names other than the first
                                 to hostpool list */

                              if (hcnt != 0)
                              { 
			        hostpool[hostcnt] = machine;
			        hostcnt++;
                              }  
                            
                            }
                            else
                              dflag = 0;

                            hcnt = 1;
			}
			else {
			    printf("incorrect config format\n");
			    exit(0);
		        }
		    }

/* section B (test selection) */

                    /* determine if test has been selected by looking at the
                       first 3 characters of 'line' */

                    if (line[0] == '[' && line[2] == ']' ) {

                        /* if test has been selected look after the ']'
                           to determine which test and set the appropriate
                           flag in t[i].tflag */


                                              
                        /* if `all_tests' have been selected then set the 
                           flags associated with all the tests in the
                           program */   

			strtok(line, "]");
			testset = strtok(NULL, "]");
                        memset(tmpstr,'\0',strlen(tmpstr));
                        strcpy(tmpstr,"all_tests");
			if (strtst(testset, tmpstr)) {
			    for (i=1; i<NUMTESTS+1; i++)
				t[i].tflag = 1;
			}
			else
			{
                     
                          /* if the `virt_mach' test groups have been selected
                             then set the flags associated with the tests
                             in the section */

                          memset(tmpstr,'\0',strlen(tmpstr));
                          strcpy(tmpstr,"virt_mach");
                          if (strtst(testset, tmpstr)) {
			      for (i=1; i<8; i++)
				  t[i].tflag = 1;
			  }

                          /* set the flag associated with individual tests
                             in the `virt_mach' section that have been 
                             selected */  

                          else
			  {
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test01");
			    if (strtst(testset, tmpstr)) 
			        t[1].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test02");
			    if (strtst(testset, tmpstr)) 
			        t[2].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test03");
		            if (strtst(testset, tmpstr)) 
			        t[3].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test04");
			    if (strtst(testset, tmpstr)) 
			        t[4].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test05");
			    if (strtst(testset, tmpstr)) 
			        t[5].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test06");
			    if (strtst(testset, tmpstr)) 
			        t[6].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test07");
			    if (strtst(testset, tmpstr)) 
			        t[7].tflag = 1;
                          }

                          /* if the `groups' box was checked then set the flag
                             associated with all the tests in the groups
                             test section */

                          memset(tmpstr,'\0',strlen(tmpstr));
                          strcpy(tmpstr,"groups");
			  if (strtst(testset, tmpstr)) {
			      for (i=8; i<20; i++)
				t[i].tflag = 1;
			  }

                          /* set the flag associated with individual tests
                             in the `groups' section that have been 
                             selected */  

                          else
			  {
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test08");
			    if (strtst(testset, tmpstr)) 
			        t[8].tflag = 1;		
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test09");	
                            if (strtst(testset, tmpstr)) 
			        t[9].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr, "test10");
			    if (strtst(testset, tmpstr)) 
			        t[10].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test11");
			    if (strtst(testset, tmpstr)) 
                                t[11].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test12");
			    if (strtst(testset, tmpstr)) 
			        t[12].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test13");
			    if (strtst(testset, tmpstr)) 
			        t[13].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test14");
			    if (strtst(testset, tmpstr)) 
			        t[14].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test15");
			    if (strtst(testset, tmpstr)) 
			        t[15].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test16");
			    if (strtst(testset, tmpstr)) 
			        t[16].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test17");
			    if (strtst(testset, tmpstr)) 
			        t[17].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test18");
			    if (strtst(testset, tmpstr)) 
			        t[18].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test19");
			    if (strtst(testset, tmpstr)) 
			        t[19].tflag = 1;
			  }

                          /* if the `msg_buf' box was checked then set the flag
                             associated with all the tests in the 
                             test section */

                          memset(tmpstr,'\0',strlen(tmpstr));
                          strcpy(tmpstr,"msg_buf");
			  if (strtst(testset, tmpstr)) {
			      for (i=20; i<27; i++)
				  t[i].tflag = 1;
			  }

                          /* set the flag associated with individual tests
                             in the `msg_buf' section that have been 
                             selected */  

			  else
			  {
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test20");
			    if (strtst(testset, tmpstr)) 
			        t[20].tflag = 1;	
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test21");		
		 	    if (strtst(testset, tmpstr)) 
			        t[21].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test22");
			    if (strtst(testset, tmpstr)) 
			        t[22].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test23");
			    if (strtst(testset, tmpstr)) 
			        t[23].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test24");
			    if (strtst(testset, tmpstr)) 
			        t[24].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test25");
			    if (strtst(testset, tmpstr)) 
			        t[25].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test26");
			    if (strtst(testset, tmpstr)) 
			        t[26].tflag = 1;
			  }

                          /* if the `misc' box was checked then set the flag
                             associated with all the tests in the test 
                             section */

                          memset(tmpstr,'\0',strlen(tmpstr));
                          strcpy(tmpstr,"misc");
			  if (strtst(testset, tmpstr)) {
			      t[27].tflag = 1;
			      t[28].tflag = 1;
			  }

                          /* set the flag associated with individual tests
                             in the `misc' section that have been 
                             selected */  

			  else
			  {
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test27");
			    if (strtst(testset, tmpstr)) 
			        t[27].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test28");
			    if (strtst(testset, tmpstr)) 
			        t[28].tflag = 1;
			  }

                          /* if the `spawn_&_kill' box was checked then set 
                             the flag associated with all the tests in the 
                             test section */

                          memset(tmpstr,'\0',strlen(tmpstr));
                          strcpy(tmpstr,"spawn_&_kill");
                          if (strtst(testset, tmpstr))  {
                              t[29].tflag = 1;
                              t[30].tflag = 1;
                              t[31].tflag = 1;
			  }

                          /* set the flag associated with individual tests
                             in the `misc' section that have been 
                             selected */  

			  else
			  {
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test29");
                            if (strtst(testset, tmpstr))  
                                t[29].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test30");
                            if (strtst(testset, tmpstr))  
                                t[30].tflag = 1;
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"test31");
                            if (strtst(testset, tmpstr))  
                                t[31].tflag = 1;
			  }

                          /* if all the message tests have been selected then
                             set all the flags associated with the message 
                             tests section */

                          memset(tmpstr,'\0',strlen(tmpstr));
                          strcpy(tmpstr,"all_msg");
                          if (strtst(testset, tmpstr)) {
			    for (i=32; i<80; i++)
				t[i].tflag = 1;
                            bombard  = 1;
                            head     = 1;
                            triangle = 1;
                          }

                          /* if `bombrd_dat' has been checked then set all
                             the flags associated with this test section */

                          else
			  {
                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"bombrd_dat");
                            if (strtst(testset, tmpstr)) {
			        for (i=32; i<40; i++)
				    t[i].tflag = 1;
                                bombard = 1;
                            }

                            /* set the flag for the individual test in the
                               `bombrd_dat' that have been selected */

			    else
			    {
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test32");
			      if (strtst(testset, tmpstr)) 
			          t[32].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test33");
			      if (strtst(testset, tmpstr))  
			          t[33].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test34");
			      if (strtst(testset, tmpstr)) 
			          t[34].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test35");
			      if (strtst(testset, tmpstr))  
			          t[35].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test36");
			      if (strtst(testset, tmpstr)) 
			          t[36].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test37");
			      if (strtst(testset, tmpstr)) 
			          t[37].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test38");
			      if (strtst(testset, tmpstr)) 
			          t[38].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test39");
			      if (strtst(testset, tmpstr)) 
			          t[39].tflag = 1;

                              for (i = 32; i < 40; i++)
			      {
                                 if (t[i].tflag == 1)
                                   bombard = 1;
			      }
			    }

                          /* if `head_dat' has been checked then set all
                             the flags associated with this test section */

                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"head_dat");
                            if (strtst(testset, tmpstr)) {
			        for (i=40; i<48; i++)
				    t[i].tflag = 1;
                                head = 1;
                            }

                            /* set the flag for the individual test in the
                               `head_dat' that have been selected */

			    else
			    {
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test40");
			      if (strtst(testset, tmpstr)) 
			          t[40].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test41");
			      if (strtst(testset, tmpstr)) 
			          t[41].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test42");
			      if (strtst(testset, tmpstr)) 
			          t[42].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test43");
			      if (strtst(testset, tmpstr)) 
			          t[43].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test44");
			      if (strtst(testset, tmpstr)) 
			          t[44].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test45");
			      if (strtst(testset, tmpstr)) 
			          t[45].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test46");
			      if (strtst(testset, tmpstr)) 
			          t[46].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test47");
			      if (strtst(testset, tmpstr)) 
			          t[47].tflag = 1;

                              for (i = 40; i < 48; i++)
			      {
                                 if (t[i].tflag == 1)
                                   head = 1;
			      }
			    }


                            /* if `triangle_dat' has been checked then set all
                               the flags associated with this test section */

                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"triangle_dat");
                            if (strtst(testset, tmpstr)) {
			        for (i=48; i<56; i++)
				    t[i].tflag = 1;
                                triangle = 1;
                            }

                            /* set the flag for the individual test in the
                               `triangle_dat' that have been selected */

			    else
			    {
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test48");
			      if (strtst(testset, tmpstr)) 
			          t[48].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test49");
			      if (strtst(testset, tmpstr)) 
			          t[49].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test50");
			      if (strtst(testset, tmpstr)) 
			          t[50].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test51");
			      if (strtst(testset, tmpstr)) 
			          t[51].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test52");
			      if (strtst(testset, tmpstr)) 
			          t[52].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test53");
			      if (strtst(testset, tmpstr)) 
			          t[53].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test54");
			      if (strtst(testset, tmpstr)) 
			          t[54].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test55");
			      if (strtst(testset, tmpstr)) 
			          t[55].tflag = 1;

                              for (i = 48; i < 56; i++)
			      {
                                 if (t[i].tflag == 1)
                                   triangle = 1;
			      }
			    }

                            /* if `bombrd_ndat' has been checked then set all
                               the flags associated with this test section */

                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"bombrd_ndat");
                            if (strtst(testset, tmpstr)) {
			        for (i=56; i<64; i++)
				    t[i].tflag = 1;
                                bombard = 1;
                            }

                            /* set the flag for the individual test in the
                               `bombrd_ndat' that have been selected */

			    else
			    {
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test56");
			      if (strtst(testset, tmpstr)) 
			          t[56].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test57");
			      if (strtst(testset, tmpstr)) 
			          t[57].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test58");
			      if (strtst(testset, tmpstr)) 
			          t[58].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test59");
			      if (strtst(testset, tmpstr)) 
			          t[59].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test60");
			      if (strtst(testset, tmpstr)) 
			          t[60].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test61");
			      if (strtst(testset, tmpstr)) 
			          t[61].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test62");
			      if (strtst(testset, tmpstr)) 
			          t[62].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test63");
			      if (strtst(testset, tmpstr)) 
			          t[63].tflag = 1;

                              for (i = 56; i < 64; i++)
			      {
                                 if (t[i].tflag == 1)
                                   bombard = 1;
			      }
			    }

                            /* if `head_ndat' has been checked then set all
                               the flags associated with this test section */

                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"head_ndat");
                            if (strtst(testset, tmpstr)) {
	   		        for (i=64; i<72; i++)
				    t[i].tflag = 1;
                                head = 1;
                            }

                            /* set the flag for the individual test in the
                               `head_ndat' that have been selected */

			    else
			    {
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test64");
			      if (strtst(testset, tmpstr)) 
			          t[64].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test65");
			      if (strtst(testset, tmpstr)) 
			          t[65].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test66");
			      if (strtst(testset, tmpstr)) 
			          t[66].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test67");
			      if (strtst(testset, tmpstr)) 
			          t[67].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test68");
			      if (strtst(testset, tmpstr)) 
			          t[68].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test69");
			      if (strtst(testset, tmpstr)) 
			          t[69].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test70");
			      if (strtst(testset, tmpstr)) 
			          t[70].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test71");
			      if (strtst(testset, tmpstr)) 
			          t[71].tflag = 1;

                              for (i = 64; i < 72; i++)
			      {
                                 if (t[i].tflag == 1)
                                   head = 1;
			      }
 			    }

                            /* if `triangle_ndat' has been checked then set all
                               the flags associated with this test section */

                            memset(tmpstr,'\0',strlen(tmpstr));
                            strcpy(tmpstr,"triangle_ndat");
                            if (strtst(testset, tmpstr)) {
			        for (i=72; i<80; i++)
				    t[i].tflag = 1;
                                triangle = 1;
                            }

                            /* set the flag for the individual test in the
                               `triangle_ndat' that have been selected */

			    else
			    {
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test72");
			      if (strtst(testset, tmpstr)) 
			          t[72].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test73");
			      if (strtst(testset, tmpstr)) 
			          t[73].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test74");
			      if (strtst(testset, tmpstr)) 
			          t[74].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test75");
			      if (strtst(testset, tmpstr)) 
			          t[75].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test76");
			      if (strtst(testset, tmpstr)) 
			          t[76].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test77");
			      if (strtst(testset, tmpstr)) 
			          t[77].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test78");
			      if (strtst(testset, tmpstr)) 
			          t[78].tflag = 1;
                              memset(tmpstr,'\0',strlen(tmpstr));
                              strcpy(tmpstr,"test79");
			      if (strtst(testset, tmpstr)) 
			          t[79].tflag = 1;
                              
                              for (i = 72; i < 80; i++)
			      {
                                 if (t[i].tflag == 1)
                                   triangle = 1;
			      }
			    }
			  }
			}


/* section B end */


/* section C part 1 (option selection) */
                              
                        memset(tmpstr,'\0',strlen(tmpstr));
                        strcpy(tmpstr,"process_time");
			if (strtst(testset, tmpstr))
		          prnflg = 1;
                        memset(tmpstr,'\0',strlen(tmpstr));
                        strcpy(tmpstr,"test_time");
		        if (strtst(testset, tmpstr))
		          prnflg = 2;
                        memset(tmpstr,'\0',strlen(tmpstr));
                        strcpy(tmpstr,"total_time");
		        if (strtst(testset, tmpstr))
                          prnflg = 3;

/* section C part 1 end */

		    }



/* section C part 2 (option selection) */


                    /* if the first 8 characters of line was 'outfile:' then
                       attempt to read int the output file */
		    if (strncmp(line, "outfile:", 8) == 0) {
			i = 0;
			out = (char *)malloc(MAXHOSTNAMELEN*sizeof(char));
			if ((tptr = strchr(line, ':')) != NULL) {
			    tptr++;
			    while (isspace(*tptr))
				tptr++;
			    while (isgraph(*tptr)) {
				out[i] = *tptr;
				tptr++;
				i++;
			    }
			}
                        out[i] = 0;

                        /* if selected output file was 'stdout' then print 
                           result to screen else use indicated file as 
                           output file */

			if (strcmp(out, "stdout") == 0)
			    outfile = stdout;
			else {
			    outfile = fopen(out, "w");
			}
		      }

                    /* if the first 7 characters of 'line' was
                       '#_of_process   :' then read in # of process */

                    if (strncmp(line, "#_of_process:", 13) == 0) {
                        i = 0;
                        proc = (char *)malloc(MAXHOSTNAMELEN*sizeof(char));
			if ((tptr = strchr(line, ':')) != NULL) {
			    tptr++;
			    while (isspace(*tptr))
				tptr++;
			    while (isgraph(*tptr)) {
				proc[i] = *tptr;
				tptr++;
				i++;
			    }
                            proc[i] = 0;

                            nproc = atoi(proc);

                            /* if invalid entry was given by user then 
                               set error flag and default to 2 */

                            if (nproc <= 0) 
                            {
                              nproc_err = 1;                   
                              nproc = 2;
                            }

			}
		    }

                    /* if the first 17 characters of 'line' was 
                       '# of message      :' then read in # of message */

                    if (strncmp(line, "#_of_message:", 13) == 0) {
                        i = 0;
                        mess = (char *)malloc(MAXHOSTNAMELEN*sizeof(char));
			if ((tptr = strchr(line, ':')) != NULL) {
			    tptr++;
			    while (isspace(*tptr))
				tptr++;
			    while (isgraph(*tptr)) {
				mess[i] = *tptr;
				tptr++;
				i++;
			    }
                            mess[i] = 0;
                            nmess = atoi(mess);

                            /* if user gave invalid entry then set error flag
                               and set default value to 10 */

                            if (nmess <= 0) 
                            {
                              nmess_err = 1;
                              nmess = 10;
                            }
			}
                      
		    }

                    /* if the first 17 characters of line was
                       'size of message  :' then read in size of message */

                    if (strncmp(line, "size_of_message_:", 17) == 0) {
                        i = 0;
                        smess = (char *)malloc(MAXHOSTNAMELEN*sizeof(char));
			if ((tptr = strchr(line, ':')) != NULL) {
			    tptr++;
			    while (isspace(*tptr))
				tptr++;
			    while (isgraph(*tptr)) {
				smess[i] = *tptr;
				tptr++;
				i++;
			    }
                            smess[i] = 0;
                            nsize = atoi(smess);  

                            /* if user gave invalid entry then set error flag
                               and set to default of 50 */

                            if (nsize <= 0) 
			    {
                              nsize_err = 1;
                              nsize = 50;
                            }
			}
		    }

/* section C part 2 end */

		free(line);
		line = (char *)malloc(MAXLINE*sizeof(char));
		}
	    }



            for (k = 32; k < 80; k++)
	    {
              if (t[k].tflag == 1) mflg = 1;                          
              if (k > 31 && k < 56 && t[k].tflag == 1) datflg = 1;
              if (((k > 31 && k < 40 )|| (k > 55 && k < 64)) && t[k].tflag)
                bombrd = 1;
            }

	    if (outfile == NULL) {
		outfile = stdout;
		printf("no output file specified...using stdout\n");
	    }

            if ((t[29].tflag == 1 || t[30].tflag == 1 || bombrd == 1) && nproc_err != 0 ) 
            {
              fprintf(outfile,
                  "invalid # of process provided, # of process used = 2\n");
              nproc = 2;
            }

            if (mflg == 1 && nmess_err != 0)
            {
              fprintf(outfile,
                   "# of messages not provided, # of messages used = 10\n");
              nmess = 10;
            }

            if (datflg == 1 && nsize_err != 0)
	    {
              fprintf(outfile,
                  "size of message not provided, size of message used = 50\n");
	    }

            dtime   = (float*)malloc(nproc*sizeof(float));

	    if (prnflg == 3)
	    {
	      timtot1 = (float*)malloc(nproc*sizeof(float));
	      timtot2 = (float*)malloc(nproc*sizeof(float));
	      timtot3 = (float*)malloc(nproc*sizeof(float));

                for(ii = 0; ii < nproc; ii++)
		{
		   timtot1[ii] = 0;
		   timtot2[ii] = 0;
		   timtot3[ii] = 0;
		   dtime[ii]  = 0;
		}
	     }



            marg[mcnt] = NULL;

            starg[0] = (char *)malloc(MAXHOSTNAMELEN*sizeof(char));

            strcpy(starg[0], "hostfile");

            starg[1] = NULL;

            /* write out options to `hostfile' file */

            parch = getenv("PVM_ARCH");
            if (parch == NULL)
	    {
              printf("\n*** `PVM_ARCH' has not been set ***\n");
              exit(0);
            }
            else if (strcmp(parch,"PGON") != 0)
	    {
              hfile = fopen(starg[0], "w");

              for (i = 0; i < mcnt; i++)
                fprintf(hfile,"%s\n",marg[i]);
            
              fclose(hfile);

	      stat = pvm_start_pvmd(1, starg, 1); 

	    }

	    mytid = pvm_mytid();
            if (mytid < 0)
            {
              sprintf(loc,"pvm_test: pvmd not started");
              pvm_perror(loc);
              exit(0);
            }
            

  	    pvm_config(&ncpu, &narch, &hostp);

            strcpy(mhost,hostp[0].hi_name);                            

            /* this code makes sure that the only machine active at the
               start is the current host by deleting any other machine
               in the pvm configuration */

            if (ncpu > 1)
	    {
              tmpbuf = (char **)malloc(ncpu*sizeof(char*));
              for (i = 1; i < ncpu; i++)
	      {
                 tmpbuf[tmpcnt] = hostp[i].hi_name;
                 tmpcnt++;
              }
              pvm_delhosts(tmpbuf, tmpcnt, &info);
              free(tmpbuf);
            } 


            /* print out current PVM version and time */

            fprintf(outfile, "PVM version %s",pvm_version());

            now = time(NULL);
            
            fprintf(outfile, "\t%s",ctime(&now));

            ver = (char **)malloc(hostcnt*sizeof(char *));

            /* Make sure that if the host is an I860 or a PARAGON then
               they are the only machine in the PVM configuration */

            if ((strcmp(hostp[0].hi_arch,"I860") == 0 ||
                strcmp(hostp[0].hi_arch,"PGON") == 0) && hostcnt > 0)
	    {
                fprintf(outfile,"\n*** Invalid PVM configuration, extra machines ignored ***\n");
                hostcnt = 0;
	    }

            if (hostcnt > 0)
	    {
              chk_pool(outfile, hostp, hostpool, &ncpu, &hostcnt);
              ver = version_tst(hostpool, &hostcnt);
            }

	    if (hostcnt < 1) 
            {
              for (i = 1; i <= 28; i++)
	      {
                if (t[i].tflag == 1)
		{
	          printf("\nneed minimum of two hosts to run tests 1-28\n");
                  pvm_halt();
                  pvm_exit();
	          exit(0);
                }
              }
	    }

/* Section D begin */ 


            /*print machine pool to output file */

            fprintf(outfile,"\nmachine pool\n");
            fprintf(outfile,"------------\n");
            fprintf(outfile,"%s\t(host)\n",mhost);
            for(i = 0; i< hostcnt; i++)
	    {
              fprintf(outfile,"%s\t(running PVM %s)\t",hostpool[i],ver[i]);
              if (strcmp(pvm_version(),ver[i]) != 0)
                fprintf(outfile,"*** warning different PVM version ***\n");
              else
                fprintf(outfile,"\n");
            }

/* print user selected options to output file */

            if ((prnflg == 1)&&(bombard==1||head==1||triangle==1))
	    {
              fprintf(outfile,"\ntime display\n");
              fprintf(outfile,"------------\n");
              fprintf(outfile,"time / process\n");
            }
            else if ((prnflg == 2)&&(bombard==1||head==1||triangle==1))
	    {
              fprintf(outfile,"\ntime display\n");
              fprintf(outfile,"------------\n");
              fprintf(outfile,"time / test\n");
            }
            else if ((prnflg == 3)&&(bombard==1||head==1||triangle==1))
	    {
              fprintf(outfile,"\ntime display\n");
              fprintf(outfile,"------------\n");
              fprintf(outfile,"time / run\n");
            }
            else if ((prnflg == 0)&&(bombard==1||head==1||triangle==1))
	    {
              fprintf(outfile,"\ntime display\n");
              fprintf(outfile,"------------\n");
              fprintf(outfile,"time display not selected\n");
            }

            fprintf(outfile,"\ninput file\n");
            fprintf(outfile,"----------\n");
            fprintf(outfile,"%s\n",argv[1]);
            fprintf(outfile,"\noutput file\n");
            fprintf(outfile,"-----------\n");
            if (strcmp(out,"") == 0)
              fprintf(outfile,"output file not given using stdout\n");
            else
              fprintf(outfile,"%s\n",out);

	    if (bombard == 1 || head == 1 || triangle == 1)
            {
              fprintf(outfile,"\nmessage parameters\n");
              fprintf(outfile,"------------------\n");     
              fprintf(outfile,"# of process for bombard test(s) : %d",nproc);
              if (strcmp(proc,"") == 0)
                fprintf(outfile,"   (not provided, using default)\n");
              else
                fprintf(outfile,"\n");
              fprintf(outfile,"# of message(s)                  : %d",nmess);
              if (strcmp(mess,"") == 0)
                fprintf(outfile,"   (not provided, using default)\n");
              else
                fprintf(outfile,"\n");
              fprintf(outfile,"size of message(s)               : %d",nsize);
              if (strcmp(smess,"") == 0)
                fprintf(outfile,"   (not provided, using default)\n");
              else
                fprintf(outfile,"\n");
            }

/* print user selected test(s) */

            fprintf(outfile,"\nselected tests\n");
            fprintf(outfile,"--------------\n");

            for(i = 1; i < NUMTESTS+1; i++)
	    {
              if (t[i].tflag == 1)
	      {
                fprintf(outfile,"%s\n",t[i].tfnct);
                none = 0;
              }
            }

/* section D end */


            if (none == 0) 
            {       
              fprintf(outfile,"\n\ntest outcome\n");
              fprintf(outfile,"------------\n");

/* section E (test execution) */


              /* loop through and determine which tests were selected
               by checking the t[i].tflag array */

	      for (i=1; i<(NUMTESTS+1); i++){

                  /* tests 8-79 require all machines in pool to be
                   added since tests 1-7 remove hosts upon completion */

		  if (i==8) {
		      j=8;
		      TEST_FLAG = 0;
		      while ((j<(NUMTESTS+1)) && (TEST_FLAG==0)) {
			  if (t[j].tflag == 1) {
                              repair();
			      infos = (int *)malloc(hostcnt*sizeof(int));

                              if (hostcnt > 0)
			        pvm_addhosts(hostpool, hostcnt, infos);
  
			      TEST_FLAG = 1;
			  }
			  j++;
		      }
		  }
		  if (t[i].tflag == 1) {
                      if (outfile == stdout && i < 10)
                        fprintf(outfile,"\ttest0%d: RUNNING\n",i);
                      else if (outfile == stdout && i >= 10)
                        fprintf(outfile,"\ttest%d: RUNNING\n",i);

		      if (i==1) { 
                          repair();
			  test01();
		      }
		      else if (i==2) {
                          repair();
			  test02();
		      }
		      else if (i==3) {
                          repair();
			  test03();
		      }
		      else if (i==4) {
                          repair();
			  test04();
		      }
		      else if (i==5) {
                          repair();
			  test05();
		      }
		      else if (i==6) {
                          repair();
			  test06();
		      }
		      else if (i==7) {
                          repair();
			  test07();
		      }
		      else if (i==8) {
			  test08();
		      }
		      else if (i==9) {
			  test09();
		      }
		      else if (i==10){
		  	  test10();
		      }
		      else if (i==11){
			  test11();
		      }
		      else if (i==12){
			  test12();
		      }
		      else if (i==13){
			  test13();
		      }
		      else if (i==14){
			  test14();
		      }
		      else if (i==15){
			  test15();
		      }
		      else if (i==16){
			  test16();
		      }
		      else if (i==17){
			  test17();
		      }
		      else if (i==18){
			  test18();
		      }
		      else if (i==19){
			  test19();
		      }
		      else if (i==20){
			  test20();
		      }
		      else if (i==21){
			  test21();
		      }
		      else if (i==22){
			  test22();
		      }
		      else if (i==23){
			  test23();
		      }
		      else if (i==24){
			  test24();
		      }
		      else if (i==25){
			  test25();
		      }
		      else if (i==26){
			  test26();
		      }
		      else if (i==27)
			  test27();
		      else if (i==28)
			  test28();  
                      else if (i==29)
                          test29(nproc);
                      else if (i==30)
		      {
                          test30(nproc);
		      }
                      else if (i==31)
                          test31(nproc);
                      else if (i > 31 && i < 80) { 
                          stat = msgtst(i, nproc, nmess, nsize, prnflg, &mtime,dtime);
			  if ((i >=32 && i <=39) || (i >=56 && i <=63) && 
                              stat >= 0)
			  {
			    nprn = nproc;
			    tstmod = 1;
			    if (prnflg == 3)
			    {
		 	      for(ii = 0 ; ii < nprn; ii++)
			        timtot1[ii] = timtot1[ii] + dtime[ii];
			    }
			  }
			  else if ((i >=40 && i <=47) || (i >=64 && i<=71) &&
                                   stat >= 0)
			  {
			    nprn = 1;
			    tstmod = 2;
			    if (prnflg == 3)
			    {
			      mtimtot2 = mtimtot2 + mtime;
		 	      for(ii = 0 ; ii < nprn; ii++)
			        timtot2[ii] = timtot2[ii] + dtime[ii];
			    }
			  }
			  else if (stat >= 0)
			  {
			    nprn = 2;
			    tstmod = 3;
			    if (prnflg == 3)
			    {
			      mtimtot3 = mtimtot3 + mtime;
		 	      for(ii = 0 ; ii < nprn; ii++)
			        timtot3[ii] = timtot3[ii] + dtime[ii];
			    }
			  }
		      } 


/* section E end */


                      if (outfile != stdout && i > 9)
                        printf("test%d : DONE\n",i);
		      else if (outfile != stdout)
                        printf("test0%d : DONE\n",i);
                      sleep(3);

	          }
		    
	      }
            }

            else
             fprintf(outfile,"none\n\n");

	  } 

          /* print out total message timing result */

          if (prnflg == 3) 
	  {
	    if (bombard == 1)
	    {
	      fprintf(outfile,"\n\nbombard message time total\n");
  	      fprintf(outfile,"--------------------------\n\n");
	      for (ii = 0; ii < nproc; ii++)
	       fprintf(outfile,"total message time for slave #%d = %f\n\n",ii,timtot1[ii]);
	    }
	    if (head == 1)
	    {
	      fprintf(outfile,"\n\nhead-head message time total\n");
  	      fprintf(outfile,"----------------------------\n\n");

	      fprintf(outfile,"total master message time       = %f\n\n",mtimtot2);
	      for (ii = 0; ii < 1; ii++)
	       fprintf(outfile,"total message time for slave #%d = %f\n\n",ii,timtot2[ii]);
	    }
	    if (triangle == 1)
	    {
	      fprintf(outfile,"\n\ntriangle message time total\n");
  	      fprintf(outfile,"---------------------------\n\n");

	      fprintf(outfile,"total master message time       = %f\n\n",mtimtot3);
	      for (ii = 0; ii < 2; ii++)
	       fprintf(outfile,"total message time for slave #%d = %f\n\n",ii,timtot3[ii]);
	    }
	}
	fclose(outfile);
        fclose(infile);
	pvm_halt();
        pvm_exit();
        exit(0);
}

#define DEL_TAG  10
#define ADD_TAG  11
#define BYE      12
#define JOINED   10
#define TESTMSG  11
#define RECVD    12
#define HOSTNO   13
#define CIRCLED  10
#define GRP_SIZE 12
#define GO_AWAY  14
#define BUF_TEST 15
#define PAR_TID  24
#define RESULT   25
#define MY_TEST  27
#define PAR_TEST 26
#define INITPASS  5
#define SLAVENAME "msgtst_sl"
#define VTST     17

/*
 * determine PVM versions on machines in pool
 */

char **version_tst(hostpool, hostcnt)
char **hostpool;
int   *hostcnt;
{
  char *args[2], **cver, *tmpver;
  int i, *tids, stat, err = 0, j = 0, tcnt, bufid, *infos;
  extern FILE *outfile;

  infos    = (int *)malloc(*hostcnt*sizeof(char *));
  tmpver   = (char *)malloc(50*sizeof(char));
  cver  = (char **)malloc(*hostcnt*sizeof(char *));
  tids  = (int *)malloc((*hostcnt+1)*sizeof(int));

  args[0] = "version_slv";
  args[1] = NULL;


  /* attempt to add the hosts in the configuration, if the hosts
     cannot be reached then inform the user and exit */


  for (i = 0; i < *hostcnt; i++)
  {
    stat = pvm_addhosts(hostpool+i, 1, infos);
    if (stat <= 0)
    {
      if (infos[0] == PvmCantStart)
        printf("\n*** Unable to start slave pvmd in %s ***\n",hostpool[i]);
      else
        printf("\n*** Unable to reach host in pool: %s ***\n",hostpool[i]);
       
      pvm_halt();
      pvm_exit();
      exit(0);
    }

  }

  tcnt = *hostcnt;

  for(i = 0; i < tcnt; i++)
  {

    /* ask every machine in pool to report the PVM version */

    stat = pvm_spawn("pvm_testslv", args, 1, hostpool[i],1, &tids[i]); 

    /* if the process cannot be spawned on any of the machine in the
       pool then inform the user and exit */

    if (stat <= 0)
    {
      printf("\n*** Bad or no Executable on %s ***\n",hostpool[i]);
      pvm_halt();
      pvm_exit();
      exit(0);
    }

    bufid = pvm_recv(-1, VTST);
    pvm_upkstr(tmpver);
    cver[i] = (char *)malloc(50*sizeof(char));
    strcpy(cver[i], tmpver);
    free(tmpver);
    tmpver   = (char *)malloc(50*sizeof(char));
  }

  /* clean up */

  free(tmpver);
  pvm_delhosts(hostpool, *hostcnt, infos);
  pvm_freebuf(bufid);

  /* return PVM version list */

  return(cver);

}  

/*
 * test for add ok
 */

test01(argc,argv)
int argc;
char **argv;
{
	int i, mytid, add_no;
	int *infos, *dinfos;
	extern FILE *outfile;
	extern char **hostpool;
	extern int hostcnt;
        int stat;

#if 0
	fprintf(outfile,"testing add ok\n");
#endif
	infos = (int *)malloc(hostcnt*sizeof(int));
	dinfos = (int *)malloc(hostcnt*sizeof(int));
	pvm_notify(PvmHostAdd, ADD_TAG, 1, NULL);
	stat = pvm_addhosts(hostpool, hostcnt, infos); 
        if (stat == hostcnt)
	{
	  pvm_recv(-1, ADD_TAG);
	  pvm_upkint(&add_no,1,1);
	  if (add_no == hostcnt)
	    fprintf(outfile,"\ttest01: OK\n"); 
	  else
	    fprintf(outfile,"\ttest01: FAILED\n");
	}
	else
	    fprintf(outfile,"\ttest01: FAILED\n");

	/* cleanup */

	pvm_delhosts(hostpool, hostcnt, dinfos);

}


/*
 * test for add fail
 */

test02(argc,argv)
int argc;
char **argv;
{
	int i, mytid, add_no, stat;
	int *infos, *dinfos, *infos2;
	extern FILE *outfile;
	extern int hostcnt;
	extern char **hostpool;

#if 0
	fprintf(outfile,"testing add fail\n");
#endif
	infos = (int *)malloc(hostcnt*sizeof(int));
	dinfos = (int *)malloc(hostcnt*sizeof(int));
	infos2 = (int *)malloc(hostcnt*sizeof(int));
	pvm_notify(PvmHostAdd, ADD_TAG, 1, NULL);
	stat = pvm_addhosts(hostpool, hostcnt, infos);

        if (stat == hostcnt)
	{
	  pvm_recv(-1, ADD_TAG);
	  pvm_upkint(&add_no,1,1);

	  if (add_no == hostcnt) {
              sleep(5);
	      pvm_addhosts(hostpool, hostcnt, infos2);
	      i = 0;
	      while (i<hostcnt) {
	          if (infos2[i] != PvmDupHost) {
	    	      fprintf(outfile,"\ttest02: FAILED\n");
		      break;
	          }
	          i++;
	      }
	      fprintf(outfile,"\ttest02: OK\n");
	  }
	  else
	      fprintf(outfile,"\ttest02: INCOMPLETE\n");

	}
        else
	    fprintf(outfile,"\ttest02: INCOMPLETE\n");

	/* cleanup */

	pvm_delhosts(hostpool, hostcnt, dinfos);
}


/*
 * test for del ok
 */

test03(argc,argv)
int argc;
char **argv;
{
	int i, mytid, add_no, bufid;
	int *infos, *dinfos, stat;
	extern FILE *outfile;
	extern char **hostpool;
	extern int hostcnt;
#if 0
	fprintf(outfile,"testing delete ok\n");
#endif

	infos = (int *)malloc(hostcnt*sizeof(int));
	dinfos = (int *)malloc(hostcnt*sizeof(int));
	pvm_notify(PvmHostAdd, ADD_TAG, 1, NULL);
	stat = pvm_addhosts(hostpool, hostcnt, infos);

        if (stat == hostcnt)
        { 
	  bufid = pvm_recv(-1, ADD_TAG);
	  pvm_upkint(&add_no,1,1);
	  if (add_no == hostcnt) {
	      pvm_delhosts(hostpool, hostcnt, dinfos);
	      i=0;
	      while (i<hostcnt) {
		  if (dinfos[i] != 0) {
		      fprintf(outfile, "\ttest03: FAILED\n");
		      break;
		  }
		  i++;
	      }
	      fprintf(outfile, "\ttest03: OK\n"); 
	  }
	  else
	      fprintf(outfile, "\ttest03: INCOMPLETE\n");

        }
        else
	   fprintf(outfile, "\ttest03: INCOMPLETE\n");

        pvm_freebuf(bufid);
}
 

/*
 * test for del fail
 */

test04(argc,argv)
int argc;
char **argv;
{
	int i, mytid, add_no, nhost, narch;
	int *infos, *dinfos, *dinfos2, stat;
	struct hostinfo *hostp;
	extern FILE *outfile;
	extern char **hostpool;
	extern int hostcnt;
#if 0
	fprintf(outfile,"testing delete ok\n");
#endif

	infos = (int *)malloc(hostcnt*sizeof(int));
	dinfos = (int *)malloc(hostcnt*sizeof(int));
	dinfos2 = (int *)malloc(hostcnt*sizeof(int));
	pvm_notify(PvmHostAdd, ADD_TAG, 1, NULL);
	stat = pvm_addhosts(hostpool, hostcnt, infos);

        if (stat == hostcnt)
	{
	  pvm_recv(-1, ADD_TAG);
	  pvm_upkint(&add_no,1,1);
        }
        else
	  add_no = -1; 

	if (add_no == hostcnt) {
	    pvm_delhosts(hostpool, hostcnt, dinfos);
	    i=0;
	    while (i<hostcnt) {
		if (dinfos[i] != 0) {
		    fprintf(outfile, "\ttest04: INCOMPLETE\n");
		    break;
		}
		i++;
	    }
	    pvm_config(&nhost, &narch, &hostp);
	    while (nhost != 1) {
	       sleep(2);
	       pvm_config(&nhost, &narch, &hostp);
	    }
	    pvm_delhosts(hostpool, hostcnt, dinfos2);
	    i=0;
	    while (i<hostcnt) {
		if (dinfos2[i] >= 0) {
		    fprintf(outfile, "\ttest04: FAILED\n");
		    break;
		}
		i++;
	    }
	    fprintf(outfile, "\ttest04: OK\n");
	}
	else
	    fprintf(outfile, "\ttest04: INCOMPLETE\n");
}


/*
 * test for add-delete ok
 */

test05(argc,argv)
int argc;
char **argv;
{
	int i, mytid, add_no, stat;
	int *infos, *dinfos;
	extern FILE *outfile;
	extern char **hostpool;
	extern int hostcnt;
#if 0
	fprintf(outfile,"testing add-delete ok\n");
#endif

	infos = (int *)malloc(hostcnt*sizeof(int));
	dinfos = (int *)malloc(hostcnt*sizeof(int));
	pvm_notify(PvmHostAdd, ADD_TAG, 1, NULL);
	stat = pvm_addhosts(hostpool, hostcnt, infos);
  
        if (stat == hostcnt)
	{
	  pvm_recv(-1, ADD_TAG);
	  pvm_upkint(&add_no,1,1);
        }
        else
          add_no = -1;

	if (add_no == hostcnt) {
	    pvm_delhosts(hostpool, hostcnt, dinfos);
	    i=0;
	    while (i<hostcnt) {
		if (dinfos[i] != 0) {
		    fprintf(outfile, "\ttest05: FAILED\n");
		    break;
		}
		i++;
	    }
	    fprintf(outfile, "\ttest05: OK\n");
	}
	else
	    fprintf(outfile, "\ttest05: INCOMPLETE\n");
}


/*
 * test for add-config race
 */

test06(argc,argv)
int argc;
char **argv;
{
	int i, nhost, narch, mytid, add_no, stat;
	struct hostinfo *hostp;
	int *infos, *dinfos;
	extern FILE *outfile;
	extern char **hostpool;
	extern int hostcnt;

#if 0
	fprintf(outfile,"testing add-config race\n");
#endif

	infos = (int *)malloc(hostcnt*sizeof(int));
	dinfos = (int *)malloc(hostcnt*sizeof(int));
	pvm_notify(PvmHostAdd, ADD_TAG, 1, NULL);
	stat = pvm_addhosts(hostpool, hostcnt, infos);
	pvm_config(&nhost, &narch, &hostp);
        
        if (stat == hostcnt)
	{
	  pvm_recv(-1, ADD_TAG);
	  pvm_upkint(&add_no,1,1);
	  if (nhost == (add_no+1)) 
	    fprintf(outfile,"\ttest06: OK\n");
	  else
	    fprintf(outfile,"\ttest06: FAILED\n");
        }
        else
	    fprintf(outfile,"\ttest06: INCOMPLETE\n");

	pvm_delhosts(hostpool, hostcnt, dinfos);
}


/*
 * test for del-config race
 */

test07(argc,argv)
int argc;
char **argv;
{
	int i, nhost, narch, mytid, add_no, stat;
	struct hostinfo *hostp;
	int *infos, *dinfos;
	extern FILE *outfile;
	extern char **hostpool;
	extern int hostcnt;

#if 0
	fprintf(outfile,"testing delete-config race\n");
#endif

	infos = (int *)malloc(hostcnt*sizeof(int));
	dinfos = (int *)malloc(hostcnt*sizeof(int));
	pvm_notify(PvmHostAdd, ADD_TAG, 1, NULL);
	stat = pvm_addhosts(hostpool, hostcnt, infos);

        if (stat == hostcnt)
	{
	  pvm_recv(-1, ADD_TAG);
	  pvm_upkint(&add_no,1,1);
        }
        else
          add_no = -1;

	if (add_no == hostcnt) {
	    pvm_delhosts(hostpool, hostcnt, dinfos);
            sleep(SNOOZ);
	    pvm_config(&nhost, &narch, &hostp);
	    if (nhost == 1)
		fprintf(outfile,"\ttest07: OK\n");
	    else
		fprintf(outfile,"\ttest07: FAILED\n");
	}
	else
	    fprintf(outfile, "\ttest07: INCOMPLETE\n");
}


/* 
 * test to make sure multiple group servers are not started
 */

test08(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int gstid;
	int i;
	int nhost;
	int narch;
	int ntask;
	int ngs=0;
	int *tids;
	char *args[2];
	struct hostinfo *hostp;
	struct taskinfo *taskp;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test8: testing for multiple group servers\n");
#endif

	/* setup */

	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test08";
	args[1] = 0;
	tids = (int *)malloc((nhost)*sizeof(int));
	for (i=0; i<nhost; i++)
	    pvm_spawn("pvm_testslv", args, 1, hostp[i].hi_name, 1, &tids[i]);

	/* test */

	for (i=0;i<nhost;i++)
	    pvm_recv(-1, JOINED);
	sleep(2);

	pvm_tasks(0, &ntask, &taskp);
	for (i=0; i<ntask; i++) {
	    if (strcmp(taskp[i].ti_a_out,"pvmgs") == 0) {
		ngs++;
		gstid = taskp[i].ti_tid;
	    }
	}
	if (ngs == 1) { 
	    fprintf(outfile,"\ttest08: OK\n");
	}
	else if (ngs == 0) {
	    fprintf(outfile,"\ttest08: FAILED\n");
	}
	else {
	    fprintf(outfile,"\ttest08: FAILED\n");
	}
	pvm_initsend(0);
	pvm_mcast(tids, nhost, BYE);
}


/* 
 * testing for joingroup() fail
 */

test09(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int inum1; 
	int inum2;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test9: testing for PvmDupGroup error\n");
#endif

	/* test */

	inum1 = pvm_joingroup("testgrp9");
	inum2 = pvm_joingroup("testgrp9");
	if (inum2 != PvmDupGroup)
	    fprintf(outfile,"\ttest09: FAILED\n");
	else
	    fprintf(outfile,"\ttest09: OK\n");

}


/* 
 * testing for lvgroup() fail
 */

test10(argc,argv)
int argc;
char **argv;
{
	int i;
	int mytid;
	int *tids;
	int inum1;
	int info;
	int info2;
	int nhost;
	int narch;
	int ntask;
	char *args[2];
	struct hostinfo *hostp;
	struct taskinfo *taskp;
	extern FILE *outfile;
#if 0
	fprintf(outfile,"test10: testing for PvmNotInGroup error\n");
#endif

	/* setup */

	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test10";
	args[1] = 0;
	tids = (int *)malloc(nhost*sizeof(int));
	inum1 = pvm_joingroup("testgrp10");

	for (i=0; i<nhost; i++)
	    pvm_spawn("pvm_testslv", args, 1, hostp[i].hi_name, 1, &tids[i]);

	for (i=0; i<nhost; i++) 
	    pvm_recv(-1, JOINED);

	/* test */

	info = pvm_lvgroup("testgrp10");
	info2 = pvm_lvgroup("testgrp10");
	if (info2 != PvmNotInGroup)
	    fprintf(outfile,"\ttest10: FAILED\n");
	else
	    fprintf(outfile,"\ttest10: OK\n");

	/* cleanup */

	pvm_initsend(0);
	pvm_mcast(tids, nhost, BYE);
}


/* 
 * testing for joingroup() succeed
 */

test11(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int inum;
	int size;
	int gtid;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test11: testing for joingroup success\n");
#endif
	mytid = pvm_mytid();

	/* test */

	inum = pvm_joingroup("testgrp11");
	size = pvm_gsize("testgrp11");
	if (size == 1) {
	    if ((gtid = pvm_gettid("testgrp11",0)) == mytid) {
		fprintf(outfile,"\ttest11: OK\n");
	    }
	}
	else
	    fprintf(outfile,"\ttest11: FAILED\n");

	/* cleanup */

	pvm_lvgroup("testgrp11");
}


/* 
 * testing for lvgroup() succeed
 */

test12(argc,argv)
int argc;
char **argv;
{
	int inum;
	int info;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test12: testing lvgroup function\n");
#endif

	/* test */

	inum = pvm_joingroup("testgrp12");
	if (inum >= 0) {
	    info = pvm_lvgroup("testgrp12");
	    if (info == 0)
		fprintf(outfile,"\ttest12: OK\n"); 
	    else
		fprintf(outfile,"\ttest12: FAILED\n");
	}
	else
	    fprintf(outfile,"\ttest12: INCOMPLETE\n");

	/* cleanup */

}


/* 
 * testing for group to go away after last task is gone
 */

test13(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int inum;
	int info;
	int info2;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test13: testing for group deletion\n");
#endif

	/* test */

	inum = pvm_joingroup("testgrp13");
	info = pvm_lvgroup("testgrp13");
        if (info == 0) {
	    info2 = pvm_lvgroup("testgrp13");
	    if (info2 == PvmNoGroup)
		fprintf(outfile,"\ttest13: OK\n");
	    else
		fprintf(outfile,"\ttest13: FAILED\n");
	}
	else
	    fprintf(outfile,"test13: INCOMPLETE\n");

}


/* 
 * testing for illegal NULL group name 
 */

test14(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int inum;
	int i;
	int ntask;
	struct taskinfo *taskp;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test14: testing for illegal NULL group name\n");
#endif

	/* test */

	inum = pvm_joingroup((char *)0);
        if (inum == PvmNullGroup) 
	    fprintf(outfile,"\ttest14: OK\n");
	else
	    fprintf(outfile,"\ttest14: FAILED\n");

}


/* 
 * testing group bcast
 */

test15(argc,argv)
int argc;
char **argv;
{
	int inum;
	int i;
	int narch;
	int nhost;
	int *tids;
	char *args[2];
	struct hostinfo *hostp;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test15: testing group bcast\n");
#endif

	pvm_config(&nhost, &narch, &hostp);

	/* test */

	inum = pvm_joingroup("testgrp15");
	args[0] = "test15";
	args[1] = 0;
	tids = (int *)malloc(nhost*sizeof(int));
	for (i=0; i<nhost; i++)
	    pvm_spawn("pvm_testslv", args, 1, hostp[i].hi_name, 1, &tids[i]);
	for (i=0; i<nhost; i++)
	    if (tids[i] >= 0)
	        pvm_recv(-1, JOINED);
	pvm_initsend(0);
	pvm_bcast("testgrp15", TESTMSG);
	for (i=0; i<nhost; i++)
	    if (tids[i] >= 0)
	        pvm_recv(-1, RECVD);
	fprintf(outfile,"\ttest15: OK\n");

}


/* 
 * testing group barriers
 */

test16(argc,argv)
int argc;
char **argv;
{
	int inum;
	int info;
	int i;
	int narch;
	int nhost;
	int *tids;
	char *args[2];
	struct hostinfo *hostp;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test16: testing group barriers\n");
#endif

	pvm_config(&nhost, &narch, &hostp);

	/* test */

	inum = pvm_joingroup("testgrp16");
	args[0] = "test16";
	args[1] = 0;
	tids = (int *)malloc(nhost*sizeof(int));
	for (i=0; i<nhost; i++)
	    pvm_spawn("pvm_testslv", args, 1, hostp[i].hi_name, 1, &tids[i]);
	pvm_initsend(0);
	pvm_pkint(&nhost,1,1);
	for (i=0; i<nhost; i++)
	    pvm_send(tids[i], HOSTNO);
	info = pvm_barrier("testgrp16", nhost+1);
	if (info == 0)
	    fprintf(outfile,"\ttest16: OK\n");
	else
	    fprintf(outfile,"\ttest16: FAILED\n");

}


/* 
 * testing group pvm_getinst() and pvm_gettid()
 */

test17(argc,argv)
int argc;
char **argv;
{
	int inum;
	int info;
	int i;
	int narch;
	int nhost;
	int *tids;
	char *args[2];
	struct hostinfo *hostp;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test17: testing getinst and gettid\n");
#endif

	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test17";
	args[1] = 0;
	tids = (int *)malloc(nhost*sizeof(int));
	for (i=0; i<nhost; i++)
	    pvm_spawn("pvm_testslv", args, 1, hostp[i].hi_name, 1, &tids[i]);

	/* test */

	pvm_initsend(0);
	pvm_pkint(&nhost,1,1);
	pvm_mcast(tids, nhost, GRP_SIZE);
	pvm_recv(-1, CIRCLED);
	fprintf(outfile,"\ttest17: OK\n");

}


/* 
 * testing PvmNotInGroup
 */

test18(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int inum;
	int info;
	int i;
	int narch;
	int nhost;
	int *tids;
	char *args[2];
	struct hostinfo *hostp;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test18: testing for PvmNotInGroup and PvmNoInst\n");
#endif

	mytid = pvm_mytid();
	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test18";
	args[1] = 0;
	tids = (int *)malloc(nhost*sizeof(int));
	for (i=0; i<nhost; i++)
	    pvm_spawn("pvm_testslv", args, 1, hostp[i].hi_name, 1, &tids[i]);

	/* test */

	for (i=0; i<nhost; i++)
	    pvm_recv(-1, JOINED);

	info = pvm_getinst("testgrp18", mytid);
	if (info == PvmNotInGroup)
	    fprintf(outfile,"\ttest18: OK\n");
	else
	    fprintf(outfile,"\ttest18: FAILED\n");

	/* cleanup */

	pvm_initsend(0);
	pvm_mcast(tids, nhost, BYE);

}


/* 
 * testing PvmNoInst
 */

test19(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int inum;
	int info;
	int i;
	int narch;
	int nhost;
	int *tids;
	char *args[2];
	struct hostinfo *hostp;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test19: testing for PvmNotInGroup and PvmNoInst\n");
#endif

	mytid = pvm_mytid();
	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test19";
	args[1] = 0;
	tids = (int *)malloc(nhost*sizeof(int));
	for (i=0; i<nhost; i++)
	    pvm_spawn("pvm_testslv", args, 1, hostp[i].hi_name, 1, &tids[i]);

	/* test */

	for (i=0; i<nhost; i++)
	    pvm_recv(-1, JOINED);

	info = pvm_gettid("testgrp19", 257);
	if (info == PvmNoInst)
	    fprintf(outfile,"\ttest19: OK\n");
	else
	    fprintf(outfile,"\ttest19: FAILED\n");

	/* cleanup */

	pvm_initsend(0);
	pvm_mcast(tids, nhost, BYE);

}


/* 
 * testing getsbuf
 */

test20(argc,argv)
int argc;
char **argv;
{
	int bufid;
	int bufid2;
	extern FILE *outfile;


#if 0
	fprintf(outfile,"test20: testing getsbuf\n");
#endif

	/* test */

	bufid = pvm_initsend(0);
	bufid2 = pvm_getsbuf();
	if (bufid == bufid2)
	    fprintf(outfile,"\ttest20: OK\n");
	else
	    fprintf(outfile,"\ttest20: FAILED\n");

	pvm_freebuf(bufid);

}

/* 
 * testing getsbuf for no current buffer
 */

test21(argc,argv)
int argc;
char **argv;
{
	int bufid;
	extern FILE *outfile;


#if 0
	fprintf(outfile,"test21: testing getsbuf for no current buffer\n");
#endif

	/* test */

	bufid = pvm_getsbuf();
	if (bufid == 0)
	    fprintf(outfile,"\ttest21: OK\n");
	else
	    fprintf(outfile,"\ttest21: FAILED\n");

}


#define BUF_TEST 15


/* 
 * testing getrbuf
 */

test22(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int nhost;
	int narch;
	struct hostinfo *hostp;
	int tids;
	int bufid;
	int bufid2;
	int i;
	char *args[2];
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test22: testing getrbuf\n");
	fflush(outfile);
#endif
	mytid = pvm_mytid();

	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test22";
	args[1] = 0;
	pvm_spawn("pvm_testslv", args, 1, hostp[0].hi_name, 1, &tids);

	/* test */

	bufid = pvm_recv(-1, BUF_TEST);
	bufid2 = pvm_getrbuf();
	if (bufid == bufid2)
	    fprintf(outfile,"\ttest22: OK\n");
	else
	    fprintf(outfile,"\ttest22: FAILED\n");

	/* cleanup */

	pvm_freebuf(bufid);

}


/* 
 * testing getrbuf with no current receive buffer
 */

test23(argc,argv)
int argc;
char **argv;
{
	int nhost;
	int narch;
	struct hostinfo *hostp;
	int tids;
	int bufid;
	int bufid2;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test23: testing getrbuf with no current receive buffer\n");
#endif
	/* test */

	bufid = pvm_getrbuf();
	if (bufid == 0)
	    fprintf(outfile,"\ttest23: OK\n");
	else
	    fprintf(outfile,"\ttest23: FAILED\n");


}


/* 
 * testing the use of setsbuf instead of initsend
 */

test24(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int nhost;
	int narch;
	struct hostinfo *hostp;
	int tids;
	int bufid;
	int bufid2;
	int i;
	int answer;
	int info;
	char *args[2];
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test24: testing the use of setsbuf instead of initsend\n");
#endif

	mytid = pvm_mytid();
	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test24";
	args[1] = 0;
	pvm_spawn("pvm_testslv", args, 1, hostp[0].hi_name, 1, &tids);

	/* test */

	bufid = pvm_mkbuf(0);
	bufid = pvm_setsbuf(bufid);
	pvm_pkint(&mytid,1,1);
	if (info = pvm_send(tids,PAR_TID) < 0)
	    fprintf(outfile,"\ttest24: FAILED\n");
	else {
	    pvm_recv(-1,RESULT);
	    pvm_upkint(&answer,1,1);
	    if (answer == 1)
		fprintf(outfile,"\ttest24: OK\n");
	    else
		fprintf(outfile,"\ttest24: FAILED\n");
	}

}


#define PAR_TEST 26


/* 
 * testing setrbuf
 */

test25(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int tmytid;
	int tparent;
	int nhost;
	int narch;
	struct hostinfo *hostp;
	int tids;
	int mybufid;
	int info;
	char *args[2];
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test25: testing setrbuf\n");
#endif

	mytid = pvm_mytid();
	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test25";
	args[1] = 0;
	pvm_spawn("pvm_testslv", args, 1, hostp[0].hi_name, 1, &tids);

	/* test */

	pvm_recv(-1, MY_TEST);
	mybufid = pvm_setrbuf(0);
	pvm_recv(-1, PAR_TEST);
	info = pvm_upkint(&tparent,1,1);
	if (tparent != mytid)
	    fprintf(outfile,"\ttest25: FAILED\n");
	else {
	    pvm_setrbuf(mybufid);
	    info = pvm_upkint(&tmytid,1,1);
	    if (tmytid == tids)
		fprintf(outfile,"\ttest25: OK\n");
	    else
		fprintf(outfile,"\ttest25: FAILED\n");
	}
}


/* 
 * testing setrbuf
 */

test26(argc,argv)
int argc;
char **argv;
{
	int mytid;
	int bufid;
	int bufid2;
	extern FILE *outfile;

#if 0
	fprintf(outfile,"test26: testing setrbuf\n");
#endif

	mytid = pvm_mytid();

	/* test */

	bufid = pvm_mkbuf(0);
	pvm_setsbuf(bufid);
	pvm_freebuf(bufid);
	bufid2 = pvm_getsbuf();
	if (bufid2 == 0)
	    fprintf(outfile,"\ttest26: OK\n");
	else
	    fprintf(outfile,"\ttest26: FAILED\n");

}


/* testing pvm_tidtohost */

test27(argc, argv)
int argc;
char **argv;
{
	int mytid;
	int pvmdtid, pvmdtid2;
	int nhost;
	int narch;
	struct hostinfo *hostp;
	extern FILE *outfile;

	mytid = pvm_mytid();

	pvm_config(&nhost, &narch, &hostp);
	pvmdtid = hostp[0].hi_tid;
	pvmdtid2 = pvm_tidtohost(mytid);
	if (pvmdtid2 == pvmdtid)
	    fprintf(outfile, "\ttest27: OK\n");
	else
	    fprintf(outfile, "\ttest27: FAILED\n");

}


/* pvm_sendsig() ok */

test28(argc, argv)
int argc;
char **argv;
{
	int mytid;
	int tid;
	int info;
	int nhost, narch;
	int ntask;
	char *args[2];
	struct taskinfo *taskp;
	struct hostinfo *hostp;
	extern FILE *outfile;
	int i;
	int flag = 0;

	mytid = pvm_mytid();

	pvm_config(&nhost, &narch, &hostp);
	args[0] = "test28";
	args[1] = 0;
	pvm_spawn("pvm_testslv", args, 1, hostp[0].hi_name, 1, &tid);
	pvm_sendsig(tid, SIGKILL);
	sleep(5);
	pvm_tasks(0, &ntask, &taskp);
	for (i=0; i<ntask; i++) {
	    if (taskp[i].ti_tid == tid)
		flag = 1;
	}
	if (flag==0)
	    fprintf(outfile, "\ttest28: OK\n");
	else
	    fprintf(outfile, "\ttest28: FAILED\n");
}


/* spawn many tasks */

void test29(nproc)
int nproc;
{

  char *args[2];
  extern FILE *outfile;
  int i, *tids, stat, err = 0;


  tids = (int*)malloc(nproc*sizeof(int));

  args[0] = "test29";
  args[1] = 0;

  err = pvm_spawn("pvm_testslv", args, 0, "",nproc, tids);

  if (err == nproc)
    fprintf(outfile,"\ttest29: OK\n");
  else
    fprintf(outfile,"\ttest29: FAILED\n");

  sleep(5);
}


/* spawn continuously */

void test30(nproc)
int nproc;
{

  char *args[2];
  int i, *tids, stat, err = 0, ert = 0;
  extern FILE *outfile;

  tids = (int*)malloc(nproc*sizeof(int));

  args[0] = "test29";
  args[1] = 0;
  for(i = 0; i < nproc; i++)
  {
    ert = pvm_spawn("pvm_testslv", args, 0, "",1, tids+i);
    err = err + ert;
  }
  
  if (err == nproc)
    fprintf(outfile,"\ttest30: OK\n");
  else
    fprintf(outfile,"\ttest30: FAILED\n");

  sleep(5);

}


void test31(nproc)
int nproc;
{

  char *args[2];
  int i, *tids, stat, err = 0;
  extern FILE *outfile;

  tids = (int*)malloc(nproc*sizeof(int));

  args[0] = "test29";
  args[1] = 0;
  pvm_spawn("pvm_testslv", args, 0, "",nproc, tids);

  sleep(3);

  for(i = 0; i < nproc; i++)
    pvm_kill( tids[i] );
    
  sleep(3);

  for(i = 0; i < nproc; i++)
  {
    stat = pvm_pstat(tids[i]);
    if (stat != PvmNoTask) err = 1;
  }  

  
  if (err == 0)
    fprintf(outfile,"\ttest31: OK\n");
  else
    fprintf(outfile,"\ttest31: FAILED\n");


  for(i = 0; i < nproc; i++)
    pvm_kill(tids[i]);

}



int msgtst(choice, nproc, n, size, prnflg, sndtim, ttime)

int choice, nproc, n, size, prnflg;
float *sndtim, *ttime;

{
    int mytid;                       /* my task id     */
    int *tids;                       /* slave task ids */
    int i, j, who, msgtype,k,code,err=0,mess;
    int *intres, broad, nhost, narch, stat, crccnt_sl = 0, errcnt_sl = 0;
    int fltsiz, intsiz, dblsiz, lngsiz, shtsiz, bytsiz, cpxsiz;
    int dcxsiz, strsiz,sum,crcc[12],crcr[12],crcerr,crccnt=0,cnt=0, screen;
    int direct,tstmod, oldval, bufid, bytes, source,info;
    int uinsiz, ushsiz, ulnsiz,gsize,gtid,arrive,l;
    unsigned int *uinres;
    float *fltres, *cpxres, avgtim;
    double *dblres,*dcxres;
    float sec, usec,mega=1000000.0,usecnum;
    char strres[12], pack[3], *bytres, *buf, loc[256];
    char packer[10],tmp[500], *args[2];
    long *lngres;
    unsigned long *ulnres;
    short *shtres;
    unsigned short *ushres;
    struct hostinfo *hostp;
    struct timeval etime[2], stime[2];
    extern FILE *outfile;
    FILE *dfp;

    *sndtim = 0.0;

    /* enroll in pvm */

    strcpy(packer,"MASTER");

    mytid = pvm_mytid();
    if (mytid < 0)
    {
      strcpy(loc, "ERROR ENROLLING IN PVM (MASTER)");
      pvm_perror( loc );
    }
              
    /* turn on auto error messaging */

    stat = pvm_setopt(PvmAutoErr, 1);

    if (stat < 0)
    {
      strcpy(loc, "ERROR TURNING ON ERROR MESSAGING (MASTER)");
      pvm_perror( loc );
    }

    /* determine type of test to run */

    stat = test_select( &tstmod, &code, &direct, &broad, pack, choice );
    if (stat < 0)
    {
      fprintf(outfile,"\ttest%d: (cannot execute test with mpp architecture)\n\n",choice);      
      return(-1);
    }

    /* cannot perform non XDR coding test if # of architecture is >1 */

    stat = pvm_config(&nhost, &narch, &hostp);
    if (stat < 0)
    {
      sprintf(loc,"ERROR OBTAINING CURRENT PVM SYSTEM INFO (MASTER)");
      pvm_perror(loc);
    }
    else if (code == PvmDataRaw && narch > 1)
    {
      fprintf(outfile,"\ttest%d: # of architecture > 1 cannot perform\n",
                      choice);
      fprintf(outfile,"\t        non XDR coding test\n\n");
      return(-1);
    }

    /* allow user to select the number of processes only if bombardment test
       is selected */

    if (tstmod == 2)
      nproc = 1;
    else if (tstmod == 3)
      nproc = 2;

    /* set appropriate routing option based on user input */

    if (direct == 1)
    {
      stat = pvm_setopt(PvmRoute, PvmDontRoute);
      if (stat < 0)
      {
        strcpy(loc, "ERROR SELECTING DAEMON ROUTING (MASTER)");
        pvm_perror( loc );
      }

    }
    else
    {
      stat = pvm_setopt(PvmRoute, PvmRouteDirect);
      if (stat < 0)
      {
        strcpy(loc, "ERROR SELECTING DIRECT ROUTING (MASTER)");
        pvm_perror( loc );
      }

    }

    /* allocate space for task id */

    tids = (int*)malloc(nproc*sizeof(int));

    args[0] = "msgslv";
    args[1] = 0;
    /* spawn appropriate number of slave processes */

    stat = pvm_spawn("pvm_testslv", args, 0, "", nproc, tids);
    if (stat < 0)
    {
      err = 9999;
      sprintf(loc, "ERROR SPAWNING SLAVE PROCESSES (MASTER)");      
      fprintf(outfile,"\ttest%d: FAILED\n",choice);
      return(-1);
    }

    /* check to make sure all spawned tasks are started */

    for(l = 0; l < nproc; l++)
    {
      stat = pvm_pstat(*(tids + l));
      if (stat < 0)
      {
        sprintf(loc,"ERROR SPAWNING TASK ERROR (MASTER): %d",
                *(tids + l));
        pvm_perror( loc );
        fprintf(outfile,"\ttest%d: FAILED\n",choice);
        return(-1);
      }
    } 

    /* create a group for the head-head messaging */

    if (tstmod == 2)
    {
      stat = pvm_joingroup( "head" );
      if (stat < 0)
      {
        sprintf(loc,"ERROR PROCESS UNABLE TO JOIN GROUP (MASTER)");
        pvm_perror( loc );
      }

    }

    /* create a group for the triangle messaging */

    else if (tstmod == 3)
    {
      stat = pvm_joingroup( "triangle" );
      if (stat < 0)
      {
        sprintf(loc,"ERROR PROCESS UNABLE TO JOIN GROUP (MASTER)");
        pvm_perror( loc );
      }
    }


    /* pack initial data bound for slave tasks */

    
    bufid = pvm_mkbuf( code );
    if (bufid < 0)
    {
      strcpy(loc, "ERROR MAKING SEND BUFFER FOR INIT DATA (MASTER)");
      pvm_perror( loc );
    }

    stat = pvm_setsbuf( bufid );
    if (stat < 0)
    {
      sprintf(loc,"ERROR INDICATING SEND BUFFER (MASTER)");
      pvm_perror( loc );
    }

    /* pack init data for slave processes */

    msgtype = 0;

    packdat(size, 0, fltres, intres, dblres, lngres, shtres,
            bytres, cpxres, dcxres, strres, uinres, ushres, ulnres,code, 
            nproc, n, i, sum, crcc, pack, broad, direct, tids, tstmod, 
            msgtype, packer);


    /* multi-cast data to all slave tasks */

    stat = pvm_mcast(tids, nproc, 0);
    if (stat < 0)
    {
      strcpy(loc, "ERROR BROADCASTING INIT DATA (MASTER)");
      pvm_perror( loc );
    }

    /* clear send buffer */ 

    info = pvm_getsbuf();
    if (info < 0)
    {
      strcpy(loc, "ERROR GETTING SEND BUFFER ID FOR INIT DATA (MASTER)");
      pvm_perror( loc );
    }

    stat = pvm_freebuf( info );    
    if (stat < 0)
    {
      strcpy(loc, "ERROR CLEARING SEND BUFFER FOR INIT DATA (MASTER)");
      pvm_perror( loc );
    }

    /* allocate space for timing variable */  
  
    /* ttime  = (float*)malloc(nproc*sizeof(float)); */

    /* allocate space for message arrays if message is not zero length */

    if (*pack == 'y' || *pack == 'Y')
    {

      fltres = (float*)malloc(fltsiz=size*sizeof(float));    
      intres = (int*)malloc(intsiz=size*sizeof(int)); 
      dblres = (double*)malloc(dblsiz=size*sizeof(double)); 
      lngres = (long*)malloc(lngsiz=size*sizeof(long));
      shtres = (short*)malloc(shtsiz=size*sizeof(short));
      bytres = (char*)malloc(bytsiz=size*sizeof(char)+5);
      cpxres = (float*)malloc(cpxsiz=2*size*sizeof(float)); 
      dcxres = (double*)malloc(dcxsiz=2*size*sizeof(double));
      uinres = (unsigned int *)malloc(uinsiz=2*size*sizeof(unsigned int));
      ushres = (unsigned short *)malloc(ushsiz=2*size*sizeof(unsigned short));
      ulnres = (unsigned long *)malloc(ulnsiz=2*size*sizeof(unsigned long)); 

      strsiz = sizeof(strres);   

      /* estimate size of buffer needed for transfer */

      sum = 2*size*strsiz+n;

      /* create buffer needed for CRC calculation */

      buf = (char *)malloc(sum);

    }
    /* although 2 processes are spawned for triangle messaging the parent only
       receive message from one */

    if (tstmod == 3) nproc = 1;

    for( j=0 ; j<nproc ; j++ )
    {
      for( i=0 ; i<n ; i++ )
      {
        bufid = pvm_initsend( code );
        if (bufid < 0)
        {
          sprintf(loc,"ERROR PREPARING BUFFER FOR MESSAGE (MASTER)");
          pvm_perror( loc );
        }
  
        msgtype = 5;        

        if (tstmod != 1)
	{
          if (*pack == 'y' || *pack == 'Y')
	  {

            /* for head to head and triangle messaging the parent is 
               responsible for creating the data */

            gen(0, size, i, fltres, intres, dblres, lngres, shtres, 
                bytres, cpxres, dcxres, strres, uinres, ushres, ulnres);

            /* pack the data for transfer and calculate the CRC of the
               data stream */

            packdat(size, 0, fltres, intres, dblres, lngres, shtres,
                    bytres, cpxres, dcxres, strres, uinres, ushres, ulnres,
                    code, nproc, n, i, sum, crcc, pack, broad, direct, 
                    tids, tstmod, msgtype, packer);


          }
          
          /* broadcast message by selected method and keep track of time 
             spent in sending the message */

          if (broad == 1)
          {

            gettimeofday(stime,NULL);
            stat = pvm_send( tids[0], msgtype );      
            gettimeofday(etime,NULL);

            if (stat < 0)
            {
              sprintf(loc, "ERROR SENDING MESSAGE # %d (MASTER)",i);
              pvm_perror( loc );
            }

          }
          else
	  {

            gettimeofday(stime,NULL);
            stat = pvm_mcast( tids, 1, msgtype );
            gettimeofday(etime,NULL);
            if (stat < 0)
	    {
              sprintf(loc, "ERROR MCASTING MESSAGE # %d (MASTER)",i);
              pvm_perror( loc );
            }


          }


          /* time returned is in micro second so divide by 1.0e6 */

          sec    = (float)abs(etime[0].tv_sec - stime[0].tv_sec);
          usec   = (float)abs(etime[0].tv_usec - stime[0].tv_usec);
          usec   = usec / mega; 

          *sndtim = *sndtim + ( sec + usec );

        }
  
        /* wait for slave task to send message */

        bufid = pvm_recv( -1, -1 );
        if (bufid < 0)
	{
          sprintf(loc,"ERROR RECEIVING MESSAGE (MASTER)");
          pvm_perror( loc );
        }  

        stat = pvm_bufinfo( bufid, &bytes, &msgtype, &source );
        if (stat < 0)
	{
          sprintf(loc,"ERROR GETTING BUFFER INFO (MASTER)");
          pvm_perror( loc );
        }

        stat = pvm_setrbuf( bufid );
        if (stat < 0)
	{
          sprintf(loc,"ERROR SETTING RECEIVE BUFFER FOR MESSAGE (MASTER)");
          pvm_perror( loc );
        }

        /* if message is not zero length then unpack data when it arrives */

        if (*pack == 'y' || *pack == 'Y')
	{

          msgtype = 5;
          unpackdat( &size, &who, &mess, crcr, intres, fltres, dblres, strres,
                     lngres, shtres, bytres, cpxres, dcxres, uinres, ushres,
                     ulnres, &nproc, pack, &broad, &code, &direct, tids, 
                     &n, &tstmod, msgtype, packer);

          /* determine if there was an error by comparing receive data
             matched expected data */

          for( k=0 ; k<size ; k++)
            error(fltres, intres, dblres, strres, lngres, shtres, bytres, 
                  cpxres, dcxres, uinres, ushres, ulnres, who,mess, k, &err);


            /* load a buffer with values of each component of message
               and determine crc value for each component of message */

          fcstab_init();       

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%f",*(fltres+k));
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[0] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%d",*(intres+k));
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);
 
          }

          cnt = strlen(buf);
          crcc[1] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%f",*(dblres+k));
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);
  
          }

          cnt = strlen(buf);
          crcc[2] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%f",*(cpxres+k));
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[3] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%f",*(dcxres+k));
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[4] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%d",*(shtres+k));
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[5] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%d",*(lngres+k));        
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[6] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k< size; k++)
          {
            sprintf(tmp,"%d",*(uinres+k));        
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[7] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%d",*(ushres+k)); 
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[8] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%d",*(ulnres+k));
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[9] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%s",strres);
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }
  
          cnt = strlen(buf);
          crcc[10] = hoot(buf, cnt);
          cnt = 0;

          for(k = 0; k < size; k++)
          {
            sprintf(tmp,"%c",*(bytres+k)); 
            cnt = strlen(tmp);

            if (k == 0)
              strcpy(buf,tmp);
            else
              strncat(buf,tmp,cnt);

          }

          cnt = strlen(buf);
          crcc[11] = hoot(buf, cnt);     
          cnt = 0;


          /* determine if there was a CRC error and keep track of the number */

          for(k = 0; k < 12; k++)
	  {
            crcerr = (crcc[k] - crcr[k]);
            if (crcerr !=0 )
              crccnt++;
          }

        }
      }

        /* message passing is done get timing results */



        /* for triangle message passing make sure slave processes have 
           finish sending message before attempting to receive timing data 
           by setting a barrier */

        if (tstmod == 3)
	{
          stat = pvm_barrier("triangle",3);
          if (stat < 0)
          {
            sprintf(loc,"ERROR SETTING BARRIER FOR SYNCHRONIZATION (MASTER)");
            pvm_perror( loc );
          }
        }

        /* receive timing data */

        msgtype = 200;

        stat = pvm_recv( -1, msgtype  );
        if (stat < 0)
	{
          sprintf(loc,"ERROR RECEIVING TIMING RESULT (MASTER)");
          pvm_perror( loc );
        }

        /* unpack timing data */

        stat = pvm_upkint( &who, 1, 1 );
        if (stat < 0)
	{
          sprintf(loc,"ERROR UNPACKING PROCESS ID FOR TIME DATA (MASTER)");
          pvm_perror( loc );
        }
        stat = pvm_upkint( &crccnt_sl, 1, 1 );
        if (stat < 0)
	{
          sprintf(loc,"ERROR UNPACKING CRC ERROR COUNTER (MASTER)");
          pvm_perror( loc );
        }
        stat = pvm_upkint( &errcnt_sl, 1, 1 );
        if (stat < 0)
	{
          sprintf(loc,"ERROR UNPACKING MESSAGE ERROR COUNTER (MASTER)");
          pvm_perror( loc );
        }
        stat = pvm_upkfloat( ttime+who, 1, 1 );
        if (stat < 0)
	{
          sprintf(loc,"ERROR UNPACKING TIMING DATA (MASTER)");
          pvm_perror( loc );
        }

        /* if triangle messaging is selected then receive and unpack timing
           results from the second slave task */

        if (tstmod == 3)
	{
          stat = pvm_recv(-1, msgtype);
          if (stat < 0)
	  {
            sprintf(loc,"ERROR DETERMINING ARRIVAL OF TIMING DATA (MASTER)");
            pvm_perror( loc );
          } 
          stat = pvm_upkint( &who, 1, 1 );
          if (stat < 0)
	  {
            sprintf(loc,"ERROR UNPACKING PROCESS ID FOR TIMING DATA (MASTER)");
            pvm_perror( loc );
          }
          stat = pvm_upkint( &crccnt_sl, 1, 1 );
          if (stat < 0)
	  {
            sprintf(loc,"ERROR UNPACKING CRC ERROR COUNTER (MASTER)");
            pvm_perror( loc );
          }
          stat = pvm_upkint( &errcnt_sl, 1, 1 );
          if (stat < 0)
	  {
            sprintf(loc,"ERROR UNPACKING MESSAGE ERROR COUNTER (MASTER)");
            pvm_perror( loc );
          }
          stat = pvm_upkfloat( ttime+who, 1, 1 );
          if (stat < 0)
	  {
            sprintf(loc,"ERROR UNPACKING TIMING DATA (MASTER)");
            pvm_perror( loc );
          }
        }

    }

    /* print out timing results appropriate to the test */

    prn_time(choice, tstmod, nproc, err, crccnt, ttime, *sndtim, pack, n, 
             crccnt_sl, errcnt_sl, prnflg);


    /* leave group before exiting */

    if (tstmod == 2)
    {
      stat = pvm_barrier("head", 2);
      if (stat < 0)
      {
        sprintf(loc,"ERROR CALLING BARRIER FOR SYNCHRONIZATION (MASTER)");
        pvm_perror( loc );
      }
  
  
      stat = pvm_lvgroup( "head" );
      if (stat < 0)
      {
        sprintf(loc,"ERROR UNABLE TO LEAVE GROUP (MASTER)");
        pvm_perror( loc );
       }
 
    }

    else if (tstmod == 3)
    {
      stat = pvm_lvgroup( "triangle" );
      if (stat < 0)
      {
        sprintf(loc,"ERROR UNABLE TO LEAVE GROUP (MASTER)");
        pvm_perror( loc );
      }
 
    }
    if (pack[0] == 'y' || pack[0] == 'Y')
    {
      free(fltres);
      free(intres);
      free(bytres);
      free(dblres);
      free(cpxres);
      free(dcxres);
      free(lngres);
      free(shtres);
      free(ulnres);
      free(ushres);
      free(uinres);
      free(buf);
    }
    free(tids);  

    return(1);
}


void prn_time(choice, tstmod, nproc, err, crccnt, 
              ttime, sndtim, pack, n,
              crccnt_sl, errcnt_sl, prnflg)

int choice, tstmod, nproc, err, crccnt, n, crccnt_sl, errcnt_sl, prnflg;
float *ttime;
double sndtim;
char *pack;

{

    float avgtim, ptime;
    int i;
    extern FILE *outfile;

    /* print out timing results appropriate to the test */

    if (err == 0 && crccnt == 0 && errcnt_sl ==0 && crccnt_sl == 0)
    {
      fprintf(outfile,"\ttest%d: OK\n",choice);

      if (tstmod == 3)
      {
        if (prnflg == 1)
	{
          avgtim = sndtim / n;
          fprintf(outfile,"\t\ttotal master message time     = %f\n",sndtim);
          fprintf(outfile,"\t\taverage time/message          = %f\n\n",avgtim);
	  
	  avgtim = ttime[0] / n;
          fprintf(outfile,"\t\ttotal slave #1 message time   = %f\n",ttime[0]);
          fprintf(outfile,"\t\taverage time/message          = %f\n\n",avgtim);

	  avgtim = ttime[1] / n;
	  fprintf(outfile,"\t\ttotal slave #2 message time   = %f\n",ttime[1]);
          fprintf(outfile,"\t\taverage time/message          = %f\n\n",avgtim);
	}
	else if (prnflg == 2)
	{
	  ptime = ttime[0] + ttime[1] + sndtim;
	  fprintf(outfile,"\t\ttotal message time            = %f\n\n",ptime);
	}
      }
      else if (tstmod == 2)
      {
	if (prnflg == 1)
	{
          avgtim = sndtim / n;
          fprintf(outfile,"\t\ttotal master message time     = %f\n",sndtim);
	  fprintf(outfile,"\t\taverage time/message          = %f\n\n",avgtim);

	  avgtim = ttime[0] / n;
          fprintf(outfile,"\t\ttotal slave #1 message time   = %f\n",ttime[0]);
          fprintf(outfile,"\t\taverage time/message          = %f\n\n",avgtim);
	}
	else if (prnflg == 2)
	{
	  ptime = ttime[0] + sndtim;
	  fprintf(outfile,"\t\ttotal message time             = %f\n\n",ptime);
	}
      }
      else 
      {
	if (prnflg == 1)
	{
          for(i = 0; i < nproc; i++)
          {
            avgtim = ttime[i] / n;
            fprintf(outfile,"\t\ttotal slave #%d message time   = %f\n",i,ttime[i]);
	    fprintf(outfile,"\t\taverage time/message          = %f\n\n",avgtim);
	  }
	}
	else if (prnflg == 2)
	{
	  ptime = 0.0;
	  for(i = 0; i < nproc; i++)
	    ptime = ptime + ttime[i];
	  fprintf(outfile,"\t\ttotal message time             = %f\n\n",ptime);
	}
      
      }

    }
    else
      fprintf(outfile,"\ttest%d: FAILED\n",choice);
}

















