//
// sha1prng.asm
// 
// A pseudo-random number generator based on the NIST/NSA's Secure
// Hash Algorithm and an algorithm in FIPS186
//
// We could implement these methods with BMath calls, but
// we would like PRNG to exist independently of LInteger.
//
// These methods should be rewritten in C++ but assembly is the easiest 
// for now.
//
// implementation
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

inline void SHA1PRNG::AddMod160(const u32* x, const u32* y, u32* z)
{
  asm volatile("clc\n\t"
	       "movl $4, %%ecx\n\t"
	       ""
	       "0:\tmovl (%%esi,%%ecx,4), %%eax\n\t"
	       "adcl (%%ebx,%%ecx,4), %%eax\n\t"
	       "movl %%eax, (%%edi,%%ecx,4)\n\t"
	       "decl %%ecx\n\t"
	       "jns 0b\n\t"
	       :
	       : "S" (x), "D" (z), "ebx" (y)
	       : "%eax", "%ecx", "memory"
	       );
}

inline void SHA1PRNG::IncMod160(u32* x)
{
  asm volatile("stc\n\t"
	       "movl $4, %%ecx\n\t"
               "0:\tadcl $0, (%%edi,%%ecx,4)\n\t"
               "decl %%ecx\n\t"
               "jns 0b\n\t"
               :
               : "D" (x)
               : "%ecx", "memory"
               );
}
