// 
// sha1.cxx
//
// NIST/NSA's Secure Hash Algorithm
// (as defined in FIPS180-1)
//
// this implementation
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#include <chnhash/sha1.hxx>
#include <lmisc/lmisc.hxx>
#include <cstring>

SHA1::SHA1() : SHA()
{
}

SHA1::~SHA1()
{
}

void SHA1::Compress(const void* iv, const void* block, void* result) const
{
  u32 IV[5];
  u32 Block[16];
  u32 Res[5];

  memcpy(IV,iv,20);
  memcpy(Block,block,64);

  LMisc::MemSwap(IV,5);
  LMisc::MemSwap(Block,16);

  CompressBlock(IV,Block,Res);

  LMisc::MemSwap(Res,5);
  memcpy(result,Res,20);
}

void SHA1::CompressBlock(const u32* iv, const u32* block, u32* result)
{
  u32 W[16];

  LMisc::MemCopy(W,block,16);

  u32 A=iv[0];
  u32 B=iv[1];
  u32 C=iv[2];
  u32 D=iv[3];
  u32 E=iv[4];

  Scramble(A,B,C,D,E,W);

  result[0]=iv[0]+A;
  result[1]=iv[1]+B;
  result[2]=iv[2]+C;
  result[3]=iv[3]+D;
  result[4]=iv[4]+E;
}

void SHA1::ProcessBuf()
{
  u32 A=H[0];
  u32 B=H[1];
  u32 C=H[2];
  u32 D=H[3];
  u32 E=H[4];

  Scramble(A,B,C,D,E,buf);

  H[0]+=A;
  H[1]+=B;
  H[2]+=C;
  H[3]+=D;
  H[4]+=E;
}
