/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.database;

import gnu.prolog.database.PrologTextLoader;
import gnu.prolog.io.ParseException;

public class PrologTextLoaderError
extends Exception {
    private static final long serialVersionUID = 4388822484504978038L;
    protected String file;
    protected int line;
    protected int column;

    public PrologTextLoaderError(String file, int line, int column, String message) {
        super(message);
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public PrologTextLoaderError(PrologTextLoader loader, String message) {
        this(loader.getCurrentFile(), loader.getCurrentLine(), loader.getCurrentColumn(), message);
    }

    public PrologTextLoaderError(PrologTextLoader loader, ParseException ex) {
        this(loader.getCurrentFile(), ex.getLine(), ex.getColumn(), "syntax error: " + ex.getMessage());
    }

    public PrologTextLoaderError(PrologTextLoaderError partialError, String message) {
        this(partialError.file, partialError.line, partialError.column, message);
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return String.valueOf(this.file) + ":" + this.line + ":" + this.column + ": " + this.getMessage();
    }
}

