/* Copyright (C) 1993, 2000 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
  to anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer
  to the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given
  to you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
*/

/*$RCSfile: gsccode.h,v $ $Revision: 1.4.2.1 $ */
/* Types for character codes */

#ifndef gsccode_INCLUDED
#  define gsccode_INCLUDED

/*
 * Define a character code.  Normally this is just a single byte from a
 * string, but because of composite fonts, character codes must be
 * at least 32 bits.
 */
typedef ulong gs_char;

#define gs_no_char ((gs_char)~0L)

/*
 * Define a character glyph code, a.k.a. character name.
 * gs_glyphs from 0 to 2^31-1 are (PostScript) names; gs_glyphs 2^31 and
 * above are CIDs, biased by 2^31.
 */
typedef ulong gs_glyph;

#define gs_no_glyph ((gs_glyph)0x7fffffff)
#if arch_sizeof_long > 4
#  define gs_min_cid_glyph ((gs_glyph)0x80000000L)
#else
/* Avoid compiler warnings about signed/unsigned constants. */
#  define gs_min_cid_glyph ((gs_glyph)~0x7fffffff)
#endif
#define gs_max_glyph max_ulong

/* Define a procedure for marking a gs_glyph during garbage collection. */
typedef bool(*gs_glyph_mark_proc_t) (P2(gs_glyph glyph, void *proc_data));

/* Define a procedure for mapping a gs_glyph to its (string) name. */
/*
 * NOTE: As of release 6.21, his procedure is obsolete and deprecated,
 * but it must be supported for backward compatibility for the xfont
 * interface.
 */
#define gs_proc_glyph_name(proc)\
  const char *proc(P2(gs_glyph, uint *))
typedef gs_proc_glyph_name((*gs_proc_glyph_name_t));
/*
 * This is the updated procedure, which accepts closure data and also can
 * return an error code.
 */
#define gs_glyph_name_proc(proc)\
  int proc(P3(gs_glyph glyph, gs_const_string *pstr, void *proc_data))
typedef gs_glyph_name_proc((*gs_glyph_name_proc_t));

/* Define the indices for known encodings. */
typedef enum {
    ENCODING_INDEX_UNKNOWN = -1,
	/* Real encodings.  These must come first. */
    ENCODING_INDEX_STANDARD = 0,
    ENCODING_INDEX_ISOLATIN1,
    ENCODING_INDEX_SYMBOL,
    ENCODING_INDEX_DINGBATS,
    ENCODING_INDEX_WINANSI,
    ENCODING_INDEX_MACROMAN,
    ENCODING_INDEX_MACEXPERT,
#define NUM_KNOWN_REAL_ENCODINGS 7
	/* Pseudo-encodings (glyph sets). */
    ENCODING_INDEX_MACGLYPH,	/* Mac glyphs */
    ENCODING_INDEX_ALOGLYPH,	/* Adobe Latin glyph set */
    ENCODING_INDEX_ALXGLYPH,	/* Adobe Latin Extended glyph set */
    ENCODING_INDEX_CFFSTRINGS	/* CFF StandardStrings */
#define NUM_KNOWN_ENCODINGS 11
} gs_encoding_index_t;
#define KNOWN_REAL_ENCODING_NAMES\
  "StandardEncoding", "ISOLatin1Encoding", "SymbolEncoding",\
  "DingbatsEncoding", "WinAnsiEncoding", "MacRomanEncoding",\
  "MacExpertEncoding"

/*
 * For fonts that use more than one method to identify glyphs, define the
 * glyph space for the values returned by procedures that return glyphs.
 * Note that if a font uses only one method (such as Type 1 fonts, which
 * only use names, or TrueType fonts, which only use indexes), the
 * glyph_space argument is ignored.
 */
typedef enum gs_glyph_space_s {
    GLYPH_SPACE_NAME,		/* names (if available) */
    GLYPH_SPACE_INDEX		/* indexes (if available) */
} gs_glyph_space_t;

/*
 * Define a procedure for accessing the known encodings.  Note that if
 * there is a choice, this procedure always returns a glyph name, not a
 * glyph index.
 */
#define gs_proc_known_encode(proc)\
  gs_glyph proc(P2(gs_char, int))
typedef gs_proc_known_encode((*gs_proc_known_encode_t));

/* Define the callback procedure vector for character to xglyph mapping. */
typedef struct gx_xfont_callbacks_s {
    gs_proc_glyph_name((*glyph_name));
    gs_proc_known_encode((*known_encode));
} gx_xfont_callbacks;

#endif /* gsccode_INCLUDED */
