#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include "pktdrv.h"
#include "timer.h"
#include "mbuf.h"

#include "nettrace.h"
#include "cookie.h"

static char str[200];

#define TM_FREE		(0L)
#define TM_STOP		((clock_t)1)

typedef struct
{
	clock_t	tm_timeout;
	void	(*tm_handler)(TIMER);
} TM_ENTRY;

#define TM_MINCNT	8

static TM_ENTRY *tm_table = NULL;
static int		tm_count = 0;
static int		tm_active = 0;

TIMER tm_alloc(void)
{
int i;
TM_ENTRY *tm;

	if(!tm_table)
	{
		tm_table = (TM_ENTRY *)getmem(sizeof(TM_ENTRY) * TM_MINCNT);
		if(!tm_table) return(-1);
		tm_count = TM_MINCNT;
		tm = tm_table;
		for(i=0;i<TM_MINCNT;i++)
		{			/* init table */
			tm->tm_timeout = TM_FREE;
			tm->tm_handler = NULL;
			tm++;
		}
		net_demux(TRUE,tm_handler);
	}
	tm = tm_table;
	for(i=0;i<tm_count; i++)
	{
		if(tm->tm_timeout == TM_FREE)
		{
			tm->tm_timeout = TM_STOP;
			tm->tm_handler = NULL;
			tm_active++;
			return(i);
		}
	}
			/* no free timerentry, enlarge table */
	tm = (TM_ENTRY *)resizemem(tm_table,
								(TM_MINCNT+tm_count)*sizeof(TM_ENTRY));
	if(!tm)
	{
		resizemem(tm_table,tm_count*sizeof(TM_ENTRY));
		return(-1);
	}
	tm_table = tm;
	tm += tm_count+1;
	for(i=1;i<TM_MINCNT;i++)
	{			/* init table */
		tm->tm_timeout = TM_FREE;
		tm->tm_handler = NULL;
		tm++;
	}
	i = tm_count;
	tm_table[i].tm_timeout = TM_STOP;
	tm_table[i].tm_handler = NULL;
	tm_count += TM_MINCNT;
	tm_active++;
	return(i);
}


int tm_set(u_long tm_timeout, void(*tm_handler)(),TIMER tm)
{
#ifdef DEBUG
sprintf(str,"~set tm %d\n",tm);
TRACE(str);
#endif
	if(tm < 0 ||
	   !tm_table ||
	   tm >= tm_count ||
	   tm_table[tm].tm_timeout == TM_FREE) return(-1);
	   
	tm_table[tm].tm_timeout = clock() + (clock_t)tm_timeout;
	if(tm_handler)
		tm_table[tm].tm_handler = tm_handler;
	return(tm);
}

int tm_stop(TIMER tm)
{
#ifdef DEBUG
sprintf(str,"~stop tm %d\n",tm);
TRACE(str);
#endif
	if(tm<0 || !tm_table || tm>=tm_count) return(-1);
	if(tm_table[tm].tm_timeout == TM_FREE) return(-1);
	tm_table[tm].tm_timeout = TM_STOP;
	return(tm);
}


int tm_free(TIMER tm)
{
#ifdef DEBUG
sprintf(str,"~free tm %d\n",tm);
TRACE(str);
#endif
	if(tm<0 || !tm_table || tm >= tm_count) return(-1);
	if(tm_table[tm].tm_timeout == TM_FREE) return(-1);
	tm_table[tm].tm_timeout = TM_FREE;
	if(tm_active > 0) tm_active--;
	if(!tm_active)
	{
		net_demux(FALSE,tm_handler);
		freemem(tm_table);
		tm_table = NULL;
	}
	return(tm);
}

int tm_handler(void)
{
u_long timeout;
int i;
TM_ENTRY *tm;
	if(!tm_table) return(-1);
	timeout = clock();
	tm = tm_table;
	for(i=0; i<tm_count; i++)
	{
		if(tm->tm_timeout > TM_STOP)
		{
			if(tm->tm_timeout <= timeout &&
			   tm->tm_handler)
			{
#ifdef DEBUG
sprintf(str,"~tmhandler %d: time = %lu, timeout = %lu\n",i,timeout, tm->tm_timeout);
TRACE(str);
#endif
				tm->tm_timeout = TM_STOP;
	  	   	    tm->tm_handler(i);
			}
		}
		tm++;
	}
	return(TRUE);
}