/*     ANS compatible Telnet in AES windows     */
/*         compiled with TURBO-C/PURE-C         */
/*  P. Mayer & H. Wieser fortec TU Vienna 1992  */

#define noDEBUG
#define NET
#define GEMWIN
#define DISPLAYSIZE	128

#include <stdio.h>	
#include <stdlib.h>
#include <string.h>
#include <tos.h>
#include <aes.h>
#include <ctype.h>
#include "tcpdef.h"
#include "tndefs.h"

#define INBUFSIZE 4096
#define TELNET_PORT 	23
#define u_char unsigned char
#define TERMINALTYPE	24
#define TERMINALNAME	"VT100"

void printw(struct wi_str *wp, char *text);
int upcall(struct wi_str *wp);
void invert(struct wi_str *wp,int x1,int y1,int x2, int y2);

extern void w_output(struct wi_str *wp, unsigned char *ptr, short charcount);
extern void w_info(struct wi_str *wp, char *name);
extern long resolv(char *host, char ipaddr[4],struct wi_str *wp);

extern struct wi_str *wlist;  /* a pointer into the window ring */
extern int delmode;
extern struct wi_str *wsource;

char o_str[30];
int o_len;
char data[INBUFSIZE];
DESTI desti, my;
TCPSTAT tstat;
char *myid = "@(#)TUW-Telnet 1.0 pm/hw";

static int tcp_id, state;
static char *p;
static char *term;
static int tcp_buff = 4096;
static int x;
static int i;

/* open a connection and return tcp handle, 0 if error */

int connect(int myport, char * host, int port)
{
  term = (char *)getenv("TCPWND");
  if(term) tcp_buff = atoi(term);

  desti.Port = port;

#ifdef NET
/*  if(GetIPAddr(host,desti.IPAddr))
  {
    unsigned int tmp1,tmp2,tmp3,tmp4;
    
    if(sscanf(host,"%d.%d.%d.%d",&tmp1,&tmp2,&tmp3,&tmp4) != 4)
    {
      w_info(wlist,"<Error: unknown host.>");
      wlist->pid = 0;
      return 0;
    }
    desti.IPAddr[0] = tmp1;
    desti.IPAddr[1] = tmp2;
    desti.IPAddr[2] = tmp3;
    desti.IPAddr[3] = tmp4;
  }
*/

  if(resolv(host,desti.IPAddr,wlist))
  {
      w_info(wlist,"<Error: unknown host.>");
      wlist->pid = 0;
      return 0;
  }

  w_info(wlist,"<Status: trying to open connection.>");
  tcp_id = (unsigned)tcp_open(myport,&desti,AKTIV,60,(long)tcp_buff);
 
  if(tcp_id == 0)
  {
    w_info(wlist,"<Error: could not open connection.>");
    wlist->pid = 0;
    return 0;
  }

  do
  {
    state = (int)tcp_stat(tcp_id,&tstat);
    if((state > ESTABLISHED) || (state <= CLOSED)) break;
    evnt_timer(10,0);
  }
  while(state < ESTABLISHED);

  if(state != ESTABLISHED)
  {
    w_info(wlist,"<Error: connection refused.>");
    wlist->pid = 0;
    return 0;
  }
  w_info(wlist,"<Status: connected.>");
  return(tcp_id);
#else
  return 1;
#endif
}

int tnet(struct wi_str *wp, long code)
{
  char c;
  int tcperr;
  
  c = (char)code;
  o_len = 1;

#ifdef GEMWIN
  switch((int)(code >> 8))
  {
    /* cursor keys... */

  case 0x0048:  /* up arrow */
    if (wp->curskey)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'A';
      o_len = 3;

    }
    else
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'[';
      o_str[2] = (int)'A';
      o_len = 3;
    }
    break;
  case 0x0050:  /* down arrow */
    if (wp->curskey)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'B';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'[';
      o_str[2] = (int)'B';
      o_len = 3;
    }
    break;
  case 0x004d:  /* right arrow */
    if (wp->curskey)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'C';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'[';
      o_str[2] = (int)'C';
      o_len = 3;
    }
    break;
  case 0x004b:  /* left arrow */
    if (wp->curskey)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'D';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'[';
      o_str[2] = (int)'D';
      o_len = 3;
    }
    break;

    /* wp->keypad keys... */

  case 0x0070:  /* 0 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'p';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'0';
    }
    break;
  case 0x006d:  /* 1 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'q';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'1';
    }
    break;
  case 0x006e:  /* 2 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'r';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'2';
    }
    break;
  case 0x006f:  /* 3 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'s';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'3';
    }
    break;
  case 0x006a:  /* 4 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'t';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'4';
    }
    break;
  case 0x006b:  /* 5 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'u';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'5';
    }
    break;
  case 0x006c:  /* 6 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'v';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'6';
    }
    break;
  case 0x0067:  /* 7 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'w';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'7';
    }
    break;
  case 0x0068:  /* 8 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'x';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'8';
    }
    break;
  case 0x0069:  /* 9 */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'y';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'9';
    }
    break;
  case 0x004a:  /* - */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'m';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'-';
    }
    break;
  case 0x0072:  /* enter */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'M';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)RETURN;
    }
    break;
  case 0x0071:  /* . */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'n';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'.';
    }
    break;
  case 0x004e:  /* + */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'T';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'+';
    }
    break;
  case 0x0063:  /* ( */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'P';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'(';
    }
    break;
  case 0x0064:  /* ) */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'Q';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)')';
    }
    break;
  case 0x0065:  /* / */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'R';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'/';
    }
    break;
  case 0x0066:  /* * */
    if (wp->keypad)
    {
      o_str[0] = (int)ESC;
      o_str[1] = (int)'O';
      o_str[2] = (int)'S';
      o_len = 3;
    }
    else
    {
      o_str[0] = (int)'*';
    }
    break;

    /* anything else... */

  default:
    switch(c)
    {
      case '\r':
      {
        if(wp->lfmode) 
        {
          o_str[0] = '\r';
          o_str[1] = '\n';
          o_len = 2;
        }
        else o_str[0] = '\r';
        break;
      }
      case '\b':
      {
        if(!delmode)
    	   o_str[0] = '\b';
        else
    	   o_str[0] = '\x7f';
        break;
      }
      case '\x7f':
      {
        if(!delmode)
    	   o_str[0] = '\x7f';
        else
    	   o_str[0] = '\b';
        break;
      }
      default:
      {
        if(code && !c)
    	   o_str[0] = '@';
        else
	   o_str[0] = c;
      }
    }
  }

#else
  switch((int)(code >> 8))
  {
    /* cursor keys... */

  case 0x0048:  /* up arrow */
      o_str[0] = (int)ESC;
      o_str[1] = (int)'A';
      o_len = 2;
    break;
  case 0x0050:  /* down arrow */
      o_str[0] = (int)ESC;
      o_str[1] = (int)'B';
      o_len = 2;
    break;
  case 0x004d:  /* right arrow */
      o_str[0] = (int)ESC;
      o_str[1] = (int)'C';
      o_len = 2;
    break;
  case 0x004b:  /* left arrow */
      o_str[0] = (int)ESC;
      o_str[1] = (int)'D';
      o_len = 2;
    break;
  default:
      o_str[0] = code & 0xff;
      o_len = 1;
  }
#endif
  if(c == 0x03)
  {
    o_str[0] = TN_IAC;
    o_str[1] = TN_IP;
    o_len = 2;
  }
      
  tcperr = 0;
  for(i=0; i <o_len;)
  {
#ifdef NET
    x=(int)tcp_write(wp->pid,&o_str[i],o_len-i,PUSH,NO_URGENT);
#else
    x=1;
    Bconout(AUX,o_str[i]);
#endif
    if(x >= 0)
    {
     i+=x;
     tcperr = 0;
    } 
    else
    {
      w_info(wp,"<Error: in writing connection.>");
      tcperr++;
      if(tcperr > 10)
      {
       tcp_close(wp->pid);
       wp->pid = 0;
       break;
      } 
    }
  }
  if(c == 0x03)
  {
     while(tcp_read(wp->pid,&data,INBUFSIZE) > 0);
  }
#ifdef NET
  state = (int)tcp_stat(wp->pid,&tstat);

  return state;
#else
  return 0;
#endif
}

int upcall(struct wi_str *wp)
{
  int length;
  int x,xx;

  length = (int)tcp_read(wp->pid,&data,DISPLAYSIZE);
#ifdef DEBUG
printf("%d ",length);
#endif
  if(length <= 0) return length;
  p = data;

  while(length)
  {
    if((u_char)p[0] == 255)
    {
      o_len = 0;
      switch((u_char)p[1])
      {
      case TN_WILL:
        o_str[o_len++]=TN_IAC;
        if(p[2] == 1) o_str[o_len++]=TN_DO;
        else o_str[o_len++]=TN_DONT;
        o_str[o_len++]=p[2];
        break;
      case TN_WONT:
        o_str[o_len++]=TN_IAC;
        o_str[o_len++]=TN_WONT;
        o_str[o_len++]=p[2];
        break;
      case TN_DO:
        o_str[o_len++]=TN_IAC;
        if(p[2] == 1 || p[2] == TERMINALTYPE)
          o_str[o_len++]=TN_WILL;
        else
          o_str[o_len++]=TN_WONT;
        o_str[o_len++]=p[2];
        break;
      case TN_DONT:
        o_str[o_len++]=TN_IAC;
        o_str[o_len++]=TN_WONT;
        o_str[o_len++]=p[2];
        break;
      case TN_SB:
        if(p[2] == TERMINALTYPE && p[3] == 1 )
        {
          o_str[o_len++]=TN_IAC;
          o_str[o_len++]=TN_SB;
          o_str[o_len++]=TERMINALTYPE;
          o_str[o_len++]=0;
          strcpy((char *)&o_str[o_len],TERMINALNAME);
          o_len += (int)sizeof(TERMINALNAME)-1;
          o_str[o_len++]=TN_IAC;
          o_str[o_len++]=TN_SE;
          length -= 3;
          p += 3;
          break;
        }
      case TN_IAC:
        length -= 2;
        p += 2;
        Bconout(2,255);
        continue;

      case TN_SE:
      case TN_NOP:
      case TN_DM:
      case TN_BRK:
      case TN_IP:
      case TN_AO:
      case TN_AYT:
      case TN_EC:
      case TN_EL:
      case TN_GA:
        p+=2;
        length -= 2;
        continue;
      }
      length -= 3;
      x = 0;
      while(o_len)
      {
        xx = (int)tcp_write(tcp_id,o_str+x,o_len,PUSH,NO_URGENT);
        if(xx >= 0)
        {
          x+=xx;
          o_len-=xx;
        }
        else
          return(xx);
      }
      p+=3;
    }
    else
    {
      if(wp->lastx2 >= 0)
      {
       invert(wp,wp->markx1,wp->marky1,wp->markx2,wp->marky2);
       wp->lastx2 = -1;
      }
#ifdef DEBUG
printf("show %d chars\n",length);
#endif      
      w_output(wp,p,length);
      length = 0;
    }
  }
  return(length);
}

int tcp_out(int tcp_id, char *o_str, int o_len)
{
  int xx = 0;
  int x = 0;
  
       while(o_len)
       {
#ifdef NET
         xx = (int)tcp_write(tcp_id,o_str+x,o_len,PUSH,NO_URGENT);
#else
         xx = 1;
         Bconout(AUX,o_str[x]);
#endif
         if(xx >= 0)
         {
          x += xx;
          o_len -= xx;
         }
         else break;
       }
       return o_len;
}

void printw(struct wi_str *wp,char*text)
{
  w_output(wp,text,strlen(text));
}
