/************************************************************************/
/*                                                                      */
/*    news.c                                                            */
/*                                                                      */
/*    Durch bloes ndern der Extension im Dateinamen, lt sich Pro-   */
/*    gramm als normale GEM-Anwendung oder aber als Accessory betrei-   */
/*    ben.                                                              */
/*    Das Programm zeigt in einem Fenster die aktuellen Neuigkeiten an. */
/*                                                                      */
/*    Copyright (c)  FORTEC/pm 1989                                     */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*    Headerdateien einbinden.                                          */
/* -------------------------------------------------------------------- */

#include <aes.h>
#include <stdio.h>
#include <tos.h>
#include <vdi.h>
#include <string.h>
#include <cookie.h>
#include "ownfunc.h"


#define TEXTSIZE 2048L
#define WINW     300
#define WINH     200

/* -------------------------------------------------------------------- */
/*    Extern definierte globale Variablen.                              */
/* -------------------------------------------------------------------- */
                                    /* Mittels dieser Variablen kann    */
extern int _app;                    /* das Programm feststellen, ob es  */
                                    /* als Accessory oder normale App-  */
                                    /* likation gestartet wurde.        */
/* -------------------------------------------------------------------- */
/*    Globale Variablen.                                                */
/* -------------------------------------------------------------------- */

int  whandle;                       /* Handle fr geffnetes Fenster.   */
char title[] = "NetEnvironment";    /* Titelzeile des Fensters.         */
int  gl_wchar,                      /* Gre und Breite eines Buchsta-  */
     gl_hchar,                      /* ben (wichtig falls mit unter-    */
     gl_wbox,                       /* schiedlichen Bildschirmaufl-    */
     gl_hbox;                       /* sungen gearbeitet wird) bzw.     */
                                    /* einer Box.                       */
int  phys_handle,                   /* Handles fr GEM und VDI.         */
     handle;
int  max_x,                         /* Maximale Gre der Arbeitsflche */
     max_y;
int  appl_id,                       /* Identifikationsnummer des Prog.  */
     menu_id;                       /* Id.-nummer im Men 'Desk'.       */

char env_text[TEXTSIZE+1L];
char *env_item[100];
char *p_t;                          /* Pointer auf Newstext             */
long netenv(char *);
TCPSTAT tstat;

/* -------------------------------------------------------------------- */
/*    read_text()                                                       */
/*                                                                      */
/*    Lesen der News                                                    */
/* -------------------------------------------------------------------- */

char * read_text(void)
{
 int fhandle;
 char *p_l;
 int i;
   
 fhandle=Fopen("\\NETENV.INF",0);
 p_l = env_text-1;
 i=0;
 if(fhandle >0)
 {
   /* Zeichen einzeln einlesen */
   p_l = env_text;
   env_item[0] = p_l;
   while (1L == Fread(fhandle, 1L, p_l) && (p_l-env_text < TEXTSIZE))
   {
     switch (*p_l)
     {
     case 13:/* CR ausfiltern */
       break;
     case 10:/* LF nach NULL */
       *p_l++ = 0;                        
       env_item[++i] = p_l;
       break;
     default:
       p_l += 1;
       break;
     }
     if(i>=((sizeof(env_item)/sizeof(env_item[0]))-1)) break;
   }
   Fclose(fhandle);
 }
 env_item[i] = NULL;
 if(p_l-env_text <= 0L) sprintf(env_text,"NETENV.INF not found!");
 else env_text[p_l-env_text]=0;

 return env_text;
}

/* -------------------------------------------------------------------- */
/*    open_window()                                                     */
/*                                                                      */
/*    ffnen eines Fensters                                             */
/* -------------------------------------------------------------------- */

void open_window( void )
{
   if(whandle <= 0)
   {
      whandle = wind_create( NAME|CLOSER|MOVER, 0, 0, max_x + 1, max_y + 1 );
      if( whandle <= 0 )
         return;

      wind_set ( whandle, WF_NAME, title );
      wind_open( whandle, 100, 100, WINW, WINH );
   }
   else
      wind_set( whandle, WF_TOP );
}

/* -------------------------------------------------------------------- */
/*    min()                                                             */
/*                                                                      */
/*    Minimum zweier Zahlen berechnen.                                  */
/* -------------------------------------------------------------------- */

int min( int a, int b)
{
   if( a > b )
      return( b );
   else
      return( a );
}

/* -------------------------------------------------------------------- */
/*    max()                                                             */
/*                                                                      */
/*    Maximum zweier Zahlen bestimmen.                                  */
/* -------------------------------------------------------------------- */

int max( int a, int b)
{
   if( a < b )
      return( b );
   else
      return( a );
}

/* -------------------------------------------------------------------- */
/*    rc_intersect()                                                    */
/*                                                                      */
/*    Schnittflche zweier Rechtecke berechnen.                         */
/* -------------------------------------------------------------------- */

int rc_intersect(GRECT *r1, GRECT *r2)
{
   int xl, yu, xr, yd;                      /* left, upper, right, down */

   xl      = max( r1->g_x, r2->g_x );
   yu      = max( r1->g_y, r2->g_y );
   xr      = min( r1->g_x + r1->g_w, r2->g_x + r2->g_w );
   yd      = min( r1->g_y + r1->g_h, r2->g_y + r2->g_h );

   r2->g_x = xl;
   r2->g_y = yu;
   r2->g_w = xr - xl;
   r2->g_h = yd - yu;

   return( r2->g_w > 0 && r2->g_h > 0 );
}

/* -------------------------------------------------------------------- */
/*    mouse_on()                                                        */
/*                                                                      */
/*    Mauszeiger anschalten.                                            */
/* -------------------------------------------------------------------- */

void mouse_on(void)

{
   graf_mouse( M_ON, (void *)0 );
}

/* -------------------------------------------------------------------- */
/*    mouse_off()                                                       */
/*                                                                      */
/*    Mauszeiger ausschalten.                                           */
/* -------------------------------------------------------------------- */

void mouse_off(void)
{
   graf_mouse( M_OFF, (void *)0 );
}

/* -------------------------------------------------------------------- */
/*    redraw_window()                                                   */
/*                                                                      */
/*    Fensterinhalt neu zeichnen, nachdem er zuvor aus irgendeinem      */
/*    Grunde zerstrt wurde, oder weil das Fenster neu geffnet wurde.  */
/* -------------------------------------------------------------------- */

void redraw_window( int all )
{
   GRECT   box,
           work;
   int     clip[4];
   char    *p_l;
   int     line,dum;
      
   if( whandle <= 0 )                  /* Wenn kein Fenster auf ist,    */
      return;                          /* braucht auch nicht gezeichnet */
                                       /* zu werden.                    */

   if(all)
   {

      mouse_off();

      vsf_color( handle, 0 );                       /* set white fill   */
      vswr_mode( handle, 1 );                       /* set replace mode */
      vst_height( handle, 4, &dum,&dum,&dum,&dum);  /* set small font   */

      wind_get( whandle, WF_WORKXYWH, &work.g_x, &work.g_y, &work.g_w,
                &work.g_h );
      wind_get( whandle, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w,
                &box.g_h );
      work.g_w = min( work.g_w, max_x - work.g_x + 1 );
      work.g_h = min( work.g_h, max_y - work.g_y + 1 );
      
      while ( box.g_w > 0 && box.g_h > 0 )
      {
         if( rc_intersect( &work, &box ) )
         {
            clip[0] = box.g_x;
            clip[1] = box.g_y;
            clip[2] = box.g_x + box.g_w - 1;
            clip[3] = box.g_y + box.g_h - 1;

            vs_clip( handle, 1, clip );
            if( all )
               vr_recfl( handle, clip );
              /* fill rectangle */
            line=0;
            p_l=p_t;
            while(*p_l)
            {
              v_gtext( handle, work.g_x, work.g_y + 15 + (line*10), p_l);
              line++;
              p_l=p_l+strlen(p_l)+1;
            }
         }
         wind_get( whandle, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w,
                   &box.g_h );
      }
      mouse_on();
   }
}

/* -------------------------------------------------------------------- */
/*    handle_message()                                                  */
/*                                                                      */
/*    Auswertung der Ereignisse des Multi-Events bezglich des Message- */
/*    buffers.                                                          */
/* -------------------------------------------------------------------- */

int handle_message( int pipe[8] )
{
   switch ( pipe[0] )
   {
      case WM_REDRAW:
         redraw_window(1);
      break;

      case WM_TOPPED:
         wind_set( whandle, WF_TOP );
      break;

      case WM_CLOSED:
         if( pipe[3] == whandle )
         {
            wind_close( whandle );
            wind_delete( whandle );
            whandle = 0;
         }
         if( _app )
            return(1);
      break;

      case WM_MOVED:
      case WM_SIZED:
         if( pipe[3] == whandle )
            wind_set( whandle, WF_CURRXYWH,  pipe[4], pipe[5],
                      pipe[6], pipe[7] );
      break;

      case AC_OPEN:
         if( pipe[4] == menu_id )
         {
         	p_t = read_text();
            open_window();
         }
      break;

      case AC_CLOSE:
         if( pipe[3] == menu_id )
            whandle = 0;
      break;
   }
   return(0);
}

/* -------------------------------------------------------------------- */
/*    event_loop()                                                      */
/*                                                                      */
/*    Die Multi-Event-Schleife.                                         */
/* -------------------------------------------------------------------- */

static void event_loop( void )
{
   int x, y,
       kstate,
       key,
       clicks,
       event,
       state;
   int pipe[8];
   int quit;

   quit = 0;
   do
   {
      event = evnt_multi( MU_MESAG | MU_TIMER,
                          2, 0x1, 1,
                          0, 0, 0, 0, 0,
                          0, 0, 0, 0, 0,
                          pipe,
                          10, 0,
                          &x, &y, &state, &kstate, &key, &clicks );


      if( event & MU_MESAG)
      {
	     wind_update(BEG_UPDATE);
         quit = handle_message( pipe );
    	 wind_update(END_UPDATE);
      }
      if( event & MU_TIMER)
      {
		 tcp_stat(0,&tstat);
      }
      


   }
   while (!quit);
}

/* -------------------------------------------------------------------- */
/*    main()                                                            */
/*                                                                      */
/*    Kernstck des Programms.                                          */
/* -------------------------------------------------------------------- */

int main( void )
{
   int i;
   int work_in[11];
   int work_out[57];

   extern char *read_text(void);
   
   /* ----------------------------------------------------------------- */
   /* Initialization                                                    */
   /* ----------------------------------------------------------------- */

   appl_id = appl_init();
   if( appl_id != -1 )
   {
      for (i = 0; i < 10; i++)
         work_in[i]  = 1;
         work_in[10] = 2;
         phys_handle = graf_handle( &gl_wchar, &gl_hchar, &gl_wbox,
                                     &gl_hbox );
      handle = phys_handle;
      v_opnvwk( work_in, &handle, work_out );
      if( handle != 0 )
      {
         max_x = work_out[0];
         max_y = work_out[1];
         p_t=read_text();
         if( !_app )
         {
         	if(env_item[0]) add_cookie(NETENVCOOKIE,(long)netenv);
            menu_id = menu_register( appl_id, "  NetEnv" );
         }
         else
         {
            graf_mouse( 0, (void*)0 );
            open_window();
         }

   /* ----------------------------------------------------------------- */
   /* Event Loop                                                        */
   /* ----------------------------------------------------------------- */

         event_loop();

   /* ----------------------------------------------------------------- */
   /* Deinitialization                                                  */
   /* ----------------------------------------------------------------- */

         v_clsvwk( handle );
      }
      appl_exit();
   }
   return(0);
}

long netenv(char *item)
{
register char **envdata;
register char *data;

	if(!item) return(0L);
	envdata = env_item;
	while(*envdata)
	{
		if(!strnicmp(*envdata,item,strlen(item)))
		{
			data = *envdata;
			while(*data && *data++ != '=');
			while(*data && *data == ' ') data++;
			if(!*data) return(0L);
			return((long)data);
		}
		envdata++;
	}
	return(0L);
}



/* -------------------------------------------------------------------- */
/*    End of ENVACC.C                                                   */
/* -------------------------------------------------------------------- */
