#include "lancemem.h"
#include "pktqueue.h"
#include <tos.h>

#ifndef NULL
#define NULL (void *)0L
#endif

#define FALSE 0
#define TRUE  1 

#define DEBUGPKT
#define noDEBUG

short p_intstat;
extern long p_disint(void);
extern long p_enabint(void);


PKTPOOL *p_init(int npkt,PKTPOOL *p_pool,PKTBUF *p_buf)
{
register int i;

	if(!p_pool) return(NULL);
	p_pool->p_get = p_pool->p_put = 0;
	p_pool->p_nbuf = npkt;
	for(i=0; i<npkt; i++)
	{
		p_pool->p_tab[i].p_occupied = FALSE;
		p_pool->p_tab[i].p_pkt = p_buf+i;
	}
	return(p_pool);
}

PKTBUF *ap_getpkt(u_short protocol, PKTPOOL *p_pool)
{
PKTBUF *pkt;
	p_disint();
	pkt=p_getpkt(protocol,p_pool);
	p_enabint();
	return(pkt);
}


PKTBUF *p_getpkt(u_short protocol, PKTPOOL *p_pool)
{
register int i;

	if(!p_pool) return(NULL);
	i = p_pool->p_get;
	if(p_pool->p_tab[i].p_occupied) return(NULL);
	p_pool->p_get++;
	if(p_pool->p_get >= p_pool->p_nbuf) p_pool->p_get = 0;
	p_pool->p_tab[i].p_occupied = protocol;
	return(p_pool->p_tab[i].p_pkt);
}

int ap_putpkt(PKTPOOL *p_pool,PKTBUF *pkt)
{
int r;
	Supexec(p_disint);
	r=p_putpkt(p_pool,pkt);
	Supexec(p_enabint);
	return(r);
}


int p_putpkt(PKTPOOL *p_pool,PKTBUF *pkt)
{
register int i;

	if(!p_pool) return(FALSE);
	i = p_pool->p_put;
	if(!p_pool->p_tab[i].p_occupied)
	{
#ifdef DEBUGPKT
		Cconws("Packet already in queue\r\n");
#endif
		return(FALSE);
	}
	p_pool->p_put++;
	if(p_pool->p_put >= p_pool->p_nbuf) p_pool->p_put = 0;
	p_pool->p_tab[i].p_pkt = pkt;
	p_pool->p_tab[i].p_occupied = FALSE;
	return(TRUE);
}
