/************************************************************************/
/*                                                                      */
/*    ftpserv.c                                                         */
/*                                                                      */
/*    Durch bloes ndern der Extension im Dateinamen, lt sich Pro-   */
/*    gramm als normale GEM-Anwendung oder aber als Accessory betrei-   */
/*    ben.                                                              */
/*                                                                      */
/*    Copyright (c)  FORTEC/pm 1993                                     */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*    Headerdateien einbinden.                                          */
/* -------------------------------------------------------------------- */

#include <aes.h>
#include <stdio.h>
#include <tos.h>
#include <vdi.h>
#include <ext.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "cookie.h"
#include "inetcust.h"
#include "tcpdef.h"
#include "ftp.h"

#define LINESIZE 90L
#define NUMLINES 10
#define WINW     600
#define WINH     200

/* -------------------------------------------------------------------- */
/*    Extern definierte globale Variablen.                              */
/* -------------------------------------------------------------------- */
                                    /* Mittels dieser Variablen kann    */
extern int _app;                    /* das Programm feststellen, ob es  */
                                    /* als Accessory oder normale App-  */
                                    /* likation gestartet wurde.        */
COOKIE *cookie;
INETCUST *custom;
extern int write_log(char *);  
extern void closetcp(void);


/* -------------------------------------------------------------------- */
/*    Globale Variablen.                                                */
/* -------------------------------------------------------------------- */

int  whandle;                       /* Handle fr geffnetes Fenster.   */
char title[] = "TUW-FTP-Server";    /* Titelzeile des Fensters.         */
int  gl_wchar,                      /* Gre und Breite eines Buchsta-  */
     gl_hchar,                      /* ben (wichtig falls mit unter-    */
     gl_wbox,                       /* schiedlichen Bildschirmaufl-    */
     gl_hbox;                       /* sungen gearbeitet wird) bzw.     */
                                    /* einer Box.                       */
int  phys_handle,                   /* Handles fr GEM und VDI.         */
     handle;
int  max_x,                         /* Maximale Gre der Arbeitsflche */
     max_y;
int  appl_id,                       /* Identifikationsnummer des Prog.  */
     menu_id;                       /* Id.-nummer im Men 'Desk'.       */

char log_text[NUMLINES][LINESIZE+1];
int  line_tab[NUMLINES];
int  actline = 0;
FTP ftp;
int busy = 0;
FILE *fp_pass;

void redraw_window( int all );

int scroll_log(int actline)
{			/* rotate log lines */
int i;
int line;

	if(actline < NUMLINES-1) return(actline+1);
	line = line_tab[0];
	for(i=0; i<NUMLINES-1; i++)
	{
		line_tab[i] = line_tab[i+1];
	}
	line_tab[NUMLINES-1] = line;
	return(NUMLINES-1);
}

int log(char *str)
{
int i;
char *s;
int len;
	
	if(!str) return(0);
	len = (int)strlen(str);
	log_text[line_tab[actline]][0] = 0;
	if(!len)
		actline = scroll_log(actline);
	s = log_text[line_tab[actline]];
	while(len > 0)
	{
		for(i=0; i <= LINESIZE; i++)
		{
			if(str[i] >= ' ') *s++ = str[i];
			if(!str[i]) break;
			len--;
		}
		*s=0;
		actline = scroll_log(actline);
		s = log_text[line_tab[actline]];
	}
	*s = 0;
	redraw_window(1);
	return(1);
}

/* -------------------------------------------------------------------- */
/*    open_window()                                                     */
/*                                                                      */
/*    ffnen eines Fensters                                             */
/* -------------------------------------------------------------------- */

void open_window( void )
{
   if(whandle <= 0)
   {
      whandle = wind_create( NAME|CLOSER|MOVER, 0, 0, max_x + 1, max_y + 1 );
      if( whandle <= 0 )
         return;

      wind_set ( whandle, WF_NAME, title );
      wind_open( whandle, 100, 100, WINW, WINH );
   }
   else
      wind_set( whandle, WF_TOP );
}

/* -------------------------------------------------------------------- */
/*    min()                                                             */
/*                                                                      */
/*    Minimum zweier Zahlen berechnen.                                  */
/* -------------------------------------------------------------------- */

int min( int a, int b)
{
   if( a > b )
      return( b );
   else
      return( a );
}

/* -------------------------------------------------------------------- */
/*    max()                                                             */
/*                                                                      */
/*    Maximum zweier Zahlen bestimmen.                                  */
/* -------------------------------------------------------------------- */

int max( int a, int b)
{
   if( a < b )
      return( b );
   else
      return( a );
}

/* -------------------------------------------------------------------- */
/*    rc_intersect()                                                    */
/*                                                                      */
/*    Schnittflche zweier Rechtecke berechnen.                         */
/* -------------------------------------------------------------------- */

int rc_intersect(GRECT *r1, GRECT *r2)
{
   int xl, yu, xr, yd;                      /* left, upper, right, down */

   xl      = max( r1->g_x, r2->g_x );
   yu      = max( r1->g_y, r2->g_y );
   xr      = min( r1->g_x + r1->g_w, r2->g_x + r2->g_w );
   yd      = min( r1->g_y + r1->g_h, r2->g_y + r2->g_h );

   r2->g_x = xl;
   r2->g_y = yu;
   r2->g_w = xr - xl;
   r2->g_h = yd - yu;

   return( r2->g_w > 0 && r2->g_h > 0 );
}

/* -------------------------------------------------------------------- */
/*    mouse_on()                                                        */
/*                                                                      */
/*    Mauszeiger anschalten.                                            */
/* -------------------------------------------------------------------- */

void mouse_on(void)

{
   graf_mouse( M_ON, (void *)0 );
}

/* -------------------------------------------------------------------- */
/*    mouse_off()                                                       */
/*                                                                      */
/*    Mauszeiger ausschalten.                                           */
/* -------------------------------------------------------------------- */

void mouse_off(void)
{
   graf_mouse( M_OFF, (void *)0 );
}

/* -------------------------------------------------------------------- */
/*    redraw_window()                                                   */
/*                                                                      */
/*    Fensterinhalt neu zeichnen, nachdem er zuvor aus irgendeinem      */
/*    Grunde zerstrt wurde, oder weil das Fenster neu geffnet wurde.  */
/* -------------------------------------------------------------------- */

void redraw_window( int all )
{
   GRECT   box,
           work;
   int     clip[4];
   int     line,dum;
   int 		height;
      
   if( whandle <= 0 )                  /* Wenn kein Fenster auf ist,    */
      return;                          /* braucht auch nicht gezeichnet */
                                       /* zu werden.                    */

   if(all)
   {

      mouse_off();

      vsf_color( handle, 0 );                       /* set white fill   */
      vswr_mode( handle, 1 );                       /* set replace mode */
      vst_height( handle, 6, &dum,&dum,&dum,&height);  /* set small font   */

      wind_get( whandle, WF_WORKXYWH, &work.g_x, &work.g_y, &work.g_w,
                &work.g_h );
      wind_get( whandle, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w,
                &box.g_h );
      work.g_w = min( work.g_w, max_x - work.g_x + 1 );
      work.g_h = min( work.g_h, max_y - work.g_y + 1 );
      
      while ( box.g_w > 0 && box.g_h > 0 )
      {
         if( rc_intersect( &work, &box ) )
         {
            clip[0] = box.g_x;
            clip[1] = box.g_y;
            clip[2] = box.g_x + box.g_w - 1;
            clip[3] = box.g_y + box.g_h - 1;

            vs_clip( handle, 1, clip );
            if( all )
               vr_recfl( handle, clip );
              /* fill rectangle */
            for(line=0;line < NUMLINES; line++)
            {
              v_gtext( handle, work.g_x, work.g_y + 15 + (line*height),log_text[line_tab[line]]);
            }
            
         }
         wind_get( whandle, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w,
                   &box.g_h );
      }
      mouse_on();
   }
}

/* -------------------------------------------------------------------- */
/*    handle_message()                                                  */
/*                                                                      */
/*    Auswertung der Ereignisse des Multi-Events bezglich des Message- */
/*    buffers.                                                          */
/* -------------------------------------------------------------------- */

int handle_message( int pipe[8] )
{
   switch ( pipe[0] )
   {
      case WM_REDRAW:
         redraw_window(1);
      break;

      case WM_TOPPED:
         wind_set( whandle, WF_TOP );
      break;

      case WM_CLOSED:
 
         if(_app)
         {
          closetcp();
          busy = 0;
      	 }
      	 if(busy > 0)
      	 {
      	 	break;
      	 }
         if(pipe[3] == whandle )
         {
            wind_close( whandle );
            wind_delete( whandle );
            whandle = 0;
         }
         if( _app )
            return(1);
      break;

      case WM_MOVED:
      case WM_SIZED:
         if( pipe[3] == whandle )
            wind_set( whandle, WF_CURRXYWH,  pipe[4], pipe[5],
                      pipe[6], pipe[7] );
      break;

      case AC_OPEN:
         if( pipe[4] == menu_id )
         {
            open_window();
         }
      break;

      case AC_CLOSE:
         if( pipe[3] == menu_id )
            whandle = 0;
      break;
   }
   return(0);
}

/* -------------------------------------------------------------------- */
/*    event_loop()                                                      */
/*                                                                      */
/*    Die Multi-Event-Schleife.                                         */
/* -------------------------------------------------------------------- */

static void event_loop( void )
{
   int x, y,
       kstate,
       key,
       clicks,
       event,
       state;
   int pipe[8];
   int quit;
   int timer;

   quit = 0;
   timer = 100;
   do
   {
      event = evnt_multi( MU_MESAG | MU_TIMER,
                          2, 0x1, 1,
                          0, 0, 0, 0, 0,
                          0, 0, 0, 0, 0,
                          pipe,
                          timer, 0,
                          &x, &y, &state, &kstate, &key, &clicks );


      if( event & MU_MESAG)
      {
	     wind_update(BEG_UPDATE);
         quit = handle_message( pipe );
    	 wind_update(END_UPDATE);
      }
		if(busy >= 0) switch(ftpserv(&ftp))
		{
			case -1:
				busy = -1;
				timer = 1000;
				break;
			
			case 0:
				busy = 0;
				/* do nothing */
				break;
				
			case 1:
				/* connection established */
				timer = 10;
				break;
				
			case 2:
				/* connection closed */
				busy = 0;
				ftp.username[0] = 0;
				ftp.logged_in = 0;
				ftp.ftp_ctl = 0;
				ftp.cmd = IDLE;
				timer = 500;
				break;

			case 3:
				/* connection busy */
				busy = 1;
				break;
		}
      


   }
   while (!quit);
}

/* -------------------------------------------------------------------- */
/*    main()                                                            */
/*                                                                      */
/*    Kernstck des Programms.                                          */
/* -------------------------------------------------------------------- */

int main( void )
{
   int i;
   int work_in[11];
   int work_out[57];
   time_t timer;
   char logstr[80];
   /* ----------------------------------------------------------------- */
   /* Initialization                                                    */
   /* ----------------------------------------------------------------- */

   appl_id = appl_init();
   if( appl_id != -1 )
   {
    cookie = get_cookie(INETCUSTCOOKIE);
    if(!cookie || (custom = (INETCUST *)(cookie->val)) == NULL)
    {
  	  printf("INETCUST not loaded!\n");
  	  if(_app)
  	  {
       appl_exit();
  	   exit(1);
  	  }
  	  else while(1) evnt_timer(0,1000);
    }

	if((fp_pass = fopen(custom->passwd,"r")) == NULL)
	{
		printf("Cannot find '%s'\n",custom->passwd);
  	    if(_app)
  	    {
          appl_exit();
  	      exit(1);
        }
   	    else while(1) evnt_timer(0,1000);
	}
	fclose(fp_pass);

	ftp.username[0] = 0;
	ftp.logged_in = 0;
	ftp.ftp_ctl = 0;
	ftp.cmd = IDLE;
	busy = 0;

	for(i=0; i< NUMLINES; i++)		/* init log table */
	{
  	  line_tab[i] = i;
   	  log_text[i][0] = 0;
   	}
   	actline = 0;

      for (i = 0; i < 10; i++)
         work_in[i]  = 1;
         work_in[10] = 2;
         phys_handle = graf_handle( &gl_wchar, &gl_hchar, &gl_wbox,
                                     &gl_hbox );
                                     
      handle = phys_handle;
      v_opnvwk( work_in, &handle, work_out );
      if( handle != 0 )
      {
         max_x = work_out[0];
         max_y = work_out[1];
         if( !_app )
         {
            menu_id = menu_register( appl_id, "  FTP-Server" );
         }
         else
         {
            graf_mouse( 0, (void*)0 );
            open_window();
         }

      sprintf(logstr,"FTP-Server %s running",FTP_VERSION);
      log(logstr);
      log(" (c) hw, pm ForTec 1992,1993");
      time(&timer);
      sprintf(logstr,"FTP-Server up at %s\n",ctime(&timer)); 
	  write_log(logstr);

   /* ----------------------------------------------------------------- */
   /* Event Loop                                                        */
   /* ----------------------------------------------------------------- */

         event_loop();

   /* ----------------------------------------------------------------- */
   /* Deinitialization                                                  */
   /* ----------------------------------------------------------------- */

		 ftp.cmd = QUIT;
		 ftpserv(&ftp);
         v_clsvwk( handle );
      }
      appl_exit();
   }
   return(0);
}



/* -------------------------------------------------------------------- */
/*    End of FTPSERV.C                                                   */
/* -------------------------------------------------------------------- */
