#include <stdio.h>
#include <sys/time.h>
#include <utime.h>

#define tv2time(t) ((t)->tv_sec + ((t)->tv_usec + 500000L) / 1000000L)

int
utimes (const char *fname, struct timeval tvp[2])
{
	struct utimbuf ubuf;

	if (tvp) {
		ubuf.actime  = tv2time (&tvp[0]);
		ubuf.modtime = tv2time (&tvp[1]);
	}
	return utime (fname, tvp ? &ubuf : NULL);
}
