/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <VDI.H>
#include <MINTBIND.H>
#include <memory.h>
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "C_WINDOW.H"
#include "EVENTS.H"
#include "rectlist.h"

#define max(x,y)	(((x)>(y))?(x):(y))
#define min(x,y)	(((x)<(y))?(x):(y))
/*
 *	Compute intersection of two rectangles; put result rectangle
 *	into *d; return TRUE if intersection is nonzero.
 *
 *	(Original version of this function taken from Digital Research's
 *	GEM sample application `DEMO' [aka `DOODLE'],  Version 1.1,
 *	March 22, 1985)
 */
short rc_intersect(const GRECT *s, GRECT *d)
{
	short x1,y1,x2,y2 ;

	x1 = max( s->g_x, d->g_x ) ;
	y1 = max( s->g_y, d->g_y ) ;
	x2 = min( s->g_x+s->g_w, d->g_x+d->g_w ) ;
	y2 = min( s->g_y+s->g_h, d->g_y+d->g_h ) ;
	d->g_x = x1 ;
	d->g_y = y1 ;
	d->g_w = x2 - x1 ;
	d->g_h = y2 - y1 ;
	return (x2 > x1) && (y2 > y1) ;
}

/*
	Rectangle List Generator 
	- generates a list of clipping rectangles for a given window.
	(Not a routine I'm proud of I'm afraid, but it seems to work ok)
	++cg[29/9/96]: as I've not managed to debug Johan's rect list stuff,
	here's a mod to my original algorithm that only does a single malloc....
*/

XA_RECT_LIST *generate_rect_list(XA_WINDOW *w)
{
	XA_WINDOW *wl;
	XA_RECT_LIST *rl,*rlist,*nrl,*cnrl,*rl_next;
	XA_RECT_LIST *free_list;
	GRECT r_ours,r_win;
	short win_cnt,f;

	DIAGS(("GenRectList:wind=%d\n",w->handle));

	if (w->rect_start)
	{
		DIAGS(("free existing list\n"));
		free(w->rect_start);
	}

	win_cnt=0;	
	for(wl=w->prev; wl; wl=wl->prev)
		win_cnt++;		

	DIAGS(("win_cnt=%d,allocate %d entries\n",win_cnt,win_cnt*6+2));

/* Block allocate the required space (approximately) */	
	w->rect_start=rlist=(XA_RECT_LIST*)malloc(sizeof(XA_RECT_LIST)*(win_cnt*6+2));
	rlist++;
	rlist->x=w->x;
	rlist->y=w->y;
	rlist->w=w->w;
	rlist->h=w->h;
	rlist->next=NULL;

	if (win_cnt)
	{
		DIAGS(("initialising free_list\n"));
		rl=free_list=rlist+1;
		for(f=0; f<win_cnt*6; f++)
		{
			DIAGS(("%d\n",f));
			free_list[f].next=&free_list[f+1];
		}
		free_list[win_cnt*6-1].next=NULL;
	
		Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);
	
		wl=w->prev;
		while(wl)
		{
			if (wl->is_open)
			{
				DIAGS(("Do Window %d @(%d,%d,%d,%d)\n",wl->handle,wl->x,wl->y,wl->w,wl->h));
				nrl=NULL;
				for(rl=rlist; rl; rl=rl_next)
				{
					DIAGS((" rl=[%d,%d,%d,%d]:",rl->x,rl->y,rl->w,rl->h));
					if (nrl)
					{
						DIAGS((" nrl=[%d,%d,%d,%d]\n",nrl->x,nrl->y,nrl->w,nrl->h));
					}else{
						DIAGS((" nrl=NULL\n"));
					}
						
					r_win.g_x=wl->x;
					r_win.g_y=wl->y;
					r_win.g_w=wl->w;
					r_win.g_h=wl->h;
		
					r_ours.g_x=rl->x;
					r_ours.g_y=rl->y;
					r_ours.g_w=rl->w;
					r_ours.g_h=rl->h;
				
					if(rc_intersect(&r_ours, &r_win))	/* if window intersects this rectangle, process */
					{
						DIAGS((" intersect=[%d,%d,%d,%d]\n",r_win.g_x,r_win.g_y,r_win.g_w,r_win.g_h));
				
		/* If window doesn't completely mask this rectangle, create new results */				
						if((r_ours.g_w!=r_win.g_w)||(r_ours.g_h!=r_win.g_h))
						{
							if(r_win.g_x!=r_ours.g_x)
							{
								cnrl=free_list; free_list=free_list->next;
								cnrl->x=r_ours.g_x;
								cnrl->y=r_ours.g_y;
								cnrl->w=r_win.g_x-r_ours.g_x;
								cnrl->h=r_ours.g_h;
								cnrl->next=nrl;
								DIAGS(("  Add_ra=[%d,%d,%d,%d]\n",cnrl->x,cnrl->y,cnrl->w,cnrl->h));
								nrl=cnrl;
							}
							if(r_win.g_x+r_win.g_w!=r_ours.g_x+r_ours.g_w)
							{
								cnrl=free_list; free_list=free_list->next;
								cnrl->x=r_win.g_x+r_win.g_w;
								cnrl->y=r_ours.g_y;
								cnrl->w=r_ours.g_x+r_ours.g_w-r_win.g_x-r_win.g_w;
								cnrl->h=r_ours.g_h;
								cnrl->next=nrl;
								DIAGS(("  Add_rb=[%d,%d,%d,%d]\n",cnrl->x,cnrl->y,cnrl->w,cnrl->h));
								nrl=cnrl;
							}
							if(r_win.g_y!=r_ours.g_y)
							{
								cnrl=free_list; free_list=free_list->next;
								cnrl->x=r_win.g_x;
								cnrl->y=r_ours.g_y;
								cnrl->w=r_win.g_w;
								cnrl->h=r_win.g_y-r_ours.g_y;
								cnrl->next=nrl;
								DIAGS(("  Add_rc=[%d,%d,%d,%d]\n",cnrl->x,cnrl->y,cnrl->w,cnrl->h));
								nrl=cnrl;
							}
							if(r_win.g_y+r_win.g_h!=r_ours.g_y+r_ours.g_h)
							{
								cnrl=free_list; free_list=free_list->next;
								cnrl->x=r_win.g_x;
								cnrl->y=r_win.g_y+r_win.g_h;
								cnrl->w=r_win.g_w;
								cnrl->h=r_ours.g_y+r_ours.g_h-r_win.g_y-r_win.g_h;
								cnrl->next=nrl;
								DIAGS(("  Add_rd=[%d,%d,%d,%d]\n",cnrl->x,cnrl->y,cnrl->w,cnrl->h));
								nrl=cnrl;
							}
						}else{
							DIAGS(("  Obscured - freeing\n"));
						}
						rl_next=rl->next;			/* release the original rectangle */
						rl->next=free_list;		/* add original rectangle to the free list */
						free_list=rl;
					}else{	/* Keep the current rectangle, it hasn't been changed */
						DIAGS(("  Disjoint - keeping\n"));
						rl_next=rl->next;
						rl->next=nrl;
						nrl=rl;
					}
				}
				rlist=nrl;
			}
			wl=wl->prev;
		}

		Psemaphore(3,WIN_LIST_SEMAPHORE,0L);
	}
	
	w->rect_list=w->rect_user=w->rect_start;
	
	if (rlist)
	{
		*(w->rect_start)=*rlist;
	}else{
		free(w->rect_start);
		w->rect_list=w->rect_user=w->rect_start=NULL;
	}	

#if GENERATE_DIAGS		
	DIAGS(("rect_list dump:\n"));
	for(rlist=w->rect_start; rlist; rlist=rlist->next)
		DIAGS(("{[%d,%d,%d,%d]@%lx,next=%lx}\n",rlist->x,rlist->y,rlist->w,rlist->h,rlist,rlist->next));
#endif
	
	
	return w->rect_start;
}

void dispose_rect_list(XA_WINDOW *w)
{
	if (w->rect_start)
	{
		DIAGS(("free rect list\n"));
		free(w->rect_start);
	}
	w->rect_start=w->rect_user=w->rect_list=NULL;
}


XA_RECT_LIST *rect_get_user_first(XA_WINDOW *w)
{
	DIAGS(("get_user_first(%d):",w->handle));
	w->rect_user=w->rect_start;

#if GENERATE_DIAGS
	if(w->rect_user)
	{
		DIAGS((" [%d,%d,%d,%d]\n",w->rect_user->x,w->rect_user->y,w->rect_user->w,w->rect_user->h));
	}else{
		DIAGS(("***WARNING: rect_get_user_first() with no available list\n"));
	}
#endif
	return w->rect_user;
}

XA_RECT_LIST *rect_get_user_next(XA_WINDOW *w)
{
	DIAGS(("get_user_next(%d)\n",w->handle));
	if (w->rect_user)
		w->rect_user=w->rect_user->next;

#if GENERATE_DIAGS
	if (w->rect_user)
	{
		DIAGS((" [%d,%d,%d,%d]\n",w->rect_user->x,w->rect_user->y,w->rect_user->w,w->rect_user->h));
	}else{
		DIAGS((" No more rects for %d\n",w->handle));
	}
#endif
	return w->rect_user;
}

XA_RECT_LIST *rect_get_system_first(XA_WINDOW *w)
{
	if (!w)
		return NULL;

	DIAGS(("get_system_first(%d):",w->handle));
	w->rect_list=w->rect_start;

#if GENERATE_DIAGS
	if(w->rect_list)
	{
		DIAGS((" [%d,%d,%d,%d]\n",w->rect_list->x,w->rect_list->y,w->rect_list->w,w->rect_list->h));
	}else{
		DIAGS(("***WARNING: rect_get_system_first() with no available list\n"));
	}
#endif
	return w->rect_list;
}

XA_RECT_LIST *rect_get_system_next(XA_WINDOW *w)
{
	if (!w)
		return NULL;

	DIAGS(("get_system_next(%d):",w->handle));
	DIAGS(("w->rect_list=%lx\n",w->rect_list));
	DIAGS(("next=%lx\n",w->rect_list->next));

	if (w->rect_list)
		w->rect_list=w->rect_list->next;

#if GENERATE_DIAGS
	if (w->rect_list)
	{
		DIAGS((" [%d,%d,%d,%d]\n",w->rect_list->x,w->rect_list->y,w->rect_list->w,w->rect_list->h));
	}else{
		DIAGS((" No more rects for %d\n",w->handle));
	}
#endif

	return w->rect_list;
}
	

