/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

void display_list_element(SCROLL_ENTRY *this,short x,short y,short w,short sel)
{
	short coords[4],temp;
	
	if (sel)
	{
		vsf_color(V_handle,BLACK);
		coords[0]=x-1;
		coords[1]=y+1;
		coords[2]=x+w-display.c_max_w-29;
		coords[3]=y+display.c_max_h;
		v_bar(V_handle, coords);
		vst_color(V_handle,WHITE);
		v_gtext(V_handle,x,y,this->text);
		vst_color(V_handle,BLACK);
		if (this->icon)
		{
			this->icon->ob_state|=SELECTED;
			display_object(this->icon,0,x-16,y);
			if (this->icon->ob_height>display.c_max_h)
				y+=this->icon->ob_height-display.c_max_h;
			vst_font(V_handle,display.standard_font_id);
			vst_point(V_handle,display.standard_font_point,&temp,&temp,&temp,&temp);
			vswr_mode(V_handle,MD_TRANS);
		}
	}else{
		v_gtext(V_handle,x,y,this->text);
		if (this->icon)
		{
			this->icon->ob_state&=~SELECTED;
			display_object(this->icon,0,x-16,y);
			if (this->icon->ob_height>display.c_max_h)
				y+=this->icon->ob_height-display.c_max_h;
			vst_color(V_handle,BLACK);
			vst_font(V_handle,display.standard_font_id);
			vst_point(V_handle,display.standard_font_point,&temp,&temp,&temp,&temp);
			vswr_mode(V_handle,MD_TRANS);
		}
	}
}

void d_g_slist(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	OBJC_COLORWORD *colourword;
	SCROLL_INFO *list;
	SCROLL_ENTRY *this;
	MFDB Mscreen;
	short border_thick=0,coords[8],x,y,maxy,temp;

	list=(SCROLL_INFO*)ob->ob_spec;
	colourword=(OBJC_COLORWORD*)&list->scrl_colour;
	
	set_colours(ob, colourword);
	vswr_mode(V_handle,MD_TRANS);

	if (!list->scrl_status)
	{
		if (ob->ob_flags&FLD3DANY)
		{
			XA_3D_pushbutton(odc_p->parent_x+ob->ob_x-1, odc_p->parent_y+ob->ob_y-1, ob->ob_width+1, ob->ob_height+1, ob->ob_state&SELECTED);
		}else{
			coords[0]=odc_p->parent_x+ob->ob_x;
			coords[1]=odc_p->parent_y+ob->ob_y;
			coords[2]=coords[0]+ob->ob_width-1;
			coords[3]=coords[1]+ob->ob_height-1;
			v_bar(V_handle, coords);

			if (border_thick)			/* Display a border? */
			{
				draw_2d_box(odc_p->parent_x+ob->ob_x, odc_p->parent_y+ob->ob_y, 
							ob->ob_width, ob->ob_height, 
							border_thick, colourword->borderc);
			}

		}
	}else{
		switch(list->scrl_status)
		{
			case SCRLSTAT_UP:
				Mscreen.fd_addr=NULL;
			
				coords[0]=coords[4]=odc_p->parent_x+ob->ob_x+4;
				coords[1]=odc_p->parent_y+ob->ob_y+display.c_max_h+4;
				coords[2]=coords[6]=odc_p->parent_x+ob->ob_x+ob->ob_width-display.c_max_w-5;
				coords[3]=odc_p->parent_y+ob->ob_y+ob->ob_height-1-display.c_max_h;
				coords[5]=coords[1]+display.c_max_h;
				coords[7]=coords[3]+display.c_max_h;
			
				vro_cpyfm(V_handle, S_ONLY, coords, &Mscreen, &Mscreen);

				x=odc_p->parent_x+ob->ob_x+21;
				y=odc_p->parent_y+ob->ob_y+5+display.c_max_h;

				coords[3]=coords[5]-1;
				v_bar(V_handle, coords);				

				display_list_element(list->scrl_dstart,x,y,ob->ob_width,(list->scrl_dstart==list->scrl_current));

				break;
				
			case SCRLSTAT_DOWN:
				Mscreen.fd_addr=NULL;
			
				coords[0]=coords[4]=odc_p->parent_x+ob->ob_x+4;
				coords[1]=odc_p->parent_y+ob->ob_y+5+2*display.c_max_h;
				coords[2]=coords[6]=odc_p->parent_x+ob->ob_x+ob->ob_width-display.c_max_w-5;
				coords[3]=odc_p->parent_y+ob->ob_y+ob->ob_height-4;
				coords[5]=coords[1]-display.c_max_h;
				coords[7]=coords[3]-display.c_max_h;
			
				vro_cpyfm(V_handle, S_ONLY, coords, &Mscreen, &Mscreen);

				coords[1]=coords[7];
				v_bar(V_handle, coords);				
		
				x=odc_p->parent_x+ob->ob_x+21;
				y=odc_p->parent_y+ob->ob_y+5;
				maxy=odc_p->parent_y+ob->ob_y+ob->ob_height-2*display.c_max_h;
	
				for(this=list->scrl_dstart; (this)&&(y<maxy); this=this->next)
				{
					y+=display.c_max_h;
					if (y>maxy-display.c_max_h)
						display_list_element(this,x,y,ob->ob_width,(this==list->scrl_current));
				}
				
				break;
		}
		
	}
	
	x=odc_p->parent_x+ob->ob_x+ob->ob_width-display.c_max_w-4;
	y=odc_p->parent_y+ob->ob_y;
	
	vsf_color(V_handle,display.dial_colours.bg_col);
	vsf_interior(V_handle,FIS_SOLID);

	XA_3D_pushbutton(odc_p->parent_x+ob->ob_x, y, ob->ob_width, display.c_max_h, FALSE);

	coords[0]=x-1;
	coords[1]=y+display.c_max_h;
	coords[2]=x+display.c_max_w+3;
	coords[3]=y+ob->ob_height-1;
	v_bar(V_handle, coords);

	XA_3D_pushbutton(x, y+display.c_max_h+1, display.c_max_w+4, display.c_max_h, list->scrl_status&SCRLSTAT_UP);
	XA_3D_pushbutton(x, y+ob->ob_height+1-display.c_max_h, display.c_max_w+4, display.c_max_h, list->scrl_status&SCRLSTAT_DOWN);
      
	vst_font(V_handle,display.standard_font_id);
	vst_point(V_handle,display.standard_font_point,&temp,&temp,&temp,&temp);

	vswr_mode(V_handle,MD_TRANS);
	vst_alignment(V_handle,1,5,&temp,&temp);
	v_gtext(V_handle,odc_p->parent_x+ob->ob_x+(ob->ob_width/2),odc_p->parent_y+ob->ob_y+1,list->scrl_title);
	vst_alignment(V_handle,0,5,&temp,&temp);
	v_gtext(V_handle,x+2,y+display.c_max_h+2,"");
	v_gtext(V_handle,x+2,y+ob->ob_height-display.c_max_h+1,"");
	

	if (!list->scrl_status)
	{
		x=odc_p->parent_x+ob->ob_x+21;
		y=odc_p->parent_y+ob->ob_y+5+display.c_max_h;
		maxy=odc_p->parent_y+ob->ob_y+ob->ob_height-display.c_max_h;
	
		for(this=list->scrl_dstart; (this)&&(y<maxy); this=this->next)
		{
			display_list_element(this,x,y,ob->ob_width,(this==list->scrl_current));
			y+=display.c_max_h;
		}
	}
}
