/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

void d_g_icon(ODC_PARM *odc_p);
/*
	Draw a colour icon
*/

void d_g_cicon(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	ICONBLK *iconblk;
	CICONBLK *ciconblk;
	CICON	*this_cicon;
	CICON	*best_cicon;
	MFDB Mscreen;
	MFDB Micon;
	short coords[8],cols[2],icx,icy;

	ciconblk=(CICONBLK*)ob->ob_spec;

	best_cicon=NULL; this_cicon=ciconblk->mainlist;
	while(this_cicon)
	{
		if ((this_cicon->num_planes<=display.planes)
			&&((!best_cicon)||(this_cicon->num_planes>best_cicon->num_planes)))
		{
				best_cicon=this_cicon;
		}
		
		this_cicon=this_cicon->next_res;	
	}
			
	if (!best_cicon)				/* No matching icon, so use the mono one instead */
	{
		d_g_icon(odc_p);
		return;
	}
	
	this_cicon=best_cicon;

	iconblk=(ICONBLK*)ob->ob_spec;

	icx=odc_p->parent_x+ob->ob_x+iconblk->ib_xicon;
	icy=odc_p->parent_y+ob->ob_y+iconblk->ib_yicon;
	
	coords[0]=coords[1]=0;
	coords[2]=iconblk->ib_wicon-1; coords[3]=iconblk->ib_hicon-1;
	coords[4]=icx; coords[5]=icy;
	coords[6]=icx+iconblk->ib_wicon-1; coords[7]=icy+iconblk->ib_hicon-1;
			
	Micon.fd_w=iconblk->ib_wicon;
	Micon.fd_h=iconblk->ib_hicon;
	Micon.fd_wdwidth=(Micon.fd_w+15)>>4;
	Micon.fd_nplanes=1;
	Micon.fd_stand=0;
	Mscreen.fd_addr=NULL;
			
	if (ob->ob_state&SELECTED)
	{
		Micon.fd_addr=this_cicon->sel_mask;
	}else{
		Micon.fd_addr=this_cicon->col_mask;
	}
	cols[0]=0; cols[1]=0;
	vrt_cpyfm(V_handle, MD_TRANS, coords, &Micon, &Mscreen, cols);

	if (ob->ob_state&SELECTED)
	{
		Micon.fd_addr=this_cicon->sel_data;
	}else{
		Micon.fd_addr=this_cicon->col_data;
	}
	Micon.fd_nplanes=display.planes;
	
	vro_cpyfm(V_handle, S_OR_D, coords, &Micon, &Mscreen);

}