#ifndef _OBJECTS_H_
#define _OBJECTS_H_

void init_objects(void);

/* Externally used routines */
void display_object(OBJECT *tree, short object, short parent_x,short parent_y);
short draw_object_tree(OBJECT *tree, short object, short depth);
short object_abs_coords(OBJECT *tree, short object, short *obx, short *oby);
short find_object(OBJECT *tree, short object, short depth, short obx, short oby);
void fix_menu(OBJECT *root);

/* Clipping stuff */
void set_clip(short x, short y, short w, short h);
void clear_clip(void);

/* Internal utility routines */
void set_colours(OBJECT *ob, OBJC_COLORWORD *colourword);
void shadow_object(OBJECT *ob, short parent_x, short parent_y, OBJC_COLORWORD *colourword, short border_thick);
short format_dialog_text(char *text_out, char *template, char *text_in,short edit_pos);
void draw_2d_box(short x, short y, short w, short h, short border_thick, short colour);
GRECT set_text(OBJECT *ob, OBJC_COLORWORD *colourword, short *border_thick, short parent_x, short parent_y);


#endif