/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <OSBIND.H>
#include <MINTBIND.H>
#include <SIGNAL.H>
#include <FILESYS.H>
#include <VDI.H>
#include <unistd.h>			/* getcwd() */
#include <stdlib.h>			/* free() */
#include <string.h>
#include <limits.h>			/* PATH/NAME_MAX */
#include "entries.h"			/* directory entry stuff */
#include "XA_TYPES.H"
#include "XA_CODES.H"
#include "XA_DEFS.H"
#include "XA_GLOBL.H"
#include "OBJECTS.H"
#include "FRM_ALRT.H"
#include "STD_WIDG.H"
#include "C_WINDOW.H"
#include "RECTLIST.H"
#include "SYSTEM.H"
#include "RESOURCE.H"
#include "SCRLOBJC.H"
#include "K_DEFS.H"
#include "graf_mou.h"

/*
	FILE SELECTOR IMPLEMENTATION
	
	This give a non-modal windowed file selector for internal
	and exported use, with slightly extended pattern matching
	from the basic GEM spec.
*/

short fs_destructor(XA_WINDOW *wind);

XA_WINDOW *fs_open=NULL;
FileSelectedCallback selected=NULL;
FileSelectedCallback cancelled=NULL;
char fs_path[PATH_MAX];
char fs_pattern[NAME_MAX*2];
char fs_internal_filter[NAME_MAX*2];
char fs_internal_file[NAME_MAX];


/*
	Re-load a file list object
*/
void refresh_filelist(void)
{
	Entry *first;
	Lists *lists;
	char **dirs, **files;
	OBJECT *form=ResourceTree(system_resources,FILE_SELECT);
	OBJECT *sl,*temp;
	SCROLL_INFO *si;
	SCROLL_ENTRY *entry;

	DIAGS(("refresh_filelist:fs_path='%s',fs_pattern='%s'\n",fs_path,fs_pattern));
	sl=form+FS_LIST;
	si=(SCROLL_INFO*)sl->ob_spec;

	if (fs_open)					/* Clear out current file list contents */
	{
		free(si->scrl_start);
		free_entries();
	}

	graf_mouse(HOURGLASS,NULL);
	
	first = read_entries(fs_path);		/* Read new directory */

	DIAGS(("entries have been read:first=\n",first));

	if(!(lists = sort_entries(fs_pattern)))	/* Sort directory */
	{
		graf_mouse(ARROW,NULL);
		return;
	}
	
	si->scrl_start=(SCROLL_ENTRY*)malloc(sizeof(SCROLL_ENTRY)*(lists->num_dirs+lists->num_files));
	entry=si->scrl_start;

	temp=form+FS_ICN_DIR;
	temp->ob_x=temp->ob_y=0; temp->ob_flags|=HIDETREE;
	temp=form+FS_ICN_EXE;
	temp->ob_x=temp->ob_y=0; temp->ob_flags|=HIDETREE;

	DIAGS(("entries have been sorted\n"));
	
	DIAGS(("DIRS:\n"));
	
	dirs = lists->dirs;
	while(*dirs)					/* Stick directorys at top of list */
	{
		entry->icon=form+FS_ICN_DIR;
		entry->text=*(dirs++);
		DIAGS(("%s\n",entry->text));
		entry->next=entry+1;
		entry->prev=entry-1;
		entry++;
	}

	DIAGS(("FILES:\n"));

	files = lists->files;
	while(*files)					/* Add files after directorys */
	{
		entry->text=*files;
		if (((Entry *)*files - 1)->flags&FLAG_EXECUTABLE)
		{
			entry->icon=form+FS_ICN_EXE;
		}else{
			entry->icon=NULL;
		}
		DIAGS(("%s\n",entry->text));
		entry->next=entry+1;
		entry->prev=entry-1;
		files++;
		entry++;
	}
	si->scrl_start->prev=NULL;
	(--entry)->next=NULL;
	
	si->scrl_dstart=si->scrl_current=si->scrl_start;

	graf_mouse(ARROW,NULL);
	
}

static char null_file[]="NONAME.XXX";

short __stdargs fs_click(OBJECT *form, short objc)
{
	SCROLL_INFO *list;
	OBJECT *ob=form+objc;
	char *current_filename;
	Entry *current_entry;
		
	list=(SCROLL_INFO*)ob->ob_spec;
	
	if (list->scrl_current)
	{
		current_filename=list->scrl_current->text;
		current_entry=(Entry *)current_filename - 1;

		if (!(current_entry->flags & FLAG_DIR))
		{
			strcpy(fs_internal_file,current_filename);
			v_hide_c(V_handle);
			draw_object_tree(form, FS_FILE, 1);
			v_show_c(V_handle,1);
		}
	}
	
	return TRUE;
}			

	
short __stdargs fs_dclick(OBJECT *form, short objc)
{
	SCROLL_INFO *list;
	OBJECT *ob=form+objc;
	char *current_filename;
	Entry *current_entry;
	XA_WINDOW *wl;
	GRECT r;
		
	list=(SCROLL_INFO*)ob->ob_spec;

	if (list->scrl_current)
	{
		current_filename=list->scrl_current->text;
		current_entry=(Entry *)current_filename - 1;

		if (current_entry->flags & FLAG_DIR)
		{			
			if (current_filename[0]!='.')
			{
				if (fs_path[strlen(fs_path)-1]!='/')		
					strcat(fs_path,"/");
				strcat(fs_path,current_filename);
				refresh_filelist();
				v_hide_c(V_handle);
				draw_object_tree(form, FS_LIST, 1);
				v_show_c(V_handle,1);
			}else{
				if (current_filename[1]=='.')
				{
					short s,l=strlen(fs_path);
					s=l; 
					while(fs_path[--s]!='/');
					if (s>2)
					{
						fs_path[s]='\0';
					}else{
						fs_path[3]='\0';
					}
					refresh_filelist();
					v_hide_c(V_handle);
					draw_object_tree(form, FS_LIST, 1);
					v_show_c(V_handle,1);
				}
			}
			
			return TRUE;
			
		}
		
		if (selected)
				(*selected)(fs_path,fs_internal_file);
				
	}else{
		if (selected)
			(*selected)(fs_path,null_file);
	}

	wl=fs_open->next;
	
	r.g_x=fs_open->x;	r.g_y=fs_open->y;
	r.g_w=fs_open->w;	r.g_h=fs_open->h;

	fs_open->is_open=FALSE;
	send_wind_to_bottom(fs_open);
	delete_window(fs_open);

	v_hide_c(V_handle);
	display_windows_below(&r,wl);
	v_show_c(V_handle,1);
			
	return TRUE;
}

void handle_fileselector(ODC_PARM *odc_p)
{
	short s,l=strlen(fs_path);
	TEDINFO *filter=(TEDINFO*)(odc_p->tree+FS_FILTER)->ob_spec;
	GRECT r;
	XA_WINDOW *wl;
	
	switch(odc_p->object)
	{
		case FS_UPDIR:			/* Go up a level in the filesystem */
			s=l=strlen(fs_path);
			while(fs_path[--s]!='/');
			if (s>2)
			{
				fs_path[s]='\0';
			}else{
				fs_path[3]='\0';
			}
			refresh_filelist();
			v_hide_c(V_handle);
			draw_object_tree(odc_p->tree, FS_LIST, 1);
			v_show_c(V_handle,1);
			break;
		case FS_OK:							/* Accept current selection - do the same as a double click */
			if (strcmp(filter->te_ptext,fs_pattern))
			{
				strcpy(fs_pattern,filter->te_ptext);
				refresh_filelist();
				v_hide_c(V_handle);
				draw_object_tree(odc_p->tree, FS_LIST, 1);
				v_show_c(V_handle,1);
			}else{
				fs_dclick(odc_p->tree,FS_LIST);
			}
			break;
		case FS_CANCEL:					/* Cancel this selector */
			if (cancelled)
				(*cancelled)(fs_path,"");

			wl=fs_open->next;
			r.g_x=fs_open->x;	r.g_y=fs_open->y;
			r.g_w=fs_open->w;	r.g_h=fs_open->h;

			fs_open->is_open=FALSE;
			send_wind_to_bottom(fs_open);
			delete_window(fs_open);

			v_hide_c(V_handle);
			display_windows_below(&r,wl);
			v_show_c(V_handle,1);
			break;
	}
}

void open_fileselector(char *path, char *title, FileSelectedCallback s, FileSelectedCallback c)
{
	SCROLL_INFO *list;
	OBJECT *form=ResourceTree(system_resources,FILE_SELECT);
	TEDINFO *filter;
	XA_WINDOW *dialog_window;
	XA_WIDGET_LOCATION dialog_toolbar_loc={LT,3,0};
	XA_WIDGET_LOCATION dialog_menu_loc={LT,16,0};
	short x,y,w,h;
	char *pat;

	DIAGS(("open_fileselector(%s,%s,%lx)\n",path,title,s));
	
	if (fs_open)
		return;
	
	selected=s;
	cancelled=c;
		
	dialog_menu_loc.y=display.c_max_h+1;
	dialog_toolbar_loc.y=dialog_menu_loc.y+display.c_max_h+1;

	filter=(TEDINFO*)(form+FS_FILTER)->ob_spec;
	filter->te_ptext=fs_internal_filter;
	filter->te_txtlen=NAME_MAX*2;
	((TEDINFO*)(form+FS_FILE)->ob_spec)->te_ptext=fs_internal_file;
	
	form->ob_x=(display.w-form->ob_width)/2;
	form->ob_y=(display.h-form->ob_height)/2;

	strcpy(fs_path,path);

/* Strip out the pattern description */
	for(pat=fs_path+strlen(fs_path); (pat>fs_path)&&(*pat!='/'); pat--);
	if (pat>fs_path)
	{
		*pat++='\0';
		strcpy(fs_pattern,pat);
	}else{
		fs_pattern[0]='*';
		fs_pattern[1]='\0';
	}

	fs_internal_file[0]='\0';
	
	refresh_filelist();

	DIAGS(("Refreshed file list\n"));

/* Create a temporary window to work out sizing */
	dialog_window=create_window(AESpid, NAME|MOVE, form->ob_x, form->ob_y, form->ob_width, form->ob_height);

	x=2*dialog_window->x - dialog_window->wx;
	y=2*dialog_window->y - dialog_window->wy;
	w=2*dialog_window->w - dialog_window->ww +1;
	h=2*dialog_window->h - dialog_window->wh +1;

/* Dispose of the temporary window we created */
	delete_window(dialog_window);

/* Now create the real window */
	dialog_window=create_window(AESpid, NAME|MOVE|NO_MESSAGES|NO_WORK, x, y, w, h);

	dialog_window->created_by_FMD_START=FALSE;

/* Set the window title */
	dialog_window->widgets[XAW_TITLE].stuff=title;
	
/* Set the window destructor */
	dialog_window->destructor=&fs_destructor;

/* Set the menu widget */
#if 0
	set_menu_widget(dialog_window, dialog_menu_loc, (OBJECT*)ResourceTree(system_resources, FSEL_MENU));
#endif

/* Set the main dialog widget */
	dialog_toolbar_loc.y=display.c_max_h+10;
	set_toolbar_widget(dialog_window, dialog_toolbar_loc, form);
	
	list=(SCROLL_INFO*)(form+FS_LIST)->ob_spec;
	list->scrl_f_dclick=&fs_dclick;					/* Set the scroll lists double click callback */
	list->scrl_f_click=&fs_click;					/* Set the scroll lists click callback */
	
	list->scrl_title=fs_path;
	
	((XA_WIDGET_TREE*)dialog_window->widgets[XAW_TOOLBAR].stuff)->owner=AESpid;
	((XA_WIDGET_TREE*)dialog_window->widgets[XAW_TOOLBAR].stuff)->handler=&handle_fileselector;

	strcpy(fs_internal_filter,fs_pattern);
	
	dialog_window->is_open=TRUE;

	v_hide_c(V_handle);
	pull_wind_to_top(dialog_window);
	DIAGS(("calling display_window()\n"));
	display_window(dialog_window);
	v_show_c(V_handle,1);
	
	DIAGS(("done.\n"));
	
	fs_open=dialog_window;

}

short fs_destructor(XA_WINDOW *wind)
{
	OBJECT *form=ResourceTree(system_resources,FILE_SELECT);
	OBJECT *sl;
	SCROLL_INFO *si;

	sl=form+FS_LIST;
	si=(SCROLL_INFO*)sl->ob_spec;
	
	free(si->scrl_start);
	si->scrl_start=si->scrl_current=si->scrl_dstart=NULL;
	free_entries();
	fs_open=NULL;
	selected=NULL;
	
	return TRUE;
}
