UNIT VESA;

INTERFACE

uses DOS;

Type
	info=record
		VESAVersion  :String[3];  { VESA version number}
		OEMString    :String;     { OEM string}
	end;
	VESAinf = RECORD
					firma    : ARRAY [0..3] OF CHAR; (* Cadena 'VESA' *)
					subrev   : BYTE;                 (* Nmero de subrevisin *)
					rev      : BYTE;                 (* Nmero de revisin *)
					OEMName  : ^CHAR;                (* Puntero a la cadena de identificacin *)
					capab    : ARRAY [0..3] OF BYTE; (* Capabilities *)
					modos    : ^WORD;                (* Puntero a la lista de modos soportados *)
					vmem     : WORD;                 (* Tamao de memoria de video, en bloques de 64k *)
				 END;

  (* Estructura para almacenar la informacin sobre modos *)
  modeinf = RECORD
					atributos : WORD;   (* Atributos del modo *)
					atrwinA   : BYTE;   (* Atributos de la ventana A *)
					atrwinB   : BYTE;   (* Atributos de la ventana B *)
					gran      : WORD;   (* Granularidad de las ventanas *)
					tamwin    : WORD;   (* Tamao de la ventana *)
					segwinA   : WORD;   (* Segmento de comienzo de la ventana A *)
					segwinB   : WORD;   (* Segmento de comienzo de la ventana B *)
					winpos    : ^BYTE;  (* Puntero a funcin de posicionamiento de ventana *)
					bytes     : WORD;   (* Bytes / Scan line *)
					(* Para modos OEM *)
					width     : WORD;   (* Ancho de la pantalla *)
					height    : WORD;   (* Alto de la pantalla *)
					charwidth : BYTE;
					charheight: BYTE;
					planos    : BYTE;   (* Nmero de planos *)
					bits      : BYTE;   (* Bits por pixel *)
					bancos    : BYTE;
					mmtype    : BYTE;   (* Modelo de memoria *)
					banksize  : BYTE;
				 END;
Var
	reshor,resver:Longint;

	OEMinfo:info;
	VESAInfo:VESAInf;
	ModeInfo:ModeInf;

Function info_vesa:Boolean;


Procedure info_mode(modo:Word);


Procedure setcolor(col:Byte);


Procedure setfillcolor(col:Byte);


Procedure setmode(modo:word);


procedure setpal(col,r,g,b : byte);


procedure putpixel(xp,yp : LongInt; col : Word);


Procedure line(x,y,x2,y2:Integer);


Procedure rectangle(x,y,x2,y2:Integer);


Procedure bar(xx,yy,xx2,yy2:Integer);


IMPLEMENTATION

uses crt;



Const
	base:Word=$A000;

Var
	color_activo:Byte;
	color_fill:Byte;
	pagina_ant:Word;

Function info_vesa:Boolean;

Var
	reg:registers;
	segmen,off,auxseg,auxoff:Word;
	caracter:String;
	auxchar:Char;
	i:Byte;

BEGIN
	reg.ax:=$4F00;
	reg.es:=seg(VESAInfo);
	reg.di:=ofs(VESAInfo);
	intr($10,reg);
   pagina_ant:=255;
	if (reg.ax=1) then info_vesa:=false
	else
		begin
			segmen:=seg(VESAInfo);
			off:=ofs(VESAInfo);
			{*VESA SIGNATURE*}
			caracter:=chr(mem[segmen:off]);
			caracter:=caracter+chr(mem[segmen:off+1]);
			caracter:=caracter+chr(mem[segmen:off+2]);
			caracter:=caracter+chr(mem[segmen:off+3]);
			if caracter<>'VESA' then info_vesa:=False
			else
				Begin
					info_vesa:=True;
					{*VESA VERSION NUMBER*}
					OEMInfo.VESAVersion:=chr(mem[segmen:off+5]+48) + '.' + chr(mem[segmen:off+4]+48);
					{*VESA OEM STRING*}
					auxoff:=mem[segmen:off+6] + (mem[segmen:off+7] shl 8);
					auxseg:=mem[segmen:off+8] + (mem[segmen:off+9] shl 8);
					i:=1;
					while mem[auxseg:auxoff+i]<>13 do
						begin
							auxchar:=chr(mem[auxseg:auxoff+i]);
							OEMInfo.OEMString:=OEMInfo.OEMString + auxchar;
							i:=i+1;
						end;


				end;
		end;
END;


Procedure info_mode (modo:Word);


VAR
	regs      : Registers;

 BEGIN
	regs.ax := $4F01;
	regs.cx := modo;
	regs.di := Ofs(ModeInfo);
	regs.es := Seg(ModeInfo);
	intr($10,regs);
 END;




Procedure setcolor(col:Byte);

BEGIN
	if col in [0..255] then
		color_activo:=col;
END;

Procedure setfillcolor(col:Byte);

BEGIN
	if col in [0..255] then
		color_fill:=col;
END;



Procedure setmode(modo:word);

Var
	rrx,ry:Word;

BEGIN
	case modo of
	$100:begin
			reshor:=640;
			resver:=400;
	end;

	$101:begin
			reshor:=640;
			resver:=480;
	end;

	$102,$103:begin
			reshor:=800;
			resver:=600;
	end;

	$104,$105:begin
			reshor:=1024;
			resver:=768;
	end;

	$13:begin
			reshor:=320;
			resver:=200;
	end;

	end;
	rrx:=reshor;
	ry:=resver;

	asm
		mov ah,4Fh
		mov al,02h
		mov bx,modo
		int $10
      mov ah,4Fh
		mov al,06h
		mov bl,00h
		mov cx,rrx
		int $10
	end;

END;


procedure setpal(col,r,g,b : byte); assembler;
	asm
		mov dx,03c8h
		mov al,col
		out dx,al
		inc dx
		mov al,r
		out dx,al
		mov al,g
		out dx,al
		mov al,b
		out dx,al
	end;


procedure putpixel(xp,yp : LongInt; col : word);

Var
	offsbestia:Longint;
	offs:Word;
	pagina:word;
	salta:Byte;

BEGIN
	offsbestia:=yp*reshor + xp;
	pagina:=(offsbestia shr 16);
	offs:=offsbestia and $FFFF;
	if pagina_ant<>pagina then
	asm
		mov dx,pagina        {*CAMBIO PAGINA*}
		mov pagina_ant,dx
		mov ax,4F05h
		mov bx,0001h
		int 10h
	end;
	mem[base:offs]:=col;
END;

Procedure line(x,y,x2,y2:Integer);

Var

	a1,a2:Integer;
	p:Real;
	c:Integer;

BEGIN
	a1:=abs(x-x2);
	a2:=abs(y-y2);
	case (a1>a2) of
	TRUE:begin
			p:=a2/a1;
			for c:=x to x2 do
				putpixel(c,round(c*p),color_activo);
	end;

	FALSE:begin
			p:=a1/a2;
			for c:=y to y2 do
				putpixel(round(c*p),c,color_activo);
	end;
	end;
END;

Procedure rectangle(x,y,x2,y2:Integer);

Var
	i:Integer;


BEGIN

	for i:=x to x2 do
		putpixel(i,y,color_activo);
	for i:=y to y2 do
		putpixel(x,i,color_activo);
	for i:=x to x2 do
		putpixel(i,y2,color_activo);
	for i:=y to y2 do
		putpixel(x2,i,color_activo);
END;

Procedure bar(xx,yy,xx2,yy2:Integer);

Var
	i,j:Integer;
	offsbestia:Longint;
	offsbest:Longint;
	offs:Word;
	pagina:word;
	salta:Byte;
	a,b:Longint;

BEGIN
	for i:=yy to yy2 do
		begin
			offsbest:=i*reshor;
			a:=offsbest+xx;
			b:=offsbest+xx2;
			for offsbestia:=a to b do
				begin
					pagina:=(offsbestia shr 16);
					offs:=(offsbestia and $FFFF);
					if pagina<>pagina_ant then
						asm
						mov dx,pagina         {*CAMBIO PAGINA*}
						mov pagina_ant,dx
						mov ax,4F05h
						mov bx,0001h
						int 10h
						end;

					mem[base:offs]:=color_fill;
				end;
		end;
END;

BEGIN
	pagina_ant:=255;
END.