REM PROGRAMA DE DEMOSTRACION 14
REM ROTACION DE UNA ESFERA EN TRES DIMENSIONES
REM CON ELIMINACION DE SUPERFICIES OCULTAS
REM POR EL METODO DEL VECTOR NORMAL AL PLANO

REM CONTROLES:
REM Q, A: ROTAR EN EL EJE X
REM P, O: ROTAR EN EL EJE Y
REM K, L: ROTAR EN EL EJE Z
REM R: SOMBREAR
REM S: TERMINAR

REM INDICA CUAL ES LA TARJETA GRAFICA QUE PREFIERES EN LA VARIABLE TARJETA:
REM 1=CGA 2 COLORES (640 x 200 puntos)
REM 2=EGA 16 COLORES (640 x 350 puntos)
REM 3=MCGA/VGA/SVGA 2 COLORES (640 x 480 puntos)
REM 4=AT&T 2 COLORES (640 x 400 puntos)
REM 5=HERCULES 2 COLORES (720 x 348 puntos)
REM Para usar la tarjeta HERCULES, ejecutar antes desde DOS
REM la controladora de dispositivos MSHERC.COM

TARJETA = 1
GOSUB PREPARAR

REM LA VARIABLE RELAS INDICA LA RELACION DE ASPECTO DEL DISPOSITIVO DE SALIDA

RELAS = 3 / 4
IF RELAS <= 1 THEN
     REX = 480 / RELAS
     REY = 480
ELSE
     REX = 480
     REY = 480 * RELAS
END IF

RELX = XMAX / REX
RELY = YMAX / REY


REM INCR ES EL INCREMENTO POR ROTACION

INCR = 3.141592 / 18

REM ESTAS VARIABLES SE USAN PARA LA SIMULACION DE LA PILA O STACK
REM DEL FILL

DIM PILA(1000, 1)
PUNTERO = 0

REM D ES LA DISTANCIA DESDE EL OBSERVADOR A LA PANTALLA EN PIXELS

D = 1000

REM INICIO

REM ESTOS SON LOS DATOS QUE DEFINEN A LA ESFERA:
REM RADIO1: RADIO EN EL EJE Y (ALTURA)
REM RADIO2: RADIO EN EL EJE X (ANCHURA)
REM RADIO3: RADIO EN EL EJE Z (PROFUNDIDAD)
REM PASO: NUMERO DE LADOS PARA LAS BASES

RADIO1 = 200
RADIO2 = 200
RADIO3 = 200
PASO = 26

REM CALCULAMOS LAS CONSTANTES

PI = 3.1416 / 180
TOTV = 2 + PASO * ((PASO / 2) - 1)
DIM V(TOTV, 2)
CUENTA = 2
PASO2 = 360 / PASO

REM CALCULAMOS EL VERTICE INFERIOR Y EL SUPERIOR DE LA ESFERA

V(0, 0) = 0
V(0, 1) = RADIO1
V(0, 2) = 0
V(1, 0) = 0
V(1, 1) = -RADIO1
V(1, 2) = 0

REM CALCULAMOS LA ALTURA DE CADA CINTURON DE PUNTOS

PRINT "CALCULANDO LOS PUNTOS"
PRINT "UN MOMENTO, POR FAVOR"
FOR F = PASO2 TO 180 - (PASO2 / 2) STEP PASO2
     GRADO2 = F * PI
     RADIOS2 = RADIO2 * SIN(GRADO2)
     RADIOS3 = RADIO3 * SIN(GRADO2)
     ALT2 = RADIO1 * COS(GRADO2)

REM CALCULAMOS LOS VERTICES DEL CINTURON

FOR N = 0 TO 360 - (PASO2 / 2) STEP PASO2
     GRADO = N * PI
     V(CUENTA, 0) = RADIOS2 * SIN(GRADO)
     V(CUENTA, 1) = ALT2
     V(CUENTA, 2) = RADIOS3 * COS(GRADO)
     CUENTA = CUENTA + 1
NEXT N
NEXT F

CLS
PRINT "CALCULANDO LAS CARAS"
PRINT "UN MOMENTO, POR FAVOR"

TOTL = PASO * INT(PASO / 2)
DIM L%(TOTL, PASO)

REM CALCULAMOS LOS LADOS DE LA BASE
    
FOR N = 0 TO PASO - 1
     SIG = N + 1
     IF N = PASO - 1 THEN
	  SIG = 0
     END IF
     L%(N, 0) = 3
     L%(N, 1) = 0
     L%(N, 2) = SIG + 2
     L%(N, 3) = N + 2
NEXT N

REM ASIGNAMOS LOS VERTICES A LOS LADOS

FOR F = 0 TO (INT(PASO / 2)) - 3
     FOR N = 0 TO PASO - 1
	  SIG = N + 1
	  IF SIG = PASO THEN
	       SIG = 0
	  END IF
	  CUENTA = N + PASO + F * PASO
	  L%(CUENTA, 0) = 4
	  L%(CUENTA, 1) = SIG + F * PASO + 2
	  L%(CUENTA, 2) = SIG + PASO + F * PASO + 2
	  L%(CUENTA, 3) = N + PASO + F * PASO + 2
	  L%(CUENTA, 4) = N + F * PASO + 2
     NEXT N
NEXT F

REM CALCULAMOS LOS LADOS DE LA BASE SUPERIOR
F = PASO * ((INT(PASO / 2)) - 2)
CUENTA = CUENTA + 1
FOR N = 0 TO PASO - 1
     SIG = N + 1
     IF N = PASO - 1 THEN
	  SIG = 0
     END IF
     L%(N + CUENTA, 0) = 3
     L%(N + CUENTA, 1) = 1
     L%(N + CUENTA, 2) = N + 2 + F
     L%(N + CUENTA, 3) = SIG + 2 + F
NEXT N
DIM C(TOTV, 1)

REM BUCLE PRINCIPAL

FOR N = 0 TO TOTV - 1
     GOSUB ECUACION
     C(N, 0) = X
     C(N, 1) = Y
NEXT N

A$ = INKEY$
WHILE A$ <> "S" AND A$ <> "s"

     CLS
     PRINT "(C) 1994 RASTER SOFT."
     FOR N = 0 TO TOTL - 1
	  LNUM = L%(N, 0)
	 
	  REM CALCULO LAS COORDENADAS DE DOS VECTORES CONSECUTIVOS
	  REM DE LA CARA A TESTEAR

	  X1 = V(L%(N, 2), 0) - V(L%(N, 1), 0)
	  Y1 = V(L%(N, 2), 1) - V(L%(N, 1), 1)
	  Z1 = V(L%(N, 2), 2) - V(L%(N, 1), 2)
	  X2 = V(L%(N, 3), 0) - V(L%(N, 2), 0)
	  Y2 = V(L%(N, 3), 1) - V(L%(N, 2), 1)
	  Z2 = V(L%(N, 3), 2) - V(L%(N, 2), 2)
	 
	  REM CALCULO LAS COORDENADAS DEL VECTOR NORMAL
	  REM POR MEDIO DEL PRODUCTO VECTORIAL
	 
	  X = (Y1 * Z2) - (Y2 * Z1)
	  Y = (Z1 * X2) - (Z2 * X1)
	  Z = (X1 * Y2) - (X2 * Y1)
       
	  REM CALCULAMOS LAS COORDENADAS DEL VECTOR DE VISION, QUE UNE
	  REM EL OJO CON EL PRIMER VERTICE DE LA CARA

	  X1 = V(L%(N, 1), 0)
	  Y1 = V(L%(N, 1), 1)
	  Z1 = V(L%(N, 1), 2) + D

	  REM CALCULAMOS EL PRODUCTO ESCALAR DEL VECTOR NORMAL A LA
	  REM CARA CON EL VECTOR DE VISION
 
	  ESCALAR = (X * X1) + (Y * Y1) + (Z * Z1)
	 
	  REM Y APLICAMOS EL TEST DE VISIBILIDAD
	  
	  IF ESCALAR > 0 THEN
	       FOR F = 1 TO LNUM
		    SIGUIE = F + 1
		    IF F = LNUM THEN SIGUIE = 1
		    XI = C(L%(N, F), 0)
		    YI = C(L%(N, F), 1)
		    XF = C(L%(N, SIGUIE), 0)
		    YF = C(L%(N, SIGUIE), 1)
		    COLORES = NUMCOLOR - 1
		    GOSUB PINTAR
	       NEXT F
	  END IF
     NEXT N
    
     A$ = INKEY$
     WHILE A$ = ""
	 A$ = INKEY$
     WEND
     PRINT "ROTANDO"
     IF A$ = "A" OR A$ = "a" THEN
	  AX = INCR
	  GOSUB ROTX
     END IF
     IF A$ = "Q" OR A$ = "q" THEN
	  AX = -INCR
	  GOSUB ROTX
     END IF
     IF A$ = "P" OR A$ = "p" THEN
	  AY = INCR
	  GOSUB ROTY
     END IF
     IF A$ = "O" OR A$ = "o" THEN
	  AY = -INCR
	  GOSUB ROTY
     END IF
     IF A$ = "L" OR A$ = "l" THEN
	  AZ = INCR
	  GOSUB ROTZ
     END IF
     IF A$ = "K" OR A$ = "k" THEN
	  AZ = -INCR
	  GOSUB ROTZ
     END IF
WEND
END
   
REM CALCULAMOS LAS ROTACIONES PARA CADA UNO DE LOS VERTICES
  
ROTX:
     A$ = ""
     SA = SIN(AX)
     CA = COS(AX)
     FOR N = 0 TO TOTV - 1
	  C1 = V(N, 1)
	  C2 = V(N, 2)
	  GOSUB ROTAR
	  V(N, 1) = C1
	  V(N, 2) = C2
	  GOSUB ECUACION
	  C(N, 0) = X
	  C(N, 1) = Y
     NEXT N
     AX = 0
     RETURN
       
ROTY:
     A$ = ""
     SA = SIN(AY)
     CA = COS(AY)
     FOR N = 0 TO TOTV - 1
	  C1 = V(N, 0)
	  C2 = V(N, 2)
	  GOSUB ROTAR
	  V(N, 0) = C1
	  V(N, 2) = C2
	  GOSUB ECUACION
	  C(N, 0) = X
	  C(N, 1) = Y
     NEXT N
     AY = 0
     RETURN

ROTZ:
     A$ = ""
     SA = SIN(AZ)
     CA = COS(AZ)
     FOR N = 0 TO TOTV - 1
	  C1 = V(N, 0)
	  C2 = V(N, 1)
	  GOSUB ROTAR
	  V(N, 0) = C1
	  V(N, 1) = C2
	  GOSUB ECUACION
	  C(N, 0) = X
	  C(N, 1) = Y
     NEXT N
     RETURN

REM SUBRUTINA DE PROYECCION PARA PASAR DE 3D A 2D

ECUACION:
     X = (V(N, 0) * D) / (V(N, 2) + D) + REX / 2
     Y = (V(N, 1) * D) / (V(N, 2) + D) + REY / 2
     RETURN

REM SUBRUTINA DE ROTACION

ROTAR:
     ALFA = C1 * CA - C2 * SA
     C2 = C1 * SA + C2 * CA
     C1 = ALFA
     RETURN

PINTAR:
 
     LINE (XI * RELX, YI * RELY)-(XF * RELX, YF * RELY), COLORES
     RETURN

PREPARAR:
 
     ON TARJETA GOSUB CGA, EGA, MCGA, ATT, HERCULES
     CLS
     RETURN

CGA:
     XMAX = 640
     YMAX = 200
     SCREEN 2
     NUMCOLOR = 2
     RETURN

EGA:
     XMAX = 640
     YMAX = 350
     SCREEN 9
     NUMCOLOR = 16
     RETURN

MCGA:
     XMAX = 640
     YMAX = 480
     SCREEN 11
     NUMCOLOR = 2
     RETURN

ATT:
     XMAX = 640
     YMAX = 400
     SCREEN 4
     NUMCOLOR = 2
     RETURN

HERCULES:
     XMAX = 720
     YMAX = 348
     SCREEN 3
     NUMCOLOR = 2
     RETURN

