#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Debug (X,Y,Numpt,NumCrv,term)


******************************************************************
*                                                                *
*   Subroutine Debug_Mode                                        *
*                                                                *
*     This subroutine allows the user to dump the contents       *
*     of the X and Y arrays containing the real coordinates      *
*     to be plotted.  If the user has selected to plot           *
*     multiple curves then the user may specify which data       *
*     to display.                                                *
*                                                                *
******************************************************************


        Integer   nlines, curve, count
        Parameter (nlines = 17)

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Character dummy
        Real      X(max,num), Y(max,num)
        Integer   NumCrv, Numpt(num), term, I


        IF (NumCrv .GT. 1) THEN
          curve = 0
  100     IF (curve .LE. 0 .OR. curve .GT. NumCrv) THEN
    1       CALL clear(term)
            Write (*,10) NumCrv
   10       Format (/15x,'Debug Data',//5x,'Which curve do ',
     +                    'you wish to see? (1-',i1,')?')
            Read(*,'(i1)',err=1,end=1) curve
            GOTO 100
          ENDIF
        ELSE
*         (* Initialize the default curve to the first one. *)
          curve = 1
        ENDIF

*       (* Set the number of lines printed to zero. *)
        count = 0
  200   IF (count .LT. Numpt(curve)) THEN
          CALL clear(term)
          Write (*,20) curve, curve
   20     Format (17x,'X',I1,13x,'Y',I1,/,5x,35('-'))

          DO 300 I = 1, nlines
            count = count + 1
            IF (count .LE. Numpt(curve)) THEN
              Write (*,30) count, X(count,curve), Y(count,curve)
   30         Format (5x, 1I3, 5x, 1G11.4, 5x, 1G11.4)
            ELSE
              Write (*,40)
   40         Format (' ')
            ENDIF
  300     CONTINUE

          Write (*,50)
   50     Format (/,5x,'Press <return> to continue or <q> to quit ...')
          Read (*,'(a1)',err=200,end=200) dummy

*         (* Check to see if the user wants to quit. *)
          IF (dummy .EQ. 'Q' .OR. dummy .EQ. 'q') count = Numpt(curve)

          GOTO 200
        ENDIF

        RETURN
        END
