/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.io;

import gnu.prolog.io.PrologStream;
import gnu.prolog.io.WriteOptions;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class Predicate_write_term
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        PrologStream stream = interpreter.getEnvironment().resolveStream(args[0]);
        Term optionsList = args[2];
        WriteOptions options = new WriteOptions(interpreter.getEnvironment().getOperatorSet());
        Term cur = optionsList;
        while (cur != TermConstants.emptyListAtom) {
            Term val;
            if (cur instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (!(cur instanceof CompoundTerm)) {
                PrologException.typeError(TermConstants.listAtom, optionsList);
            }
            CompoundTerm ct = (CompoundTerm)cur;
            if (ct.tag != TermConstants.listTag) {
                PrologException.typeError(TermConstants.listAtom, optionsList);
            }
            Term head = ct.args[0].dereference();
            cur = ct.args[1].dereference();
            if (head instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (!(head instanceof CompoundTerm)) {
                PrologException.domainError(TermConstants.readOptionAtom, head);
            }
            CompoundTerm op = (CompoundTerm)head;
            if (op.tag == TermConstants.quotedTag) {
                val = op.args[0].dereference();
                if (val != TermConstants.trueAtom && val != TermConstants.falseAtom) {
                    PrologException.domainError(TermConstants.readOptionAtom, head);
                }
                options.quoted = val == TermConstants.trueAtom;
                continue;
            }
            if (op.tag == TermConstants.ignoreOpsTag) {
                val = op.args[0].dereference();
                if (val != TermConstants.trueAtom && val != TermConstants.falseAtom) {
                    PrologException.domainError(TermConstants.readOptionAtom, head);
                }
                options.ignoreOps = val == TermConstants.trueAtom;
                continue;
            }
            if (op.tag == TermConstants.numbervarsTag) {
                val = op.args[0].dereference();
                if (val != TermConstants.trueAtom && val != TermConstants.falseAtom) {
                    PrologException.domainError(TermConstants.readOptionAtom, head);
                }
                options.numbervars = val == TermConstants.trueAtom;
                continue;
            }
            PrologException.domainError(TermConstants.writeOptionAtom, head);
        }
        stream.writeTerm(args[0], interpreter, options, args[1]);
        return 1;
    }
}

