/****************************************************************************
 *
 * Class:  Registrar
 * Author: Mark Roseman
 * 
 * The Registrar maintains the global registration information for all
 * active conferences.  It uses the data structure ConferenceList to do
 * this, as well as the RegReader and RegWriter to communicate with
 * various registrar clients.  Note the Registrar is quite "dumb",
 * honoring any request, thereby requiring the registrar clients to
 * establish any registration protocols.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/17/92 MR        initial version
 * 08/14/92 MR        clean up
 * 09/17/92 MR        added callback for reader connection close
 * 09/20/92 MR        changed to work on specific port
 *
 ****************************************************************************/

#ifndef __registrar_h
#define __registrar_h

#include <Dispatch/rpcpeer.h>
#include <OS/list.h>


#include <gk/attrlist.h>



class Registrar : public RpcPeer {
public:

  /* 
  ** constructor / destructor 
  */
  Registrar(int port);
  virtual ~Registrar();

protected:
  
  AttrListTable* conference_tbl_;
  UserListTbl* users_tbl_;
  int lastID_;
  
  virtual void createReaderAndWriter(int fd);
  void closeCallback(class CallbackRpcReader*, int);
  class ConnectionList* connlist_;

  void new_conference(char *msg);
  void delete_conference(char *msg);
  void disp_conference(char *msg);
  void add_user(char *msg);
  void delete_user(char *msg);
  void display_users(char *msg);
};

#endif



