/****************************************************************************
 *
 * Classes: SlaveRegClient
 * Author:  Mark Roseman
 *
 * Do a "slave" registrar client, suitable for use by a user in a strictly
 * facilitated conference.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 10/13/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __slaverc_h
#define __slaverc_h

#include <gk-reg/regclient.h>

class SlaveRegClient : public RegistrarClient {
public:
  SlaveRegClient(const char* host, int port, class Coordinator*);
  virtual void userLeft(int conf_id, int user_id);
protected:
  virtual void foundNewConference(AttributeList*);
  virtual void foundDeletedConference(int);
  virtual void foundNewUser(AttributeList*);
  virtual void foundDeletedUser(int,int);

  void selected_conf();
  void update_browser();
  boolean connected_;
  class StringBrowser* confs_;
  class WidgetKit* kit_;
  class Window* tw_;
  class Patch* patch_;
  class IntTable* cnum_;
};

#endif
