/**************************************************************************
 * 
 * Glyph with just empty space.
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include "emptyglyph.h"
#include <InterViews/background.h>
#include <IV-look/kit.h>
#include <InterViews/layout.h>
#include <InterViews/bitmap.h>
#include <InterViews/stencil.h>
#include <InterViews/color.h>


EmptyGlyph::EmptyGlyph(Style* style, Conference* conf, int x, int y) : 
        ConferenceGlyph(nil, style, conf)
{
  Bitmap* bit = new Bitmap( (const void *)nil, x, y);
  for (int i=0; i < x; i++)
    for (int j=0; j < y; j++) 
      bit->poke(0,x,y);
  body( new Background( new Stencil( bit, new Color(1,1,1)), 
		       WidgetKit::instance()->background()));
}

